/*
 * Decompiled with CFR 0.152.
 */
package com.jalvaviel.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jalvaviel.MapMipMapModClient;
import com.jalvaviel.config.enums.InvisibleFrames;
import com.jalvaviel.config.enums.MapUpdates;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class MmmmGameOptions {
    private static final String DEFAULT_FILE_NAME = "mapmipmapmod-options.json";
    public static final class_2561 ONLY_UNLOCKED_MAP_UPDATES_TOOLTIP = class_2561.method_43471((String)"tooltip.mapmipmapmod.map_updates_only_unlocked");
    public static final class_2561 ALL_MAP_UPDATES_TOOLTIP = class_2561.method_43471((String)"tooltip.mapmipmapmod.map_updates_all");
    public static final class_2561 NONE_MAP_UPDATES_TOOLTIP = class_2561.method_43471((String)"tooltip.mapmipmapmod.map_updates_none");
    public static final class_2561 DEFAULT_INVISIBLE_FRAMES_TOOLTIP = class_2561.method_43471((String)"tooltip.mapmipmapmod.invisible_frames_default");
    public static final class_2561 ALL_INVISIBLE_FRAMES_TOOLTIP = class_2561.method_43471((String)"tooltip.mapmipmapmod.invisible_frames_all");
    public static final class_2561 ONLY_MAPS_INVISIBLE_FRAMES_TOOLTIP = class_2561.method_43471((String)"tooltip.mapmipmapmod.invisible_frames_only_maps");
    public final GeneralOptions generalOptions = new GeneralOptions();
    private boolean readOnly;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();

    private MmmmGameOptions() {
    }

    @Contract(value=" -> new")
    @NotNull
    public static MmmmGameOptions defaults() {
        return new MmmmGameOptions();
    }

    public static MmmmGameOptions loadFromDisk() {
        MmmmGameOptions config;
        block10: {
            Path path = MmmmGameOptions.getConfigPath();
            if (Files.exists(path, new LinkOption[0])) {
                try (FileReader reader = new FileReader(path.toFile());){
                    config = (MmmmGameOptions)GSON.fromJson((Reader)reader, MmmmGameOptions.class);
                    break block10;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not parse config", e);
                }
            }
            config = new MmmmGameOptions();
        }
        try {
            MmmmGameOptions.writeToDisk(config);
            return config;
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't update config file", e);
        }
    }

    @NotNull
    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve(DEFAULT_FILE_NAME);
    }

    public static void writeToDisk(@NotNull MmmmGameOptions config) throws IOException {
        if (config.isReadOnly()) {
            throw new IllegalStateException("Config file is read-only");
        }
        Path path = MmmmGameOptions.getConfigPath();
        Path dir = path.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Not a directory: " + String.valueOf(dir));
        }
        MmmmGameOptions.writeTextRobustly(GSON.toJson((Object)config), path);
    }

    private static void writeTextRobustly(String text, @NotNull Path path) throws IOException {
        Path tempPath = path.resolveSibling(String.valueOf(path.getFileName()) + ".tmp");
        Files.writeString(tempPath, (CharSequence)text, new OpenOption[0]);
        Files.move(tempPath, path, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    @Environment(value=EnvType.CLIENT)
    public static class GeneralOptions {
        private int mapmipmapLevels = -1;
        private int atlasSize = 0;
        private int depthBias = 1;
        private InvisibleFrames invisibleFrames = InvisibleFrames.DEFAULT;
        private MapUpdates mapUpdates = MapUpdates.ONLY_UNLOCKED;

        public int getMapmipmapLevels() {
            return MapMipMapModClient.OUTDATED_DRIVER ? 0 : (this.mapmipmapLevels <= -1 ? (Integer)class_310.method_1551().field_1690.method_42563().method_41753() : this.mapmipmapLevels);
        }

        public int getLiteralMapmipmapLevels() {
            return this.mapmipmapLevels;
        }

        public int getAtlasSize() {
            return this.atlasSize <= 0 ? 2048 - this.getMapmipmapLevels() * 128 : this.atlasSize * MapMipMapModClient.MAP_SIZE;
        }

        public int getLiteralAtlasSize() {
            return this.atlasSize;
        }

        public void setMapmipmapLevels(int mapmipmapLevels) {
            this.mapmipmapLevels = mapmipmapLevels;
        }

        public void setAtlasSize(int atlasSize) {
            this.atlasSize = atlasSize;
        }

        public void setDepthBias(int depthBias) {
            this.depthBias = depthBias;
        }

        public int getDepthBias() {
            return this.depthBias;
        }

        public InvisibleFrames getInvisibleFrames() {
            return this.invisibleFrames;
        }

        public void setInvisibleFrames(InvisibleFrames invisibleFrames) {
            this.invisibleFrames = invisibleFrames;
        }

        public MapUpdates getMapUpdates() {
            return this.mapUpdates;
        }

        public void setMapUpdates(MapUpdates mapUpdates) {
            this.mapUpdates = mapUpdates;
        }
    }
}

