/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.config.keys;

import net.minecraft.class_3675;
import net.xolt.freecam.config.keys.FreecamKeyMapping;
import net.xolt.freecam.config.keys.HoldAction;

class FreecamComboKeyMapping
extends FreecamKeyMapping {
    private final Runnable action;
    private final HoldAction holdAction;
    private final long maxHoldTicks;
    private long sinceLastUse = 0L;
    private long sinceLastPress = 0L;
    private long queued = 0L;

    FreecamComboKeyMapping(String translationKey, class_3675.class_307 type, int code, Runnable action, HoldAction holdAction, long maxHoldTicks) {
        super(translationKey, type, code);
        this.action = action;
        this.holdAction = holdAction;
        this.maxHoldTicks = maxHoldTicks;
    }

    @Override
    public void method_4622() {
        ++this.sinceLastUse;
        ++this.sinceLastPress;
        if (this.method_1434()) {
            if (this.holdAction.run()) {
                this.markUsed();
            }
        } else {
            while (this.dequeue()) {
                this.action.run();
            }
        }
    }

    public void method_23481(boolean down) {
        if (down != this.method_1434()) {
            if (down) {
                this.keyDown();
            } else {
                this.keyUp();
            }
        }
        super.method_23481(down);
    }

    private void keyDown() {
        this.sinceLastPress = 0L;
    }

    private void keyUp() {
        if (this.sinceLastUse > this.sinceLastPress && this.sinceLastPress < this.maxHoldTicks) {
            ++this.queued;
        }
        this.markUsed();
    }

    private void markUsed() {
        this.sinceLastUse = 0L;
    }

    private boolean dequeue() {
        if (this.queued < 1L) {
            return false;
        }
        --this.queued;
        return true;
    }
}

