/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fionathemortal.betterbiomeblend.common.cache;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.concurrent.locks.StampedLock;
import neoforge.fionathemortal.betterbiomeblend.common.BlendConfig;
import neoforge.fionathemortal.betterbiomeblend.common.ColorCaching;
import neoforge.fionathemortal.betterbiomeblend.common.cache.Slice;

public abstract class SliceCache<T extends Slice> {
    public static final int BUCKET_COUNT = 8;
    public final Long2ObjectLinkedOpenHashMap<T>[] hashList;
    public final StampedLock[] lockList;
    public final int sliceCount;
    public int sliceSize;

    public abstract T newSlice(int var1, int var2);

    public SliceCache(int count) {
        int hashIndex;
        this.sliceCount = count;
        int countPerHash = count / 8;
        this.hashList = new Long2ObjectLinkedOpenHashMap[8];
        for (hashIndex = 0; hashIndex < 8; ++hashIndex) {
            this.hashList[hashIndex] = new Long2ObjectLinkedOpenHashMap(countPerHash);
        }
        this.lockList = new StampedLock[8];
        for (hashIndex = 0; hashIndex < 8; ++hashIndex) {
            this.lockList[hashIndex] = new StampedLock();
        }
    }

    public final void reallocSlices(int sliceSize) {
        this.sliceSize = sliceSize;
        int countPerHash = this.sliceCount / 8;
        for (int hashIndex = 0; hashIndex < 8; ++hashIndex) {
            StampedLock lock = this.lockList[hashIndex];
            Long2ObjectLinkedOpenHashMap<T> hash = this.hashList[hashIndex];
            long stamp = lock.writeLock();
            hash.clear();
            for (int index = 0; index < countPerHash; ++index) {
                T slice = this.newSlice(sliceSize, index);
                hash.put(((Slice)slice).key, slice);
            }
            lock.unlockWrite(stamp);
        }
    }

    public final void invalidateAll(int blendRadius) {
        this.sliceSize = BlendConfig.getSliceSize(blendRadius);
        this.reallocSlices(this.sliceSize);
    }

    private int getBucketIndex(int x, int y, int z) {
        int result = (x ^ y ^ z) & 7;
        return result;
    }

    public final void releaseSlice(T slice) {
        ((Slice)slice).release();
    }

    public final T getOrInitSlice(int sliceSize, int sliceX, int sliceY, int sliceZ, int colorType, boolean tryLock) {
        long key = ColorCaching.getChunkKey(sliceX, sliceY, sliceZ, colorType);
        int bucket = this.getBucketIndex(sliceX, sliceY, sliceZ);
        StampedLock lock = this.lockList[bucket];
        Long2ObjectLinkedOpenHashMap<T> hash = this.hashList[bucket];
        Slice slice = null;
        long stamp = 0L;
        stamp = tryLock ? lock.tryWriteLock() : lock.writeLock();
        if (stamp != 0L) {
            slice = (Slice)hash.getAndMoveToFirst(key);
            if (slice == null) {
                while ((slice = (Slice)hash.removeLast()).getRefCount() != 0) {
                    hash.putAndMoveToFirst(slice.key, (Object)slice);
                }
                slice.key = key;
                slice.invalidateData();
                hash.putAndMoveToFirst(slice.key, (Object)slice);
            }
            if (slice.size == sliceSize) {
                slice.acquire();
            } else {
                slice = this.newSlice(sliceSize, 0);
            }
            lock.unlockWrite(stamp);
        }
        return (T)slice;
    }
}

