/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fionathemortal.betterbiomeblend.common;

public final class BlendConfig {
    public static final int BIOME_BLEND_RADIUS_MIN = 0;
    public static final int BIOME_BLEND_RADIUS_MAX = 14;
    public static final byte[] blendRadiusConfig = new byte[]{2, 0, 3, 0, 3, 1, 3, 1, 3, 1, 3, 1, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2};

    public static int getSliceSizeLog2(int blendRadius) {
        byte result = blendRadiusConfig[blendRadius << 1];
        return result;
    }

    public static int getBlockSizeLog2(int blendRadius) {
        byte result = blendRadiusConfig[(blendRadius << 1) + 1];
        return result;
    }

    public static int getSliceSize(int blendRadius) {
        int result = 1 << BlendConfig.getSliceSizeLog2(blendRadius);
        return result;
    }

    public static int getBlendSize(int blendRadius) {
        int blockSizeLog2 = BlendConfig.getBlockSizeLog2(blendRadius);
        int sliceSizeLog2 = BlendConfig.getSliceSizeLog2(blendRadius);
        int blockSize = 1 << blockSizeLog2;
        int sliceSize = 1 << sliceSizeLog2;
        int blendSize = sliceSize + 2 * blendRadius;
        int scaledBlendSize = blendSize >> blockSizeLog2;
        return scaledBlendSize;
    }

    public static int getBlendBufferSize(int blendRadius) {
        int blendSize = BlendConfig.getBlendSize(blendRadius);
        int sliceSize = BlendConfig.getSliceSize(blendRadius);
        int result = Math.max(blendSize, sliceSize);
        return result;
    }

    public static int getFilterSupport(int blendRadius) {
        int sliceSizeLog2 = BlendConfig.getSliceSizeLog2(blendRadius);
        int blockSizeLog2 = BlendConfig.getBlockSizeLog2(blendRadius);
        int sliceSize = 1 << sliceSizeLog2;
        int blendDim = BlendConfig.getBlendSize(blendRadius);
        int scaledSliceSize = sliceSize >> blockSizeLog2;
        int filterSupport = blendDim - scaledSliceSize + 1;
        return filterSupport;
    }
}

