/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fionathemortal.betterbiomeblend.common;

import neoforge.fionathemortal.betterbiomeblend.common.BlendConfig;

public final class BlendBuffer {
    public final float[] color;
    public final float[] blend;
    public final float[] sum;
    public final int blendRadius;
    public final int sliceSizeLog2;
    public final int blockSizeLog2;
    public final int sliceSize;
    public final int blockSize;
    public final int blendSize;
    public final int blendBufferSize;
    public final int scaledBlendDiameter;
    public int colorBitsExclusive;
    public int colorBitsInclusive;

    public BlendBuffer(int blendRadius) {
        this.blendRadius = blendRadius;
        this.sliceSizeLog2 = BlendConfig.getSliceSizeLog2(blendRadius);
        this.blockSizeLog2 = BlendConfig.getBlockSizeLog2(blendRadius);
        this.sliceSize = 1 << this.sliceSizeLog2;
        this.blockSize = 1 << this.blockSizeLog2;
        this.blendSize = BlendConfig.getBlendSize(blendRadius);
        this.blendBufferSize = BlendConfig.getBlendBufferSize(blendRadius);
        this.scaledBlendDiameter = 2 * blendRadius >> this.blockSizeLog2;
        this.color = new float[3 * this.blendBufferSize * this.blendBufferSize * this.blendBufferSize];
        this.blend = new float[3 * this.blendBufferSize * this.blendBufferSize];
        this.sum = new float[3 * this.blendBufferSize * this.blendBufferSize];
        this.colorBitsExclusive = -1;
        this.colorBitsInclusive = 0;
    }
}

