/*
 * Decompiled with CFR 0.152.
 */
package fabric.fionathemortal.betterbiomeblend.mixin;

import fabric.fionathemortal.betterbiomeblend.BetterBiomeBlendClient;
import fabric.fionathemortal.betterbiomeblend.common.BlendCache;
import fabric.fionathemortal.betterbiomeblend.common.BlendChunk;
import fabric.fionathemortal.betterbiomeblend.common.ColorBlending;
import fabric.fionathemortal.betterbiomeblend.common.ColorCaching;
import fabric.fionathemortal.betterbiomeblend.common.CustomColorResolverCompatibility;
import fabric.fionathemortal.betterbiomeblend.common.LocalCache;
import fabric.fionathemortal.betterbiomeblend.common.cache.ColorCache;
import fabric.fionathemortal.betterbiomeblend.common.debug.Debug;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.function.Supplier;
import net.minecraft.class_1163;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2874;
import net.minecraft.class_3695;
import net.minecraft.class_4700;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_638.class})
public abstract class MixinClientWorld
extends class_1937 {
    @Shadow
    private final Object2ObjectArrayMap<class_6539, class_4700> field_21527 = new Object2ObjectArrayMap();
    @Unique
    public final BlendCache betterBiomeBlend$blendColorCache = new BlendCache(1024);
    @Unique
    public final ColorCache betterBiomeBlend$chunkColorCache = new ColorCache(1024);
    @Unique
    private final ThreadLocal<LocalCache> betterBiomeBlend$threadLocalCache = ThreadLocal.withInitial(LocalCache::new);

    protected MixinClientWorld(class_5269 writableLevelData, class_5321<class_1937> resourceKey, class_5455 registryAccess, class_6880<class_2874> holder, Supplier<class_3695> supplier, boolean bl, boolean bl2, long l, int i) {
        super(writableLevelData, resourceKey, registryAccess, holder, supplier, bl, bl2, l, i);
    }

    @Inject(method={"clearTintCaches"}, at={@At(value="HEAD")})
    public void onClearColorCaches(CallbackInfo ci) {
        this.betterBiomeBlend$blendColorCache.invalidateAll();
        int blendRadius = BetterBiomeBlendClient.getBiomeBlendRadius();
        this.betterBiomeBlend$chunkColorCache.invalidateAll(blendRadius);
    }

    @Inject(method={"onChunkLoaded"}, at={@At(value="HEAD")})
    public void onOnChunkLoaded(class_1923 chunkPos, CallbackInfo ci) {
        int chunkX = chunkPos.field_9181;
        int chunkZ = chunkPos.field_9180;
        this.betterBiomeBlend$blendColorCache.invalidateChunk(chunkX, chunkZ);
    }

    @Inject(method={"getBlockTint"}, at={@At(value="HEAD")}, cancellable=true)
    public void getBlockTint(class_2338 blockPosIn, class_6539 colorResolverIn, CallbackInfoReturnable<Integer> cir) {
        int index;
        int color;
        int colorType;
        int x = blockPosIn.method_10263();
        int y = blockPosIn.method_10264();
        int z = blockPosIn.method_10260();
        int chunkX = x >> 4;
        int chunkY = y >> 4;
        int chunkZ = z >> 4;
        int blockX = x & 0xF;
        int blockY = y & 0xF;
        int blockZ = z & 0xF;
        LocalCache localCache = this.betterBiomeBlend$threadLocalCache.get();
        BlendChunk chunk = null;
        if (localCache.lastColorResolver == colorResolverIn) {
            colorType = localCache.lastColorType;
            key = ColorCaching.getChunkKey(chunkX, chunkY, chunkZ, colorType);
            if (localCache.lastBlendChunk.key == key) {
                chunk = localCache.lastBlendChunk;
            }
        } else {
            if (colorResolverIn == class_1163.field_5665) {
                colorType = 0;
            } else if (colorResolverIn == class_1163.field_5666) {
                colorType = 1;
            } else if (colorResolverIn == class_1163.field_5664) {
                colorType = 2;
            } else {
                colorType = CustomColorResolverCompatibility.getColorType(colorResolverIn);
                if (colorType >= localCache.blendChunkCount) {
                    localCache.growBlendChunkArray(colorType);
                }
            }
            key = ColorCaching.getChunkKey(chunkX, chunkY, chunkZ, colorType);
            BlendChunk cachedChunk = localCache.blendChunks[colorType];
            if (cachedChunk.key == key) {
                chunk = cachedChunk;
            }
        }
        Debug.countThreadLocalChunk(chunk);
        if (chunk == null) {
            chunk = this.betterBiomeBlend$blendColorCache.getOrInitChunk(chunkX, chunkY, chunkZ, colorType);
            localCache.putChunk(this.betterBiomeBlend$blendColorCache, chunk, colorType, colorResolverIn);
        }
        if ((color = chunk.data[index = ColorCaching.getArrayIndex(16, blockX, blockY, blockZ)]) == 0) {
            ColorBlending.generateColors(this, colorResolverIn, colorType, this.betterBiomeBlend$chunkColorCache, chunk, x, y, z);
            color = chunk.data[index];
        }
        cir.setReturnValue((Object)color);
    }
}

