/*
 * Decompiled with CFR 0.152.
 */
package fabric.fionathemortal.betterbiomeblend.common;

import fabric.fionathemortal.betterbiomeblend.BetterBiomeBlendClient;
import fabric.fionathemortal.betterbiomeblend.common.BlendBuffer;
import fabric.fionathemortal.betterbiomeblend.common.BlendChunk;
import fabric.fionathemortal.betterbiomeblend.common.BlendConfig;
import fabric.fionathemortal.betterbiomeblend.common.Color;
import fabric.fionathemortal.betterbiomeblend.common.ColorCaching;
import fabric.fionathemortal.betterbiomeblend.common.Random;
import fabric.fionathemortal.betterbiomeblend.common.Utility;
import fabric.fionathemortal.betterbiomeblend.common.cache.ColorCache;
import fabric.fionathemortal.betterbiomeblend.common.cache.ColorSlice;
import fabric.fionathemortal.betterbiomeblend.common.debug.Debug;
import fabric.fionathemortal.betterbiomeblend.common.debug.DebugEvent;
import fabric.fionathemortal.betterbiomeblend.common.debug.DebugEventType;
import java.util.Arrays;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_6539;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public final class ColorBlending {
    public static final int SAMPLE_SEED_X = 1664525;
    public static final int SAMPLE_SEED_Y = 214013;
    public static final int SAMPLE_SEED_Z = 16807;
    public static final ThreadLocal<BlendBuffer> threadLocalBlendBuffer = new ThreadLocal();

    public static BlendBuffer acquireBlendBuffer(int blendRadius) {
        BlendBuffer buffer = threadLocalBlendBuffer.get();
        BlendBuffer result = buffer != null && buffer.blendRadius == blendRadius ? buffer : new BlendBuffer(blendRadius);
        result.colorBitsExclusive = -1;
        result.colorBitsInclusive = 0;
        return result;
    }

    public static void releaseBlendBuffer(BlendBuffer buffer) {
        threadLocalBlendBuffer.set(buffer);
    }

    public static int getSliceMin(int blendRadius, int blockSizeLog2, int sliceSizeLog2, int sliceIndex) {
        int sliceSize = 1 << sliceSizeLog2;
        int scaledSliceSize = sliceSize >> blockSizeLog2;
        int scaledBlendDiameter = 2 * blendRadius >> blockSizeLog2;
        int scaledLowerBlendRadius = scaledBlendDiameter - (scaledBlendDiameter >> 1);
        int result = 0;
        if (sliceIndex == -1) {
            result = scaledSliceSize - scaledLowerBlendRadius;
        }
        return result;
    }

    public static int getSliceMax(int blendRadius, int blockSizeLog2, int sliceSizeLog2, int sliceIndex) {
        int sliceSize = 1 << sliceSizeLog2;
        int scaledSliceSize = sliceSize >> blockSizeLog2;
        int scaledBlendDiameter = 2 * blendRadius >> blockSizeLog2;
        int scaledUpperBlendRadius = scaledBlendDiameter >> 1;
        int result = scaledSliceSize;
        if (sliceIndex == 1) {
            result = scaledUpperBlendRadius;
        }
        return result;
    }

    public static int getBlendMin(int blendRadius, int blockSizeLog2, int sliceSizeLog2, int sliceIndex) {
        int sliceSize = 1 << sliceSizeLog2;
        int scaledSliceSize = sliceSize >> blockSizeLog2;
        int scaledBlendDiameter = 2 * blendRadius >> blockSizeLog2;
        int scaledLowerBlendRadius = scaledBlendDiameter - (scaledBlendDiameter >> 1);
        int result = 0;
        if (sliceIndex >= 0) {
            result += scaledLowerBlendRadius;
            if (sliceIndex == 1) {
                result += scaledSliceSize;
            }
        }
        return result;
    }

    public static class_1959 getDefaultBiome(class_1937 world) {
        class_1959 result = null;
        class_6880.class_6883 biomeHolder = world.method_30349().method_30530(class_7924.field_41236).method_40290(class_1972.field_9451);
        if (biomeHolder.method_40227()) {
            result = (class_1959)biomeHolder.comp_349();
        }
        return result;
    }

    public static class_1959 getBiomeAtPositionOrDefault(class_1937 world, class_2338 blockPosition) {
        class_6880 biomeHolder = world.method_23753(blockPosition);
        class_1959 result = biomeHolder.method_40227() ? (class_1959)biomeHolder.comp_349() : ColorBlending.getDefaultBiome(world);
        return result;
    }

    public static class_1959 getBiomeAtPositionOrDefaultOrThrow(class_1937 world, class_2338 blockPos) {
        class_1959 result = ColorBlending.getBiomeAtPositionOrDefault(world, blockPos);
        if (result == null) {
            throw new IllegalStateException("Biome could not be retrieved for block position.");
        }
        return result;
    }

    public static int getColorAtPosition(class_1937 world, class_2338 blockPos, float posX, float posZ, class_6539 colorResolver) {
        class_1959 biome = ColorBlending.getBiomeAtPositionOrDefaultOrThrow(world, blockPos);
        int result = colorResolver.getColor(biome, (double)posX, (double)posZ);
        return result;
    }

    public static int getRandomSamplePosition(int min, int blockSizeLog2, int seed) {
        int blockMask = Utility.lowerBitMask(blockSizeLog2);
        int random = Random.noise(min, seed);
        int offset = random & blockMask;
        int result = min + offset;
        return result;
    }

    public static void gatherColorsForSlice(class_1937 world, class_6539 colorResolver, ColorSlice colorSlice, BlendBuffer blendBuffer, int sliceIDX, int sliceIDY, int sliceIDZ, int sliceX, int sliceY, int sliceZ) {
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        int blendRadius = blendBuffer.blendRadius;
        int sliceSizeLog2 = blendBuffer.sliceSizeLog2;
        int blockSizeLog2 = blendBuffer.blockSizeLog2;
        int sliceSize = blendBuffer.sliceSize;
        int blendSize = blendBuffer.blendBufferSize;
        int sliceMinX = ColorBlending.getSliceMin(blendRadius, blockSizeLog2, sliceSizeLog2, sliceIDX);
        int sliceMinY = ColorBlending.getSliceMin(blendRadius, blockSizeLog2, sliceSizeLog2, sliceIDY);
        int sliceMinZ = ColorBlending.getSliceMin(blendRadius, blockSizeLog2, sliceSizeLog2, sliceIDZ);
        int sliceMaxX = ColorBlending.getSliceMax(blendRadius, blockSizeLog2, sliceSizeLog2, sliceIDX);
        int sliceMaxY = ColorBlending.getSliceMax(blendRadius, blockSizeLog2, sliceSizeLog2, sliceIDY);
        int sliceMaxZ = ColorBlending.getSliceMax(blendRadius, blockSizeLog2, sliceSizeLog2, sliceIDZ);
        int blendMinX = ColorBlending.getBlendMin(blendRadius, blockSizeLog2, sliceSizeLog2, sliceIDX);
        int blendMinY = ColorBlending.getBlendMin(blendRadius, blockSizeLog2, sliceSizeLog2, sliceIDY);
        int blendMinZ = ColorBlending.getBlendMin(blendRadius, blockSizeLog2, sliceSizeLog2, sliceIDZ);
        int dimX = sliceMaxX - sliceMinX;
        int dimY = sliceMaxY - sliceMinY;
        int dimZ = sliceMaxZ - sliceMinZ;
        int worldMinX = (sliceX << sliceSizeLog2) + (sliceMinX << blockSizeLog2);
        int worldMinY = (sliceY << sliceSizeLog2) + (sliceMinY << blockSizeLog2);
        int worldMinZ = (sliceZ << sliceSizeLog2) + (sliceMinZ << blockSizeLog2);
        if ((blendBuffer.scaledBlendDiameter & 1) != 0 && blockSizeLog2 > 0) {
            worldMinX += 1 << blockSizeLog2 - 1;
            worldMinY += 1 << blockSizeLog2 - 1;
            worldMinZ += 1 << blockSizeLog2 - 1;
        }
        int sliceIndexZ = ColorCaching.getArrayIndex(sliceSize, sliceMinX, sliceMinY, sliceMinZ);
        int blendIndexZ = 3 * ColorCaching.getArrayIndex(blendSize, blendMinX, blendMinY, blendMinZ);
        for (int z = 0; z < dimZ; ++z) {
            int sliceIndexY = sliceIndexZ;
            int blendIndexY = blendIndexZ;
            for (int y = 0; y < dimY; ++y) {
                int sliceIndex = sliceIndexY;
                int blendIndex = blendIndexY;
                for (int x = 0; x < dimX; ++x) {
                    int cachedColor = colorSlice.data[sliceIndex];
                    if (cachedColor == 0) {
                        int sampleMinX = worldMinX + (x << blockSizeLog2);
                        int sampleMinY = worldMinY + (y << blockSizeLog2);
                        int sampleMinZ = worldMinZ + (z << blockSizeLog2);
                        int sampleX = ColorBlending.getRandomSamplePosition(sampleMinX, blockSizeLog2, 1664525);
                        int sampleY = ColorBlending.getRandomSamplePosition(sampleMinY, blockSizeLog2, 214013);
                        int sampleZ = ColorBlending.getRandomSamplePosition(sampleMinZ, blockSizeLog2, 16807);
                        blockPos.method_10103(sampleX, sampleY, sampleZ);
                        colorSlice.data[sliceIndex] = cachedColor = ColorBlending.getColorAtPosition(world, (class_2338)blockPos, sampleX, sampleZ, colorResolver);
                    }
                    Color.sRGBByteToOKLabs(cachedColor, blendBuffer.color, blendIndex);
                    blendBuffer.colorBitsExclusive &= cachedColor;
                    blendBuffer.colorBitsInclusive |= cachedColor;
                    ++sliceIndex;
                    blendIndex += 3;
                }
                sliceIndexY += sliceSize;
                blendIndexY += 3 * blendSize;
            }
            sliceIndexZ += sliceSize * sliceSize;
            blendIndexZ += 3 * blendSize * blendSize;
        }
    }

    private static void setColorBitsToCenterColor(class_1937 world, class_6539 colorResolver, BlendBuffer blendBuffer, int sliceX, int sliceY, int sliceZ) {
        int color;
        int centerX = (sliceX << blendBuffer.sliceSizeLog2) + (1 << blendBuffer.sliceSizeLog2 - 1);
        int centerY = (sliceY << blendBuffer.sliceSizeLog2) + (1 << blendBuffer.sliceSizeLog2 - 1);
        int centerZ = (sliceZ << blendBuffer.sliceSizeLog2) + (1 << blendBuffer.sliceSizeLog2 - 1);
        class_2338 blockPos = new class_2338(centerX, centerY, centerZ);
        blendBuffer.colorBitsInclusive = color = ColorBlending.getColorAtPosition(world, blockPos, centerX, centerZ, colorResolver);
        blendBuffer.colorBitsExclusive = color;
    }

    public static boolean neighborChunksAreLoaded(class_1937 world, int sliceSizeLog2, int sliceX, int sliceZ) {
        boolean result = true;
        int prevChunkX = Integer.MAX_VALUE;
        int prevChunkZ = Integer.MAX_VALUE;
        for (int sliceOffsetZ = -1; sliceOffsetZ <= 1; ++sliceOffsetZ) {
            int neighborSliceZ = sliceZ + sliceOffsetZ;
            int neighborChunkZ = neighborSliceZ >> 4 - sliceSizeLog2;
            if (neighborChunkZ != prevChunkZ) {
                for (int sliceOffsetX = -1; sliceOffsetX <= 1; ++sliceOffsetX) {
                    class_2791 chunk;
                    int neighborSliceX = sliceX + sliceOffsetX;
                    int neighborChunkX = neighborSliceX >> 4 - sliceSizeLog2;
                    if (neighborChunkX != prevChunkX && (chunk = world.method_8402(neighborChunkX, neighborChunkZ, class_2806.field_12794, false)) == null) {
                        result = false;
                        break;
                    }
                    prevChunkX = neighborChunkX;
                }
            }
            prevChunkZ = neighborChunkZ;
        }
        return result;
    }

    public static void gatherColorsToBlendBuffer(class_1937 world, class_6539 colorResolver, int colorType, ColorCache colorCache, BlendBuffer blendBuffer, int x, int y, int z) {
        int sliceX = x >> blendBuffer.sliceSizeLog2;
        int sliceY = y >> blendBuffer.sliceSizeLog2;
        int sliceZ = z >> blendBuffer.sliceSizeLog2;
        boolean neighborsAreLoaded = ColorBlending.neighborChunksAreLoaded(world, blendBuffer.sliceSizeLog2, sliceX, sliceZ);
        if (neighborsAreLoaded) {
            boolean[] finishedSlices = new boolean[27];
            int iterationCount = 2;
            for (int iteration = 0; iteration < 2; ++iteration) {
                boolean lastIteration = iteration + 1 == 2;
                boolean tryLock = !lastIteration;
                boolean hasMissingSlices = false;
                int sliceIndex = 0;
                for (int sliceOffsetZ = -1; sliceOffsetZ <= 1; ++sliceOffsetZ) {
                    for (int sliceOffsetY = -1; sliceOffsetY <= 1; ++sliceOffsetY) {
                        for (int sliceOffsetX = -1; sliceOffsetX <= 1; ++sliceOffsetX) {
                            if (!finishedSlices[sliceIndex]) {
                                int neighborSliceX = sliceX + sliceOffsetX;
                                int neighborSliceY = sliceY + sliceOffsetY;
                                int neighborSliceZ = sliceZ + sliceOffsetZ;
                                ColorSlice colorSlice = (ColorSlice)colorCache.getOrInitSlice(blendBuffer.sliceSize, neighborSliceX, neighborSliceY, neighborSliceZ, colorType, tryLock);
                                if (colorSlice != null) {
                                    ColorBlending.gatherColorsForSlice(world, colorResolver, colorSlice, blendBuffer, sliceOffsetX, sliceOffsetY, sliceOffsetZ, neighborSliceX, neighborSliceY, neighborSliceZ);
                                    colorCache.releaseSlice(colorSlice);
                                    finishedSlices[sliceIndex] = true;
                                } else {
                                    hasMissingSlices = true;
                                }
                            }
                            ++sliceIndex;
                        }
                    }
                }
                if (hasMissingSlices) {
                    continue;
                }
                break;
            }
        } else {
            ColorBlending.setColorBitsToCenterColor(world, colorResolver, blendBuffer, sliceX, sliceY, sliceZ);
        }
    }

    public static void blendColorsForSlice(BlendBuffer buffer, BlendChunk blendChunk, int inputX, int inputY, int inputZ) {
        int srcSize = BlendConfig.getBlendSize(buffer.blendRadius);
        int dstSize = BlendConfig.getSliceSize(buffer.blendRadius);
        int blendBufferDim = BlendConfig.getBlendBufferSize(buffer.blendRadius);
        int filterSupport = BlendConfig.getFilterSupport(buffer.blendRadius);
        int fullFilterDim = filterSupport - 1;
        int scaledDstSize = dstSize >> buffer.blockSizeLog2;
        int blockSize = buffer.blockSize;
        float oneOverBlockSize = 1.0f / (float)blockSize;
        float filter = (float)(filterSupport - 1) + oneOverBlockSize;
        float filterScalar = 1.0f / (filter * filter * filter);
        int sliceSizeLog2 = buffer.sliceSizeLog2;
        int sliceX = inputX >> sliceSizeLog2;
        int sliceY = inputY >> sliceSizeLog2;
        int sliceZ = inputZ >> sliceSizeLog2;
        int baseX = sliceX << sliceSizeLog2;
        int baseY = sliceY << sliceSizeLog2;
        int baseZ = sliceZ << sliceSizeLog2;
        int inChunkX = Utility.lowerBits(baseX, 4);
        int inChunkY = Utility.lowerBits(baseY, 4);
        int inChunkZ = Utility.lowerBits(baseZ, 4);
        int baseIndex = ColorCaching.getArrayIndex(16, inChunkX, inChunkY, inChunkZ);
        Arrays.fill(buffer.sum, 0.0f);
        int newBufferIndexZ = 0;
        int newResultIndexZ = baseIndex;
        for (int z = 0; z < srcSize; ++z) {
            int i;
            float upperB;
            float upperG;
            float upperR;
            float lowerB;
            float lowerG;
            float lowerR;
            int newIndexX = 0;
            for (int newX = 0; newX < srcSize; ++newX) {
                int newSrcIndexY = newIndexX + newBufferIndexZ;
                int newDstIndexY = newIndexX;
                float sumR = 0.0f;
                float sumG = 0.0f;
                float sumB = 0.0f;
                for (int newY = 0; newY < fullFilterDim; ++newY) {
                    sumR += buffer.color[newSrcIndexY];
                    sumG += buffer.color[newSrcIndexY + 1];
                    sumB += buffer.color[newSrcIndexY + 2];
                    newSrcIndexY += 3 * blendBufferDim;
                }
                newSrcIndexY = newIndexX + newBufferIndexZ;
                int lowerOffset = 0;
                int upperOffset = 3 * fullFilterDim * blendBufferDim;
                int lowerIndex = newSrcIndexY + lowerOffset;
                int upperIndex = newSrcIndexY + upperOffset;
                for (int newY = 0; newY < scaledDstSize; ++newY) {
                    lowerR = buffer.color[lowerIndex] * oneOverBlockSize;
                    lowerG = buffer.color[lowerIndex + 1] * oneOverBlockSize;
                    lowerB = buffer.color[lowerIndex + 2] * oneOverBlockSize;
                    upperR = buffer.color[upperIndex] * oneOverBlockSize;
                    upperG = buffer.color[upperIndex + 1] * oneOverBlockSize;
                    upperB = buffer.color[upperIndex + 2] * oneOverBlockSize;
                    for (i = 0; i < blockSize; ++i) {
                        buffer.blend[newDstIndexY] = sumR += upperR;
                        buffer.blend[newDstIndexY + 1] = sumG += upperG;
                        buffer.blend[newDstIndexY + 2] = sumB += upperB;
                        sumR -= lowerR;
                        sumG -= lowerG;
                        sumB -= lowerB;
                        newDstIndexY += 3 * blendBufferDim;
                    }
                    lowerIndex += 3 * blendBufferDim;
                    upperIndex += 3 * blendBufferDim;
                }
                newIndexX += 3;
            }
            if (z < fullFilterDim) {
                int newIndexY = 0;
                for (int newY = 0; newY < dstSize; ++newY) {
                    int newSrcIndexX = newIndexY;
                    int newDstIndexX = newIndexY + newBufferIndexZ;
                    int newSumIndexX = newIndexY;
                    float sumR = 0.0f;
                    float sumG = 0.0f;
                    float sumB = 0.0f;
                    for (int newX = 0; newX < fullFilterDim; ++newX) {
                        sumR += buffer.blend[newSrcIndexX];
                        sumG += buffer.blend[newSrcIndexX + 1];
                        sumB += buffer.blend[newSrcIndexX + 2];
                        newSrcIndexX += 3;
                    }
                    int lowerOffset = 0;
                    int upperOffset = 3 * fullFilterDim;
                    newSrcIndexX = newIndexY;
                    for (int newX = 0; newX < scaledDstSize; ++newX) {
                        lowerR = buffer.blend[newSrcIndexX + lowerOffset] * oneOverBlockSize;
                        lowerG = buffer.blend[newSrcIndexX + lowerOffset + 1] * oneOverBlockSize;
                        lowerB = buffer.blend[newSrcIndexX + lowerOffset + 2] * oneOverBlockSize;
                        upperR = buffer.blend[newSrcIndexX + upperOffset] * oneOverBlockSize;
                        upperG = buffer.blend[newSrcIndexX + upperOffset + 1] * oneOverBlockSize;
                        upperB = buffer.blend[newSrcIndexX + upperOffset + 2] * oneOverBlockSize;
                        for (i = 0; i < blockSize; ++i) {
                            buffer.color[newDstIndexX] = sumR += upperR;
                            buffer.color[newDstIndexX + 1] = sumG += upperG;
                            buffer.color[newDstIndexX + 2] = sumB += upperB;
                            int n = newSumIndexX;
                            buffer.sum[n] = buffer.sum[n] + sumR;
                            int n2 = newSumIndexX + 1;
                            buffer.sum[n2] = buffer.sum[n2] + sumG;
                            int n3 = newSumIndexX + 2;
                            buffer.sum[n3] = buffer.sum[n3] + sumB;
                            sumR -= lowerR;
                            sumG -= lowerG;
                            sumB -= lowerB;
                            newDstIndexX += 3;
                            newSumIndexX += 3;
                        }
                        newSrcIndexX += 3;
                    }
                    newIndexY += 3 * blendBufferDim;
                }
            } else {
                int resultOffsetX = 0;
                int indexX = 0;
                for (int newY = 0; newY < dstSize; ++newY) {
                    int srcIndexZ = indexX;
                    int dstIndexZ = indexX + newBufferIndexZ;
                    int sumIndexZ = indexX;
                    float sumR = 0.0f;
                    float sumG = 0.0f;
                    float sumB = 0.0f;
                    for (int newX = 0; newX < fullFilterDim; ++newX) {
                        sumR += buffer.blend[srcIndexZ];
                        sumG += buffer.blend[srcIndexZ + 1];
                        sumB += buffer.blend[srcIndexZ + 2];
                        srcIndexZ += 3;
                    }
                    int lowerOffset = 0;
                    int upperOffset = 3 * fullFilterDim;
                    srcIndexZ = indexX;
                    int finalIndexZ = newResultIndexZ + resultOffsetX;
                    for (int newX = 0; newX < scaledDstSize; ++newX) {
                        float lowerR2 = buffer.blend[srcIndexZ + lowerOffset] * oneOverBlockSize;
                        float lowerG2 = buffer.blend[srcIndexZ + lowerOffset + 1] * oneOverBlockSize;
                        float lowerB2 = buffer.blend[srcIndexZ + lowerOffset + 2] * oneOverBlockSize;
                        float upperR2 = buffer.blend[srcIndexZ + upperOffset] * oneOverBlockSize;
                        float upperG2 = buffer.blend[srcIndexZ + upperOffset + 1] * oneOverBlockSize;
                        float upperB2 = buffer.blend[srcIndexZ + upperOffset + 2] * oneOverBlockSize;
                        int lowerYOffset = 3 * -(filterSupport - 1) * blendBufferDim * blendBufferDim;
                        for (int i2 = 0; i2 < blockSize; ++i2) {
                            buffer.color[dstIndexZ] = sumR += upperR2;
                            buffer.color[dstIndexZ + 1] = sumG += upperG2;
                            buffer.color[dstIndexZ + 2] = sumB += upperB2;
                            float lowerYRV = buffer.color[dstIndexZ + lowerYOffset];
                            float lowerYGV = buffer.color[dstIndexZ + lowerYOffset + 1];
                            float lowerYBV = buffer.color[dstIndexZ + lowerYOffset + 2];
                            float lowerYR = lowerYRV * oneOverBlockSize;
                            float lowerYG = lowerYGV * oneOverBlockSize;
                            float lowerYB = lowerYBV * oneOverBlockSize;
                            float upperYR = sumR * oneOverBlockSize;
                            float upperYG = sumG * oneOverBlockSize;
                            float upperYB = sumB * oneOverBlockSize;
                            float valueR = buffer.sum[sumIndexZ];
                            float valueG = buffer.sum[sumIndexZ + 1];
                            float valueB = buffer.sum[sumIndexZ + 2];
                            for (int j = 0; j < blockSize; ++j) {
                                int finalIndexY = finalIndexZ + 256 * j;
                                float filterR = (valueR += upperYR) * filterScalar;
                                float filterG = (valueG += upperYG) * filterScalar;
                                float filterB = (valueB += upperYB) * filterScalar;
                                Color.OKLabsTosRGBAInt(filterR, filterG, filterB, blendChunk.data, finalIndexY);
                                valueR -= lowerYR;
                                valueG -= lowerYG;
                                valueB -= lowerYB;
                            }
                            int n = sumIndexZ;
                            buffer.sum[n] = buffer.sum[n] + (sumR - lowerYRV);
                            int n4 = sumIndexZ + 1;
                            buffer.sum[n4] = buffer.sum[n4] + (sumG - lowerYGV);
                            int n5 = sumIndexZ + 2;
                            buffer.sum[n5] = buffer.sum[n5] + (sumB - lowerYBV);
                            sumR -= lowerR2;
                            sumG -= lowerG2;
                            sumB -= lowerB2;
                            dstIndexZ += 3;
                            sumIndexZ += 3;
                            ++finalIndexZ;
                        }
                        srcIndexZ += 3;
                    }
                    indexX += 3 * blendBufferDim;
                    resultOffsetX += 16;
                }
                newResultIndexZ += blockSize * 16 * 16;
            }
            newBufferIndexZ += 3 * blendBufferDim * blendBufferDim;
        }
    }

    public static void fillBlendChunkRegionWithColor(BlendChunk blendChunk, int color, int baseIndex, int dim) {
        int indexZ = baseIndex;
        for (int z = 0; z < dim; ++z) {
            int indexY = indexZ;
            for (int y = 0; y < dim; ++y) {
                for (int x = 0; x < dim; ++x) {
                    blendChunk.data[indexY + x] = color;
                }
                indexY += 16;
            }
            indexZ += 256;
        }
    }

    public static void fillBlendChunkSliceWithColor(BlendChunk blendChunk, int color, int sliceSizeLog2, int x, int y, int z) {
        int sliceSize = 1 << sliceSizeLog2;
        int sliceX = x >> sliceSizeLog2;
        int sliceY = y >> sliceSizeLog2;
        int sliceZ = z >> sliceSizeLog2;
        int baseX = sliceX << sliceSizeLog2;
        int baseY = sliceY << sliceSizeLog2;
        int baseZ = sliceZ << sliceSizeLog2;
        int inChunkX = Utility.lowerBits(baseX, 4);
        int inChunkY = Utility.lowerBits(baseY, 4);
        int inChunkZ = Utility.lowerBits(baseZ, 4);
        int baseIndex = ColorCaching.getArrayIndex(16, inChunkX, inChunkY, inChunkZ);
        ColorBlending.fillBlendChunkRegionWithColor(blendChunk, color, baseIndex, sliceSize);
    }

    public static void gatherColorsDirectly(class_1937 world, class_6539 colorResolver, BlendChunk blendChunk, int requestX, int requestY, int requestZ) {
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        int sliceSizeLog2 = BlendConfig.getSliceSizeLog2(0);
        int sliceSize = BlendConfig.getSliceSize(0);
        int sliceX = requestX >> sliceSizeLog2;
        int sliceY = requestY >> sliceSizeLog2;
        int sliceZ = requestZ >> sliceSizeLog2;
        boolean neighborsAreLoaded = ColorBlending.neighborChunksAreLoaded(world, sliceSizeLog2, sliceX, sliceZ);
        int baseX = sliceX << sliceSizeLog2;
        int baseY = sliceY << sliceSizeLog2;
        int baseZ = sliceZ << sliceSizeLog2;
        int inChunkX = Utility.lowerBits(baseX, 4);
        int inChunkY = Utility.lowerBits(baseY, 4);
        int inChunkZ = Utility.lowerBits(baseZ, 4);
        int baseIndex = ColorCaching.getArrayIndex(16, inChunkX, inChunkY, inChunkZ);
        if (neighborsAreLoaded) {
            int indexZ = baseIndex;
            for (int z = 0; z < sliceSize; ++z) {
                int indexY = indexZ;
                for (int y = 0; y < sliceSize; ++y) {
                    for (int x = 0; x < sliceSize; ++x) {
                        int color;
                        int worldX = baseX + x;
                        int worldY = baseY + y;
                        int worldZ = baseZ + z;
                        blockPos.method_10103(worldX, worldY, worldZ);
                        blendChunk.data[indexY + x] = color = ColorBlending.getColorAtPosition(world, (class_2338)blockPos, worldX, worldZ, colorResolver);
                    }
                    indexY += 16;
                }
                indexZ += 256;
            }
        } else {
            int centerX = (sliceX << sliceSizeLog2) + (1 << sliceSizeLog2 - 1);
            int centerY = (sliceY << sliceSizeLog2) + (1 << sliceSizeLog2 - 1);
            int centerZ = (sliceZ << sliceSizeLog2) + (1 << sliceSizeLog2 - 1);
            blockPos.method_10103(centerX, centerY, centerZ);
            int color = ColorBlending.getColorAtPosition(world, (class_2338)blockPos, centerX, centerZ, colorResolver);
            ColorBlending.fillBlendChunkRegionWithColor(blendChunk, color, baseIndex, sliceSize);
        }
    }

    public static void generateColors(class_1937 world, class_6539 colorResolver, int colorType, ColorCache colorCache, BlendChunk blendChunk, int x, int y, int z) {
        DebugEvent debugEvent = Debug.pushColorGenEvent(x, y, z, colorType);
        int blendRadius = BetterBiomeBlendClient.getBiomeBlendRadius();
        if (blendRadius > 0 && blendRadius <= 14) {
            BlendBuffer blendBuffer = ColorBlending.acquireBlendBuffer(blendRadius);
            ColorBlending.gatherColorsToBlendBuffer(world, colorResolver, colorType, colorCache, blendBuffer, x, y, z);
            if (blendBuffer.colorBitsInclusive != blendBuffer.colorBitsExclusive) {
                DebugEvent subEvent = Debug.pushSubevent(DebugEventType.SUBEVENT);
                ColorBlending.blendColorsForSlice(blendBuffer, blendChunk, x, y, z);
                Debug.endEvent(subEvent);
            } else {
                ColorBlending.fillBlendChunkSliceWithColor(blendChunk, blendBuffer.colorBitsInclusive, blendBuffer.sliceSizeLog2, x, y, z);
            }
            ColorBlending.releaseBlendBuffer(blendBuffer);
        } else {
            ColorBlending.gatherColorsDirectly(world, colorResolver, blendChunk, x, y, z);
        }
        Debug.endEvent(debugEvent);
    }
}

