/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.interndep.flowsched.executor;

import ca.spottedleaf.starlight.interndep.flowsched.executor.LockToken;
import ca.spottedleaf.starlight.interndep.flowsched.executor.SimpleTask;
import ca.spottedleaf.starlight.interndep.flowsched.executor.Task;
import ca.spottedleaf.starlight.interndep.flowsched.executor.WorkerThread;
import ca.spottedleaf.starlight.interndep.flowsched.structs.DynamicPriorityQueue;
import ca.spottedleaf.starlight.interndep.flowsched.util.Assertions;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;

public class ExecutorManager {
    private final DynamicPriorityQueue<Task> globalWorkQueue;
    private final ConcurrentMap<LockToken, FreeableTaskList> lockListeners = new ConcurrentHashMap<LockToken, FreeableTaskList>();
    private final WorkerThread[] workerThreads;
    public final Semaphore waitObj = new Semaphore(0);

    public ExecutorManager(int workerThreadCount) {
        this(workerThreadCount, thread -> {});
    }

    public ExecutorManager(int workerThreadCount, Consumer<Thread> threadInitializer) {
        this(workerThreadCount, threadInitializer, 64);
    }

    public ExecutorManager(int workerThreadCount, Consumer<Thread> threadInitializer, int priorityCount) {
        this.globalWorkQueue = new DynamicPriorityQueue(priorityCount);
        this.workerThreads = new WorkerThread[workerThreadCount];
        for (int i = 0; i < workerThreadCount; ++i) {
            WorkerThread thread = new WorkerThread(this);
            threadInitializer.accept(thread);
            thread.start();
            this.workerThreads[i] = thread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryLock(Task task) {
        block3: while (true) {
            FreeableTaskList listenerSet = new FreeableTaskList();
            LockToken[] lockTokens = task.lockTokens();
            for (int i = 0; i < lockTokens.length; ++i) {
                LockToken token = lockTokens[i];
                FreeableTaskList present = this.lockListeners.putIfAbsent(token, listenerSet);
                if (present == null) continue;
                for (int j = 0; j < i; ++j) {
                    this.lockListeners.remove(lockTokens[j], (Object)listenerSet);
                }
                this.callListeners(listenerSet);
                FreeableTaskList freeableTaskList = present;
                synchronized (freeableTaskList) {
                    if (present.freed) {
                        continue block3;
                    }
                    present.add(task);
                }
                return false;
            }
            break;
        }
        return true;
    }

    void releaseLocks(Task task) {
        FreeableTaskList expectedListeners = null;
        for (LockToken token : task.lockTokens()) {
            FreeableTaskList listeners = (FreeableTaskList)((Object)this.lockListeners.remove(token));
            if (listeners != null) {
                if (expectedListeners == null) {
                    expectedListeners = listeners;
                    continue;
                }
                Assertions.assertTrue(expectedListeners == listeners, "Inconsistent lock listeners");
                continue;
            }
            throw new IllegalStateException("Lock token " + String.valueOf(token) + " is not locked");
        }
        if (expectedListeners != null) {
            this.callListeners(expectedListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callListeners(FreeableTaskList listeners) {
        FreeableTaskList freeableTaskList = listeners;
        synchronized (freeableTaskList) {
            listeners.freed = true;
            if (listeners.isEmpty()) {
                return;
            }
            ObjectListIterator objectListIterator = listeners.iterator();
            while (objectListIterator.hasNext()) {
                Task listener = (Task)objectListIterator.next();
                this.schedule0(listener);
            }
        }
    }

    Task pollExecutableTask() {
        Task task;
        while ((task = this.globalWorkQueue.dequeue()) != null) {
            if (!this.tryLock(task)) continue;
            return task;
        }
        return null;
    }

    DynamicPriorityQueue<Task> getGlobalWorkQueue() {
        return this.globalWorkQueue;
    }

    public void shutdown() {
        for (WorkerThread workerThread : this.workerThreads) {
            workerThread.shutdown();
        }
        this.waitObj.release(this.workerThreads.length * 128);
    }

    public void schedule(Task task) {
        this.schedule0(task);
    }

    private void schedule0(Task task) {
        this.globalWorkQueue.enqueue(task, task.priority());
        this.waitObj.release(1);
    }

    public void schedule(Runnable runnable, int priority) {
        this.schedule(new SimpleTask(runnable, priority));
    }

    public Executor executor(int priority) {
        return runnable -> this.schedule(runnable, priority);
    }

    public void notifyPriorityChange(Task task) {
        this.globalWorkQueue.changePriority(task, task.priority());
    }

    private static class FreeableTaskList
    extends ReferenceArrayList<Task> {
        private boolean freed = false;

        private FreeableTaskList() {
        }
    }
}

