/*
 * Decompiled with CFR 0.152.
 */
package com.mrerenk.mapdistancefix.util;

import com.mrerenk.mapdistancefix.client.MapdistancefixClient;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_20;
import net.minecraft.class_21;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_9428;

@Environment(value=EnvType.CLIENT)
public final class MapDecorationUtils {
    public static final float DEGREES_PER_ROTATION = 22.5f;
    public static final int ROTATION_MASK = 15;
    private static final byte[] ROTATION_LOOKUP = new byte[360];
    private static final ThreadLocal<Boolean> IS_PLAYER_CONTEXT = ThreadLocal.withInitial(() -> false);
    private static final AtomicReference<WeakReference<class_6880<class_9428>>> cachedPlayerTypeRef;

    private MapDecorationUtils() {
    }

    public static byte calculateMapRotation(float playerYaw) {
        int normalizedYaw = ((int)class_3532.method_15393((float)playerYaw) + 360) % 360;
        return ROTATION_LOOKUP[normalizedYaw];
    }

    public static Optional<class_20> convertOffMapDecoration(class_20 original, byte newRotation) {
        return Optional.ofNullable(original).filter(MapDecorationUtils::isPlayerOffMapAny).map(decoration -> {
            PlayerDecorationType.fromType((class_6880<class_9428>)decoration.comp_1842()).ifPresent(type -> MapdistancefixClient.LOGGER.debug("Converting {} decoration to player decoration", (Object)type.getDisplayName()));
            return new class_20(MapDecorationUtils.getPlayerType(), decoration.comp_1843(), decoration.comp_1844(), newRotation, decoration.comp_1846());
        });
    }

    public static boolean shouldConvertDecorationType(class_6880<class_9428> type) {
        if (type == null) {
            return false;
        }
        if (type == class_21.field_86 || type == class_21.field_87) {
            return true;
        }
        return type.equals((Object)class_21.field_86) || type.equals((Object)class_21.field_87);
    }

    public static boolean isPlayerOffMapAny(class_20 decoration) {
        return decoration != null && MapDecorationUtils.shouldConvertDecorationType((class_6880<class_9428>)decoration.comp_1842());
    }

    public static boolean isPlayerContext() {
        StackTraceElement[] stack;
        if (IS_PLAYER_CONTEXT.get().booleanValue()) {
            return true;
        }
        for (StackTraceElement element : stack = Thread.currentThread().getStackTrace()) {
            String className = element.getClassName();
            if (!className.contains("MapState") && !className.contains("class_22")) continue;
            return true;
        }
        return false;
    }

    public static void setPlayerContext(boolean inPlayerContext) {
        IS_PLAYER_CONTEXT.set(inPlayerContext);
    }

    public static void clearPlayerContext() {
        IS_PLAYER_CONTEXT.remove();
    }

    public static void cachePlayerTypeFromDecoration(class_20 decoration) {
        if (decoration == null) {
            return;
        }
        if (decoration.comp_1842().equals((Object)class_21.field_91)) {
            WeakReference<class_6880> newRef = new WeakReference<class_6880>(decoration.comp_1842());
            cachedPlayerTypeRef.compareAndSet(null, newRef);
            MapdistancefixClient.LOGGER.debug("Cached player decoration type from game instance");
        }
    }

    public static class_6880<class_9428> getPlayerType() {
        WeakReference<class_6880<class_9428>> ref = cachedPlayerTypeRef.get();
        if (ref != null) {
            class_6880 cached = (class_6880)ref.get();
            if (cached != null) {
                return cached;
            }
            cachedPlayerTypeRef.compareAndSet(ref, null);
        }
        return class_21.field_91;
    }

    static {
        for (int i = 0; i < 360; ++i) {
            MapDecorationUtils.ROTATION_LOOKUP[i] = (byte)(Math.round((float)i / 22.5f) & 0xF);
        }
        cachedPlayerTypeRef = new AtomicReference<Object>(null);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum PlayerDecorationType {
        PLAYER((class_6880<class_9428>)class_21.field_91, "player"),
        OFF_MAP((class_6880<class_9428>)class_21.field_86, "off-map"),
        OFF_LIMITS((class_6880<class_9428>)class_21.field_87, "off-limits");

        private final class_6880<class_9428> type;
        private final String displayName;

        private PlayerDecorationType(class_6880<class_9428> type, String displayName) {
            this.type = type;
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public static Optional<PlayerDecorationType> fromType(class_6880<class_9428> type) {
            for (PlayerDecorationType decorationType : PlayerDecorationType.values()) {
                if (!decorationType.type.equals(type)) continue;
                return Optional.of(decorationType);
            }
            return Optional.empty();
        }
    }
}

