/*
 * Decompiled with CFR 0.152.
 */
package com.mrerenk.mapdistancefix.util;

import java.util.Map;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_20;
import net.minecraft.class_21;
import net.minecraft.class_22;

@Environment(value=EnvType.CLIENT)
public final class MapCenterTracker {
    private static final Map<class_22, EstimatedCenter> centerCache = new WeakHashMap<class_22, EstimatedCenter>();

    private MapCenterTracker() {
    }

    public static void updateFromOnMapDecoration(class_22 mapState, class_20 decoration, double playerX, double playerZ, byte scale) {
        if (!decoration.comp_1842().equals((Object)class_21.field_91)) {
            return;
        }
        int blocksPerPixel = 1 << scale;
        double pixelOffsetX = (double)decoration.comp_1843() / 2.0;
        double pixelOffsetZ = (double)decoration.comp_1844() / 2.0;
        double worldOffsetX = pixelOffsetX * (double)blocksPerPixel;
        double worldOffsetZ = pixelOffsetZ * (double)blocksPerPixel;
        int estimatedCenterX = (int)Math.round(playerX - worldOffsetX);
        int estimatedCenterZ = (int)Math.round(playerZ - worldOffsetZ);
        centerCache.put(mapState, new EstimatedCenter(estimatedCenterX, estimatedCenterZ, true));
    }

    public static void estimateFromOffMapDecoration(class_22 mapState, class_20 decoration, double playerX, double playerZ, byte scale) {
        int estimatedCenterZ;
        int estimatedCenterX;
        EstimatedCenter existing = centerCache.get(mapState);
        if (existing != null && existing.isAccurate) {
            return;
        }
        int blocksPerPixel = 1 << scale;
        int mapHalfSizeBlocks = 64 * blocksPerPixel;
        byte decX = decoration.comp_1843();
        byte decZ = decoration.comp_1844();
        if (decX <= -127) {
            estimatedCenterX = (int)Math.round(playerX + (double)mapHalfSizeBlocks);
        } else if (decX >= 127) {
            estimatedCenterX = (int)Math.round(playerX - (double)mapHalfSizeBlocks);
        } else {
            double pixelOffsetX = (double)decX / 2.0;
            double worldOffsetX = pixelOffsetX * (double)blocksPerPixel;
            estimatedCenterX = (int)Math.round(playerX - worldOffsetX);
        }
        if (decZ <= -127) {
            estimatedCenterZ = (int)Math.round(playerZ + (double)mapHalfSizeBlocks);
        } else if (decZ >= 127) {
            estimatedCenterZ = (int)Math.round(playerZ - (double)mapHalfSizeBlocks);
        } else {
            double pixelOffsetZ = (double)decZ / 2.0;
            double worldOffsetZ = pixelOffsetZ * (double)blocksPerPixel;
            estimatedCenterZ = (int)Math.round(playerZ - worldOffsetZ);
        }
        centerCache.put(mapState, new EstimatedCenter(estimatedCenterX, estimatedCenterZ, false));
    }

    public static EstimatedCenter getEstimatedCenter(class_22 mapState) {
        return centerCache.get(mapState);
    }

    public static double calculateDistance(class_22 mapState, double playerX, double playerZ) {
        EstimatedCenter center = centerCache.get(mapState);
        if (center == null) {
            return -1.0;
        }
        double dx = playerX - (double)center.x;
        double dz = playerZ - (double)center.z;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static boolean hasCenter(class_22 mapState) {
        return centerCache.containsKey(mapState);
    }

    public static void clearCache() {
        centerCache.clear();
    }

    @Environment(value=EnvType.CLIENT)
    public static class EstimatedCenter {
        public final int x;
        public final int z;
        public final boolean isAccurate;

        public EstimatedCenter(int x, int z, boolean isAccurate) {
            this.x = x;
            this.z = z;
            this.isAccurate = isAccurate;
        }
    }
}

