/*
 * Decompiled with CFR 0.152.
 */
package com.mrerenk.mapdistancefix.mixin.client;

import com.mrerenk.mapdistancefix.config.ModConfig;
import com.mrerenk.mapdistancefix.util.MapCenterTracker;
import com.mrerenk.mapdistancefix.util.MapDecorationUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_20;
import net.minecraft.class_21;
import net.minecraft.class_22;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_22.class})
public class MapStateMixin {
    @Shadow
    @Final
    public byte field_119;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getDecorations"}, at={@At(value="RETURN")}, cancellable=true)
    private void convertOffMapPlayerDecorations(CallbackInfoReturnable<Iterable<class_20>> cir) {
        Iterable originalDecorations = (Iterable)cir.getReturnValue();
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || originalDecorations == null) {
            return;
        }
        class_22 self = (class_22)this;
        double playerX = client.field_1724.method_23317();
        double playerZ = client.field_1724.method_23321();
        ModConfig config = ModConfig.get();
        ArrayList<class_20> modifiedDecorations = null;
        byte playerRotation = 0;
        boolean rotationCalculated = false;
        for (class_20 decoration : originalDecorations) {
            if (!decoration.comp_1842().equals((Object)class_21.field_91)) continue;
            MapCenterTracker.updateFromOnMapDecoration(self, decoration, playerX, playerZ, this.field_119);
            break;
        }
        int mapHalfSize = 64 * (1 << this.field_119);
        double distance = MapCenterTracker.calculateDistance(self, playerX, playerZ);
        boolean hasValidDistance = distance >= 0.0;
        boolean isOffMap = false;
        MapCenterTracker.EstimatedCenter center = MapCenterTracker.getEstimatedCenter(self);
        if (center != null) {
            double dx = playerX - (double)center.x;
            double dz = playerZ - (double)center.z;
            isOffMap = Math.abs(dx) > (double)mapHalfSize || Math.abs(dz) > (double)mapHalfSize;
        }
        MapDecorationUtils.setPlayerContext(true);
        try {
            for (class_20 decoration : originalDecorations) {
                class_20 prev;
                MapDecorationUtils.cachePlayerTypeFromDecoration(decoration);
                if (MapDecorationUtils.isPlayerOffMapAny(decoration)) {
                    boolean shouldShow;
                    Optional<class_20> convertedOpt;
                    if (modifiedDecorations == null) {
                        modifiedDecorations = new ArrayList<class_20>();
                        Iterator dz = originalDecorations.iterator();
                        while (dz.hasNext() && (prev = (class_20)dz.next()) != decoration) {
                            modifiedDecorations.add(prev);
                        }
                    }
                    if (!rotationCalculated) {
                        playerRotation = MapDecorationUtils.calculateMapRotation(client.field_1724.method_36454());
                        rotationCalculated = true;
                    }
                    if (!MapCenterTracker.hasCenter(self)) {
                        MapCenterTracker.estimateFromOffMapDecoration(self, decoration, playerX, playerZ, this.field_119);
                        distance = MapCenterTracker.calculateDistance(self, playerX, playerZ);
                        boolean bl = hasValidDistance = distance >= 0.0;
                    }
                    if (!(convertedOpt = MapDecorationUtils.convertOffMapDecoration(decoration, playerRotation)).isPresent()) continue;
                    class_20 converted = convertedOpt.get();
                    modifiedDecorations.add(converted);
                    if (!config.isShowDistance() || !hasValidDistance || !(shouldShow = config.isShowDistanceWhenOffMap() && isOffMap || config.isShowDistanceInsideBoundaries())) continue;
                    this.addDistanceDecoration(modifiedDecorations, converted, distance, config);
                    continue;
                }
                if (decoration.comp_1842().equals((Object)class_21.field_91)) {
                    if (config.isShowDistance() && config.isShowDistanceInsideBoundaries() && hasValidDistance) {
                        if (modifiedDecorations == null) {
                            modifiedDecorations = new ArrayList();
                            Iterator iterator = originalDecorations.iterator();
                            while (iterator.hasNext() && (prev = (class_20)iterator.next()) != decoration) {
                                modifiedDecorations.add(prev);
                            }
                        }
                        modifiedDecorations.add(decoration);
                        this.addDistanceDecoration(modifiedDecorations, decoration, distance, config);
                        continue;
                    }
                    if (modifiedDecorations == null) continue;
                    modifiedDecorations.add(decoration);
                    continue;
                }
                if (modifiedDecorations == null) continue;
                modifiedDecorations.add(decoration);
            }
            if (modifiedDecorations != null) {
                cir.setReturnValue(modifiedDecorations);
            }
        }
        finally {
            MapDecorationUtils.clearPlayerContext();
        }
    }

    private void addDistanceDecoration(List<class_20> decorations, class_20 playerDecoration, double distance, ModConfig config) {
        String distanceText = config.formatDistance(distance);
        decorations.remove(decorations.size() - 1);
        class_20 arrowWithText = new class_20(playerDecoration.comp_1842(), playerDecoration.comp_1843(), playerDecoration.comp_1844(), playerDecoration.comp_1845(), Optional.of(class_2561.method_43470((String)distanceText)));
        decorations.add(arrowWithText);
    }
}

