/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.InputStream;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.FilterDecoder;
import org.tukaani.xz.LZMA2Coder;
import org.tukaani.xz.LZMA2InputStream;
import org.tukaani.xz.UnsupportedOptionsException;

class LZMA2Decoder
extends LZMA2Coder
implements FilterDecoder {
    private int dictSize;

    LZMA2Decoder(byte[] bs) throws UnsupportedOptionsException {
        if (bs.length != 1 || (bs[0] & 0xFF) > 37) {
            throw new UnsupportedOptionsException("Unsupported LZMA2 properties");
        }
        this.dictSize = 2 | bs[0] & 1;
        this.dictSize <<= (bs[0] >>> 1) + 11;
    }

    @Override
    public int getMemoryUsage() {
        return LZMA2InputStream.getMemoryUsage(this.dictSize);
    }

    @Override
    public InputStream getInputStream(InputStream inputStream, ArrayCache arrayCache) {
        return new LZMA2InputStream(inputStream, this.dictSize, null, arrayCache);
    }
}

