/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject.texture;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.glObject.texture.EDhDepthBufferFormat;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL43C;

public class DHDepthTexture {
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    private int id;

    public DHDepthTexture(int width, int height, EDhDepthBufferFormat format) {
        this.id = GL43C.glGenTextures();
        this.resize(width, height, format);
        GL43C.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL43C.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL43C.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL43C.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL43C.glBindTexture((int)3553, (int)0);
    }

    public DHDepthTexture(int id) {
        this.id = id;
    }

    public void resize(int width, int height, EDhDepthBufferFormat format) {
        GL43C.glBindTexture((int)3553, (int)this.getTextureId());
        GL43C.glTexImage2D((int)3553, (int)0, (int)format.getGlInternalFormat(), (int)width, (int)height, (int)0, (int)format.getGlType(), (int)format.getGlFormat(), (ByteBuffer)null);
    }

    public int getTextureId() {
        if (this.id == -1) {
            throw new IllegalStateException("Depth texture does not exist!");
        }
        return this.id;
    }

    public void destroy() {
        GLMC.glDeleteTextures(this.getTextureId());
        this.id = -1;
    }
}

