/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.api.internal;

import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiWorldLoadEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiWorldUnloadEvent;
import com.seibel.distanthorizons.core.Initializer;
import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.api.internal.chunkUpdating.ChunkUpdateData;
import com.seibel.distanthorizons.core.api.internal.chunkUpdating.ChunkUpdateQueueManager;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.level.DhClientLevel;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.sql.repo.AbstractDhRepo;
import com.seibel.distanthorizons.core.util.objects.Pair;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.DhApiWorldProxy;
import com.seibel.distanthorizons.core.world.DhClientServerWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.world.IDhClientWorld;
import com.seibel.distanthorizons.core.world.IDhServerWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import java.util.ArrayList;
import java.util.concurrent.RejectedExecutionException;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SharedApi {
    public static final SharedApi INSTANCE = new SharedApi();
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    @Nullable
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    @Nullable
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IMinecraftSharedWrapper MC_SHARED = SingletonInjector.INSTANCE.get(IMinecraftSharedWrapper.class);
    public static final ChunkUpdateQueueManager CHUNK_UPDATE_QUEUE_MANAGER = new ChunkUpdateQueueManager();
    public static final int MAX_UPDATING_CHUNK_COUNT_PER_THREAD_AND_PLAYER = 1000;
    public static final int MIN_MS_BETWEEN_OVERLOADED_LOG_MESSAGE = 30000;
    @Nullable
    private static AbstractDhWorld currentWorld;
    private static int lastWorldGenTickDelta;

    private SharedApi() {
    }

    public static void init() {
        Initializer.init();
    }

    public static EWorldEnvironment getEnvironment() {
        return currentWorld == null ? null : SharedApi.currentWorld.environment;
    }

    public static void setDhWorld(AbstractDhWorld newWorld) {
        AbstractDhWorld oldWorld = currentWorld;
        if (oldWorld != null) {
            oldWorld.close();
        }
        if ((currentWorld = newWorld) != null) {
            ThreadPoolUtil.setupThreadPools();
            ApiEventInjector.INSTANCE.fireAllEvents(DhApiWorldLoadEvent.class, new DhApiWorldLoadEvent.EventParam());
        } else {
            ThreadPoolUtil.shutdownThreadPools();
            DebugRenderer.clearRenderables();
            if (MC_RENDER != null) {
                MC_RENDER.clearTargetFrameBuffer();
            }
            AbstractDhRepo.closeAllConnections();
            CHUNK_UPDATE_QUEUE_MANAGER.clear();
            System.gc();
            ApiEventInjector.INSTANCE.fireAllEvents(DhApiWorldUnloadEvent.class, new DhApiWorldUnloadEvent.EventParam());
            DhApiWorldProxy.INSTANCE.setReadOnly(false, false);
        }
    }

    public static void worldGenTick(Runnable worldGenRunnable) {
        if (--lastWorldGenTickDelta <= 0) {
            worldGenRunnable.run();
            lastWorldGenTickDelta = 20;
        }
    }

    @Nullable
    public static AbstractDhWorld getAbstractDhWorld() {
        return currentWorld;
    }

    public static DhClientServerWorld getDhClientServerWorld() {
        return currentWorld instanceof DhClientServerWorld ? (DhClientServerWorld)currentWorld : null;
    }

    public static IDhClientWorld getIDhClientWorld() {
        return currentWorld instanceof IDhClientWorld ? (IDhClientWorld)((Object)currentWorld) : null;
    }

    public static IDhServerWorld getIDhServerWorld() {
        return currentWorld instanceof IDhServerWorld ? (IDhServerWorld)((Object)currentWorld) : null;
    }

    public static boolean isChunkAtBlockPosAlreadyUpdating(int blockPosX, int blockPosZ) {
        return CHUNK_UPDATE_QUEUE_MANAGER.contains(new DhChunkPos(new DhBlockPos2D(blockPosX, blockPosZ)));
    }

    public static boolean isChunkAtChunkPosAlreadyUpdating(int chunkPosX, int chunkPosZ) {
        return CHUNK_UPDATE_QUEUE_MANAGER.contains(new DhChunkPos(chunkPosX, chunkPosZ));
    }

    public void clearQueuedChunkUpdates() {
        CHUNK_UPDATE_QUEUE_MANAGER.clear();
    }

    public int getQueuedChunkUpdateCount() {
        return CHUNK_UPDATE_QUEUE_MANAGER.getQueuedCount();
    }

    public void chunkBlockChangedEvent(IChunkWrapper chunk, ILevelWrapper level) {
        this.applyChunkUpdate(chunk, level, true, false);
    }

    public void chunkLoadEvent(IChunkWrapper chunk, ILevelWrapper level) {
        this.applyChunkUpdate(chunk, level, true, true);
    }

    public void applyChunkUpdate(IChunkWrapper chunkWrapper, ILevelWrapper level, boolean canGetNeighboringChunks, boolean newlyLoaded) {
        if (chunkWrapper == null) {
            return;
        }
        AbstractDhWorld dhWorld = SharedApi.getAbstractDhWorld();
        if (dhWorld == null) {
            if (level instanceof IClientLevelWrapper) {
                IClientLevelWrapper clientLevel = (IClientLevelWrapper)level;
                ClientApi.INSTANCE.waitingChunkByClientLevelAndPos.replace(new Pair<IClientLevelWrapper, DhChunkPos>(clientLevel, chunkWrapper.getChunkPos()), chunkWrapper);
            }
            return;
        }
        if (DhApiWorldProxy.INSTANCE.getReadOnly()) {
            return;
        }
        IDhLevel dhLevel = dhWorld.getLevel(level);
        if (dhLevel == null) {
            if (level instanceof IClientLevelWrapper) {
                IClientLevelWrapper clientLevel = (IClientLevelWrapper)level;
                ClientApi.INSTANCE.waitingChunkByClientLevelAndPos.replace(new Pair<IClientLevelWrapper, DhChunkPos>(clientLevel, chunkWrapper.getChunkPos()), chunkWrapper);
            }
            return;
        }
        if (dhLevel instanceof DhClientLevel && !((DhClientLevel)dhLevel).shouldProcessChunkUpdate(chunkWrapper.getChunkPos())) {
            return;
        }
        if (CHUNK_UPDATE_QUEUE_MANAGER.contains(chunkWrapper.getChunkPos())) {
            return;
        }
        if (!canGetNeighboringChunks) {
            SharedApi.queueChunkUpdate(chunkWrapper, null, dhLevel, false);
            return;
        }
        ArrayList<IChunkWrapper> neighboringChunkList = SharedApi.getNeighborChunkListForChunk(chunkWrapper, dhLevel);
        if (newlyLoaded) {
            for (IChunkWrapper neighboringChunk : neighboringChunkList) {
                if (neighboringChunk == chunkWrapper) continue;
                this.applyChunkUpdate(neighboringChunk, level, true, false);
            }
        } else {
            if (neighboringChunkList.size() < 9) {
                return;
            }
            SharedApi.queueChunkUpdate(chunkWrapper, neighboringChunkList, dhLevel, true);
        }
    }

    private static ArrayList<IChunkWrapper> getNeighborChunkListForChunk(IChunkWrapper chunkWrapper, IDhLevel dhLevel) {
        ArrayList<IChunkWrapper> neighborChunkList = new ArrayList<IChunkWrapper>(9);
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                if (xOffset == 0 && zOffset == 0) {
                    neighborChunkList.add(chunkWrapper);
                    continue;
                }
                DhChunkPos neighborPos = new DhChunkPos(chunkWrapper.getChunkPos().getX() + xOffset, chunkWrapper.getChunkPos().getZ() + zOffset);
                IChunkWrapper neighborChunk = dhLevel.getLevelWrapper().tryGetChunk(neighborPos);
                if (neighborChunk == null) continue;
                neighborChunkList.add(neighborChunk);
            }
        }
        return neighborChunkList;
    }

    private static void queueChunkUpdate(IChunkWrapper chunkWrapper, @Nullable ArrayList<IChunkWrapper> neighborChunkList, IDhLevel dhLevel, boolean canGetNeighboringChunks) {
        if (CHUNK_UPDATE_QUEUE_MANAGER.contains(chunkWrapper.getChunkPos())) {
            return;
        }
        ChunkUpdateData updateData = new ChunkUpdateData(chunkWrapper, neighborChunkList, dhLevel, canGetNeighboringChunks);
        CHUNK_UPDATE_QUEUE_MANAGER.addItemToPreUpdateQueue(chunkWrapper.getChunkPos(), updateData);
        PriorityTaskPicker.Executor executor = ThreadPoolUtil.getChunkToLodBuilderExecutor();
        if (executor != null && executor.getQueueSize() < executor.getPoolSize()) {
            try {
                executor.execute(SharedApi::processQueue);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private static void processQueue() {
        int maxUpdateSizeMultiplier;
        if (MC_CLIENT != null && MC_CLIENT.playerExists()) {
            CHUNK_UPDATE_QUEUE_MANAGER.setCenter(MC_CLIENT.getPlayerChunkPos());
            maxUpdateSizeMultiplier = MC_CLIENT.clientConnectedToDedicatedServer() ? 1 : MC_SHARED.getPlayerCount();
        } else {
            maxUpdateSizeMultiplier = 1 + MC_SHARED.getPlayerCount();
        }
        SharedApi.CHUNK_UPDATE_QUEUE_MANAGER.maxSize = 1000 * Config.Common.MultiThreading.numberOfThreads.get() * maxUpdateSizeMultiplier;
        SharedApi.processQueuedChunkPreUpdate();
        SharedApi.processQueuedChunkUpdate();
        PriorityTaskPicker.Executor executor = ThreadPoolUtil.getChunkToLodBuilderExecutor();
        if (executor != null && !CHUNK_UPDATE_QUEUE_MANAGER.isEmpty()) {
            try {
                executor.execute(SharedApi::processQueue);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private static void processQueuedChunkPreUpdate() {
        ChunkUpdateData preUpdateData = SharedApi.CHUNK_UPDATE_QUEUE_MANAGER.preUpdateQueue.popClosest();
        if (preUpdateData == null) {
            return;
        }
        IDhLevel dhLevel = preUpdateData.dhLevel;
        IChunkWrapper chunkWrapper = preUpdateData.chunkWrapper;
        boolean canGetNeighboringChunks = preUpdateData.canGetNeighboringChunks;
        ArrayList<IChunkWrapper> neighborChunkList = preUpdateData.neighborChunkList;
        try {
            boolean checkChunkHash;
            boolean bl = checkChunkHash = Config.Common.LodBuilding.disableUnchangedChunkCheck.get() == false;
            if (checkChunkHash) {
                int newChunkHash;
                boolean hasNewChunkHash;
                int oldChunkHash = dhLevel.getChunkHash(chunkWrapper.getChunkPos());
                boolean bl2 = hasNewChunkHash = oldChunkHash != (newChunkHash = chunkWrapper.getBlockBiomeHashCode());
                if (!hasNewChunkHash) {
                    return;
                }
                if (neighborChunkList != null && !neighborChunkList.isEmpty()) {
                    for (IChunkWrapper adjacentChunk : neighborChunkList) {
                        IChunkWrapper newCenterChunk = dhLevel.getLevelWrapper().tryGetChunk(adjacentChunk.getChunkPos());
                        if (newCenterChunk == null) continue;
                        ChunkUpdateData newUpdateData = canGetNeighboringChunks ? new ChunkUpdateData(newCenterChunk, SharedApi.getNeighborChunkListForChunk(newCenterChunk, dhLevel), dhLevel, true) : new ChunkUpdateData(newCenterChunk, null, dhLevel, false);
                        CHUNK_UPDATE_QUEUE_MANAGER.addItemToUpdateQueue(newCenterChunk.getChunkPos(), newUpdateData);
                    }
                }
            }
            CHUNK_UPDATE_QUEUE_MANAGER.addItemToUpdateQueue(chunkWrapper.getChunkPos(), preUpdateData);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error when pre-updating chunk at pos: [" + chunkWrapper.getChunkPos() + "]", (Throwable)e);
        }
    }

    private static void processQueuedChunkUpdate() {
        ChunkUpdateData updateData = SharedApi.CHUNK_UPDATE_QUEUE_MANAGER.updateQueue.popClosest();
        if (updateData == null) {
            return;
        }
        IChunkWrapper chunkWrapper = updateData.chunkWrapper;
        IDhLevel dhLevel = updateData.dhLevel;
        @Nullable ArrayList<IChunkWrapper> nearbyChunkList = updateData.neighborChunkList;
        if (nearbyChunkList == null) {
            nearbyChunkList = new ArrayList();
            nearbyChunkList.add(chunkWrapper);
        }
        try {
            DhLightingEngine.INSTANCE.bakeChunkBlockLighting(chunkWrapper, nearbyChunkList, dhLevel.hasSkyLight() ? 15 : 0);
            dhLevel.updateBeaconBeamsForChunk(chunkWrapper, nearbyChunkList);
            int newChunkHash = chunkWrapper.getBlockBiomeHashCode();
            dhLevel.updateChunkAsync(chunkWrapper, newChunkHash);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error when updating chunk at pos: [" + chunkWrapper.getChunkPos() + "]", (Throwable)e);
        }
    }

    public String getDebugMenuString() {
        String preUpdatingCountStr = F3Screen.NUMBER_FORMAT.format(SharedApi.CHUNK_UPDATE_QUEUE_MANAGER.preUpdateQueue.getQueuedCount());
        String updatingCountStr = F3Screen.NUMBER_FORMAT.format(SharedApi.CHUNK_UPDATE_QUEUE_MANAGER.updateQueue.getQueuedCount());
        String queuedCountStr = F3Screen.NUMBER_FORMAT.format(CHUNK_UPDATE_QUEUE_MANAGER.getQueuedCount());
        String maxUpdateCountStr = F3Screen.NUMBER_FORMAT.format(SharedApi.CHUNK_UPDATE_QUEUE_MANAGER.maxSize);
        return "Queued chunk updates: ( " + preUpdatingCountStr + " + " + updatingCountStr + " )  [ " + queuedCountStr + " / " + maxUpdateCountStr + " ]";
    }

    static {
        lastWorldGenTickDelta = 0;
    }
}

