/*
 * Decompiled with CFR 0.152.
 */
package net.hypercubemc.iris_installer;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import net.fabricmc.installer.Main;
import net.fabricmc.installer.util.MetaHandler;
import net.fabricmc.installer.util.Utils;
import net.hypercubemc.iris_installer.DarkModeDetector;
import net.hypercubemc.iris_installer.Downloader;
import net.hypercubemc.iris_installer.InstallerMeta;
import net.hypercubemc.iris_installer.VanillaLauncherIntegration;
import net.hypercubemc.iris_installer.layouts.Settings;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NewInstaller
extends JFrame {
    private static boolean dark = false;
    private boolean installAsMod;
    private boolean styleIsUnbound = false;
    private final String outdatedPlaceholder = "Warning: Iris shader loader has ended support for <version>.";
    private final String snapshotPlaceholder = "Warning: <version> is a snapshot build and may";
    private final String BASE_URL = "https://raw.githubusercontent.com/IrisShaders/Iris-Installer-Files/master/";
    private InstallerMeta.Version selectedVersion;
    private final List<InstallerMeta.Version> GAME_VERSIONS;
    private final InstallerMeta INSTALLER_META;
    private Path customInstallDir;
    private static final String COMPLEMENTARY_REIMAGINED_PROJECT_ID = "HVnmMxH1";
    private static final String COMPLEMENTARY_UNBOUND_PROJECT_ID = "R6NEzAwj";
    private static final String EUPHORIA_PATCHES_PROJECT_ID = "4H6sumDB";
    private static String compStatsFile = "fileNamePlaceholder.txt";
    private static final String euphoriaStatsFile = "aaaConfirmEPDownload.txt";
    Settings settings = new Settings();
    private JCheckBox euphoriaSelection;
    private JButton directoryName;
    private JLabel gameVersionLabel;
    private JComboBox<String> gameVersionList;
    private JLabel installationDirectory;
    private JRadioButton fabricType;
    private JRadioButton standaloneType;
    private JButton installButton;
    private ButtonGroup installType;
    private JLabel installationType;
    private JPanel installationTypesContainer;
    private JRadioButton unboundType;
    private JRadioButton reimaginedType;
    private ButtonGroup styleType;
    private JPanel visualStyleContainer;
    private JLabel irisInstallerLabel;
    private JLabel linkLabel;
    private JLabel outdatedText1;
    private JLabel outdatedText2;
    private JButton advancedSettingsButton;
    private JProgressBar progressBar;
    private JLabel installationExplanation;
    private JLabel euphoriaDescription;

    public NewInstaller() {
        super("Complementary Installer");
        Main.LOADER_META = new MetaHandler("v2/versions/loader");
        this.registerStatsCleanupHook();
        this.loadFabricMeta();
        this.INSTALLER_META = new InstallerMeta("https://raw.githubusercontent.com/IrisShaders/Iris-Installer-Files/master/meta-new.json");
        this.loadMetadata();
        this.GAME_VERSIONS = this.INSTALLER_META.getVersions();
        Collections.reverse(this.GAME_VERSIONS);
        this.selectedVersion = this.GAME_VERSIONS.get(0);
        this.initComponents();
        if (!dark) {
            Color newTextColor = new Color(154, 136, 63, 255);
            this.outdatedText1.setForeground(newTextColor);
            this.outdatedText2.setForeground(newTextColor);
        }
        this.gameVersionList.removeAllItems();
        for (InstallerMeta.Version version : this.GAME_VERSIONS) {
            this.gameVersionList.addItem(version.name);
        }
        this.directoryName.setText(this.getDefaultInstallDir().toFile().getName());
        this.outdatedText1.setVisible(false);
        this.outdatedText2.setVisible(false);
    }

    private void loadFabricMeta() {
        try {
            Main.LOADER_META.load();
        }
        catch (IOException e) {
            if (this.isNetworkError(e) && this.showNetworkErrorDialog("loading fabric metadata")) {
                this.loadFabricMeta();
                return;
            }
            throw new RuntimeException(e);
        }
    }

    private void loadMetadata() {
        try {
            this.INSTALLER_META.load();
        }
        catch (IOException e) {
            if (this.isNetworkError(e) && this.showNetworkErrorDialog("loading installer metadata")) {
                this.loadMetadata();
                return;
            }
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            System.out.println("Failed to fetch installer metadata from the server!");
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Installer metadata parsing failed, please contact the Iris support team via Discord! \nError: " + e, "Metadata Parsing Failed!", 0);
            throw new RuntimeException(e);
        }
    }

    public Path getStorageDirectory() {
        return this.getAppDataDirectory().resolve(this.getStorageDirectoryName());
    }

    public Path getInstallDir() {
        return this.customInstallDir != null ? this.customInstallDir : this.getDefaultInstallDir();
    }

    public Path getAppDataDirectory() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return new File(System.getenv("APPDATA")).toPath();
        }
        if (os.contains("mac")) {
            return new File(System.getProperty("user.home") + "/Library/Application Support").toPath();
        }
        if (os.contains("nux")) {
            return new File(System.getProperty("user.home")).toPath();
        }
        return new File(System.getProperty("user.dir")).toPath();
    }

    public String getStorageDirectoryName() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("mac")) {
            return "iris-installer";
        }
        return ".iris-installer";
    }

    private Path getDefaultInstallDir() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("mac")) {
            return this.getAppDataDirectory().resolve("minecraft");
        }
        return this.getAppDataDirectory().resolve(".minecraft");
    }

    public Path getVanillaGameDir() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("mac") ? this.getAppDataDirectory().resolve("minecraft") : this.getAppDataDirectory().resolve(".minecraft");
    }

    public boolean installFromZip(File zip) {
        try {
            int BUFFER_SIZE = 2048;
            try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zip));){
                ZipEntry entry = zipIn.getNextEntry();
                if (!this.installAsMod) {
                    this.getInstallDir().resolve("iris-reserved/").toFile().mkdir();
                }
                while (entry != null) {
                    String entryName = entry.getName();
                    if (!this.installAsMod && entryName.startsWith("mods/")) {
                        entryName = entryName.replace("mods/", "iris-reserved/" + this.selectedVersion + "/");
                    }
                    File filePath = this.getInstallDir().resolve(entryName).toFile();
                    if (!entry.isDirectory()) {
                        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));){
                            byte[] bytesIn = new byte[BUFFER_SIZE];
                            int read = 0;
                            while ((read = zipIn.read(bytesIn)) != -1) {
                                bos.write(bytesIn, 0, read);
                            }
                        }
                    } else {
                        filePath.mkdir();
                    }
                    zipIn.closeEntry();
                    entry = zipIn.getNextEntry();
                }
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isInternetNotAvailable() {
        try {
            URL url = new URL("https://www.google.com");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            return responseCode != 200;
        }
        catch (Exception e) {
            return true;
        }
    }

    private boolean showNetworkErrorDialog(String operationName) {
        String message = "Internet connection lost while " + operationName + ".\nPlease check your connection and try again.";
        int response = JOptionPane.showConfirmDialog(this, message, "Network Connection Error", 0, 0);
        if (this.installButton != null) {
            this.installButton.setEnabled(true);
            this.installButton.setText("Install");
        }
        if (this.progressBar != null) {
            this.progressBar.setValue(0);
        }
        return response == 0;
    }

    private void initComponents() {
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        this.installType = new ButtonGroup();
        this.irisInstallerLabel = new JLabel();
        this.linkLabel = new JLabel();
        this.gameVersionLabel = new JLabel();
        this.outdatedText1 = new JLabel();
        this.outdatedText2 = new JLabel();
        this.advancedSettingsButton = new JButton();
        this.installationType = new JLabel();
        this.installationDirectory = new JLabel();
        this.installationTypesContainer = new JPanel();
        this.standaloneType = new JRadioButton();
        this.fabricType = new JRadioButton();
        this.unboundType = new JRadioButton();
        this.reimaginedType = new JRadioButton();
        this.styleType = new ButtonGroup();
        this.visualStyleContainer = new JPanel();
        this.gameVersionList = new JComboBox();
        this.euphoriaSelection = new JCheckBox();
        this.directoryName = new JButton();
        this.progressBar = new JProgressBar();
        this.installButton = new JButton();
        this.installationExplanation = new JLabel();
        this.euphoriaDescription = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setIconImage(new ImageIcon(Objects.requireNonNull(Utils.class.getClassLoader().getResource("comp_icon.png"))).getImage());
        this.setMaximumSize(new Dimension(480, 600));
        this.setMinimumSize(new Dimension(480, 600));
        this.setPreferredSize(new Dimension(480, 600));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.irisInstallerLabel.setFont(this.irisInstallerLabel.getFont().deriveFont(36.0f));
        this.irisInstallerLabel.setHorizontalAlignment(0);
        this.irisInstallerLabel.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/comp_icon.png"))));
        this.irisInstallerLabel.setText(" Complementary");
        this.irisInstallerLabel.setMaximumSize(new Dimension(350, 64));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(30, 0, 0, 0);
        this.getContentPane().add((Component)this.irisInstallerLabel, gridBagConstraints);
        this.visualStyleContainer.setLayout(new BorderLayout(10, 0));
        this.styleType.add(this.unboundType);
        this.unboundType.setFont(this.unboundType.getFont().deriveFont(16.0f));
        this.unboundType.setText("Unbound Style");
        this.unboundType.setToolTipText("");
        this.unboundType.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                NewInstaller.this.unboundStyleMouseClicked(evt);
            }
        });
        this.visualStyleContainer.add((Component)this.unboundType, "Before");
        this.styleType.add(this.reimaginedType);
        this.reimaginedType.setFont(this.reimaginedType.getFont().deriveFont(16.0f));
        this.reimaginedType.setSelected(true);
        this.reimaginedType.setText("Reimagined Style");
        this.reimaginedType.setToolTipText("");
        this.reimaginedType.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                NewInstaller.this.reimaginedStyleMouseClicked(evt);
            }
        });
        this.visualStyleContainer.add((Component)this.reimaginedType, "After");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.getContentPane().add((Component)this.visualStyleContainer, gridBagConstraints);
        this.linkLabel.setText("<html><a href='https://www.complementary.dev/shaders/#style-section'>What's the difference?</a></html>");
        this.linkLabel.setFont(this.linkLabel.getFont().deriveFont(14.0f));
        this.linkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                NewInstaller.openURL(URI.create("https://www.complementary.dev/shaders/#style-section"));
            }
        });
        this.linkLabel.setCursor(Cursor.getPredefinedCursor(12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this.linkLabel, gridBagConstraints);
        this.gameVersionLabel.setFont(this.gameVersionLabel.getFont().deriveFont(this.gameVersionLabel.getFont().getStyle() | 1, 16.0f));
        this.gameVersionLabel.setHorizontalAlignment(0);
        this.gameVersionLabel.setText("Select Minecraft version:");
        this.gameVersionLabel.setToolTipText("");
        this.gameVersionLabel.setHorizontalTextPosition(0);
        this.gameVersionLabel.setMaximumSize(new Dimension(300, 24));
        this.gameVersionLabel.setMinimumSize(new Dimension(168, 24));
        this.gameVersionLabel.setPreferredSize(new Dimension(168, 24));
        this.gameVersionLabel.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.getContentPane().add((Component)this.gameVersionLabel, gridBagConstraints);
        this.gameVersionList.setFont(new Font("Arial", 0, 14));
        this.gameVersionList.setModel(new DefaultComboBoxModel<String>(new String[]{"1.19", "1.18.2", "1.17.1", "1.16.5"}));
        this.gameVersionList.setMaximumSize(new Dimension(168, 35));
        this.gameVersionList.setMinimumSize(new Dimension(168, 35));
        this.gameVersionList.setPreferredSize(new Dimension(168, 35));
        this.gameVersionList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                NewInstaller.this.gameVersionListItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.getContentPane().add(this.gameVersionList, gridBagConstraints);
        this.outdatedText1.setFont(this.outdatedText1.getFont().deriveFont(16.0f));
        this.outdatedText1.setForeground(new Color(255, 204, 0));
        this.outdatedText1.setHorizontalAlignment(0);
        this.outdatedText1.setText("Warning: Iris shader loader has ended support for <version>.");
        this.outdatedText1.setHorizontalTextPosition(0);
        this.outdatedText1.setMaximumSize(new Dimension(400, 21));
        this.outdatedText1.setMinimumSize(new Dimension(310, 21));
        this.outdatedText1.setPreferredSize(new Dimension(310, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.getContentPane().add((Component)this.outdatedText1, gridBagConstraints);
        this.outdatedText2.setFont(this.outdatedText2.getFont().deriveFont(16.0f));
        this.outdatedText2.setForeground(new Color(255, 204, 0));
        this.outdatedText2.setHorizontalAlignment(0);
        this.outdatedText2.setText("The Iris version you get will most likely be outdated.");
        this.outdatedText2.setHorizontalTextPosition(0);
        this.outdatedText2.setMaximumSize(new Dimension(450, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.outdatedText2, gridBagConstraints);
        this.advancedSettingsButton.setFont(this.advancedSettingsButton.getFont().deriveFont(16.0f));
        this.advancedSettingsButton.setText("Advanced Settings");
        this.advancedSettingsButton.setToolTipText("");
        this.advancedSettingsButton.setMargin(new Insets(10, 30, 10, 30));
        this.advancedSettingsButton.setMaximumSize(new Dimension(320, 45));
        this.advancedSettingsButton.setMinimumSize(new Dimension(173, 45));
        this.advancedSettingsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                NewInstaller.this.settings.setVisible(true);
            }
        });
        this.advancedSettingsButton.putClientProperty("JButton.buttonType", "roundRect");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        this.getContentPane().add((Component)this.advancedSettingsButton, gridBagConstraints);
        this.progressBar.setFont(this.progressBar.getFont().deriveFont(16.0f));
        this.progressBar.setAlignmentX(0.0f);
        this.progressBar.setAlignmentY(0.0f);
        this.progressBar.setMaximumSize(new Dimension(380, 25));
        this.progressBar.setMinimumSize(new Dimension(380, 25));
        this.progressBar.setPreferredSize(new Dimension(380, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(30, 0, 0, 0);
        this.getContentPane().add((Component)this.progressBar, gridBagConstraints);
        this.installButton.setFont(this.installButton.getFont().deriveFont(20.0f).deriveFont(1));
        this.installButton.setText("Install");
        this.installButton.setToolTipText("");
        this.installButton.setMargin(new Insets(10, 70, 10, 70));
        this.installButton.setMaximumSize(new Dimension(320, 45));
        this.installButton.setMinimumSize(new Dimension(173, 45));
        this.installButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                NewInstaller.this.installButtonMouseClicked(evt);
            }
        });
        this.installButton.putClientProperty("JButton.buttonType", "roundRect");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.insets = new Insets(30, 0, 30, 0);
        this.getContentPane().add((Component)this.installButton, gridBagConstraints);
        this.installationDirectory.setFont(this.installationDirectory.getFont().deriveFont(this.installationDirectory.getFont().getStyle() | 1, 16.0f));
        this.installationDirectory.setHorizontalAlignment(0);
        this.installationDirectory.setText("Installation directory:");
        this.installationDirectory.setHorizontalTextPosition(0);
        this.installationDirectory.setMaximumSize(new Dimension(300, 24));
        this.installationDirectory.setMinimumSize(new Dimension(165, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.settings.add((Component)this.installationDirectory, gridBagConstraints);
        this.directoryName.setFont(this.directoryName.getFont().deriveFont(16.0f));
        this.directoryName.setLabel("Directory Name");
        this.directoryName.setMaximumSize(new Dimension(300, 36));
        this.directoryName.setMinimumSize(new Dimension(300, 36));
        this.directoryName.setPreferredSize(new Dimension(300, 36));
        this.directoryName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                NewInstaller.this.directoryNameMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.settings.add((Component)this.directoryName, gridBagConstraints);
        this.installationType.setFont(this.installationType.getFont().deriveFont(this.installationType.getFont().getStyle() | 1, 16.0f));
        this.installationType.setHorizontalAlignment(0);
        this.installationType.setText(" Installation type:");
        this.installationType.setHorizontalTextPosition(0);
        this.installationType.setMaximumSize(new Dimension(300, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.settings.add((Component)this.installationType, gridBagConstraints);
        this.installationTypesContainer.setLayout(new BorderLayout(10, 0));
        this.installType.add(this.standaloneType);
        this.standaloneType.setFont(this.standaloneType.getFont().deriveFont(16.0f));
        this.standaloneType.setSelected(true);
        this.standaloneType.setText("Iris Only");
        this.standaloneType.setToolTipText("");
        this.standaloneType.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                NewInstaller.this.standaloneTypeMouseClicked(evt);
            }
        });
        this.installationTypesContainer.add((Component)this.standaloneType, "Before");
        this.installType.add(this.fabricType);
        this.fabricType.setFont(this.fabricType.getFont().deriveFont(16.0f));
        this.fabricType.setText("Iris + Fabric");
        this.fabricType.setToolTipText("");
        this.fabricType.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                NewInstaller.this.fabricTypeMouseClicked(evt);
            }
        });
        this.installationTypesContainer.add((Component)this.fabricType, "After");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.settings.add((Component)this.installationTypesContainer, gridBagConstraints);
        this.installationExplanation = new JLabel();
        this.installationExplanation.setFont(this.installationExplanation.getFont().deriveFont(13.0f));
        this.installationExplanation.setHorizontalAlignment(0);
        this.installationExplanation.setText("<html><center>Installs the Iris shader-loader to a reserved location to avoid unexpected problems.</center></html>");
        this.installationExplanation.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.settings.add((Component)this.installationExplanation, gridBagConstraints);
        this.standaloneType.addActionListener(e -> {
            this.standaloneTypeMouseClicked(null);
            this.installationExplanation.setText("<html><center>Installs the Iris shader-loader to a reserved location to avoid unexpected problems.</center></html>");
            this.euphoriaDescription.setVisible(false);
        });
        this.fabricType.addActionListener(e -> {
            this.fabricTypeMouseClicked(null);
            this.installationExplanation.setText("<html><center>Installs Iris to the mods folder with a Fabric installation. This allows adding more Fabric mods, but it might cause a problem if there are already existing mods in your mods folder.</center></html>");
            this.euphoriaDescription.setVisible(false);
        });
        this.euphoriaSelection.setSelected(false);
        this.euphoriaSelection.setFont(this.euphoriaSelection.getFont().deriveFont(16.0f));
        this.euphoriaSelection.setText("Install Euphoria Patches");
        this.euphoriaSelection.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.settings.add((Component)this.euphoriaSelection, gridBagConstraints);
        this.euphoriaDescription.setFont(this.euphoriaDescription.getFont().deriveFont(13.0f));
        this.euphoriaDescription.setHorizontalAlignment(0);
        this.euphoriaDescription.setText("<html><center>Euphoria Patches is an add-on for Complementary that extends it with many optional features and settings while not changing the default look of Complementary. It may be a bit behind in updates (usually not) or contain small bugs, in which case you can come back later for an updated version. Developed by SpacEagle17</center></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.settings.add((Component)this.euphoriaDescription, gridBagConstraints);
        this.euphoriaDescription.setVisible(false);
        this.euphoriaSelection.addItemListener(e -> {
            this.euphoriaDescription.setVisible(e.getStateChange() == 1);
            this.installationExplanation.setText("");
        });
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void directoryNameMouseClicked(MouseEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setFileHidingEnabled(false);
        int option = fileChooser.showOpenDialog(this);
        if (option == 0) {
            File file = fileChooser.getSelectedFile();
            this.customInstallDir = file.toPath();
            this.directoryName.setText(file.getName());
        }
    }

    private void gameVersionListItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.selectedVersion = this.GAME_VERSIONS.stream().filter(v -> v.name.equals(evt.getItem())).findFirst().orElse(this.GAME_VERSIONS.get(0));
            if (this.selectedVersion.outdated) {
                this.outdatedText1.setText("Warning: Iris shader loader has ended support for <version>.".replace("<version>", this.selectedVersion.name));
                this.outdatedText1.setVisible(true);
                this.outdatedText2.setText("The Iris version you get will most likely be outdated.");
                this.outdatedText2.setVisible(true);
            } else if (this.selectedVersion.snapshot) {
                this.outdatedText1.setText("Warning: <version> is a snapshot build and may".replace("<version>", this.selectedVersion.name));
                this.outdatedText1.setVisible(true);
                this.outdatedText2.setText("lose support at any time.");
                this.outdatedText2.setVisible(true);
            } else {
                this.outdatedText1.setVisible(false);
                this.outdatedText2.setVisible(false);
            }
        }
    }

    private void standaloneTypeMouseClicked(MouseEvent evt) {
        this.installAsMod = false;
    }

    private void fabricTypeMouseClicked(MouseEvent evt) {
        this.installAsMod = true;
    }

    private void unboundStyleMouseClicked(MouseEvent evt) {
        this.styleIsUnbound = true;
    }

    private void reimaginedStyleMouseClicked(MouseEvent evt) {
        this.styleIsUnbound = false;
    }

    private Path getModsFolder() {
        return this.installAsMod ? this.getInstallDir().resolve("mods") : this.getInstallDir().resolve("iris-reserved").resolve(this.selectedVersion.name);
    }

    private void installButtonMouseClicked(MouseEvent evt) {
        if (NewInstaller.isInternetNotAvailable() && this.showNetworkErrorDialog("starting installation")) {
            this.installButtonMouseClicked(evt);
            return;
        }
        this.installButton.setText("Downloading...");
        this.installButton.setEnabled(false);
        this.progressBar.setForeground(new Color(76, 135, 200));
        this.progressBar.setValue(0);
        String loaderName = this.installAsMod ? "fabric-loader" : "iris-fabric-loader";
        try {
            URL loaderVersionUrl = new URL("https://raw.githubusercontent.com/IrisShaders/Iris-Installer-Maven/master/latest-loader");
            String profileName = this.installAsMod ? "Fabric Loader " : "Iris & Sodium for ";
            VanillaLauncherIntegration.Icon profileIcon = this.installAsMod ? VanillaLauncherIntegration.Icon.FABRIC : VanillaLauncherIntegration.Icon.IRIS;
            Path modsFolder0 = this.getModsFolder();
            String loaderVersion = Main.LOADER_META.getLatestVersion(false).getVersion();
            if (NewInstaller.isInternetNotAvailable()) {
                throw new IOException("Internet connection lost before installing to launcher");
            }
            boolean success = VanillaLauncherIntegration.installToLauncher(this, this.getVanillaGameDir(), this.getInstallDir(), modsFolder0, profileName + this.selectedVersion.name, this.selectedVersion.name, loaderName, loaderVersion, profileIcon);
            if (!success) {
                System.out.println("Failed to install to launcher, canceling!");
                return;
            }
        }
        catch (Exception e) {
            System.out.println("Failed to install version and profile to vanilla launcher!");
            e.printStackTrace();
            if (this.isNetworkError(e) && this.showNetworkErrorDialog("installing to launcher")) {
                System.out.println("No internet connection while installing to launcher, retrying...");
                this.installButtonMouseClicked(evt);
                return;
            }
            JOptionPane.showMessageDialog(this, "Failed to install to vanilla launcher, please check your internet connection or contact the Iris support team via Discord! \nError: " + e, "Failed to install to launcher", 0);
            this.installButton.setEnabled(true);
            this.installButton.setText("Install");
            this.progressBar.setValue(0);
            return;
        }
        File storageDir = this.getStorageDirectory().toFile();
        if (!storageDir.exists() || !storageDir.isDirectory()) {
            storageDir.mkdir();
        }
        String zipName = "Iris-Sodium-" + this.selectedVersion.name + ".zip";
        String irisDownURL = "https://github.com/IrisShaders/Iris-Installer-Files/releases/latest/download/" + zipName;
        File saveLocation = this.getStorageDirectory().resolve(zipName).toFile();
        Downloader downloaderI = new Downloader(irisDownURL, saveLocation);
        downloaderI.addPropertyChangeListener(eventI -> {
            if ("progress".equals(eventI.getPropertyName())) {
                this.progressBar.setValue((Integer)eventI.getNewValue() / 2);
            } else if (eventI.getNewValue() == SwingWorker.StateValue.DONE) {
                boolean installISuccess;
                File modsFolder;
                File[] modsFolderContents;
                try {
                    downloaderI.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    this.handleDownloadError(e, "Iris and Sodium");
                    return;
                }
                boolean cancelled = false;
                File installDir = this.getInstallDir().toFile();
                if (!installDir.exists() || !installDir.isDirectory()) {
                    installDir.mkdir();
                }
                if ((modsFolderContents = (modsFolder = this.getModsFolder().toFile()).listFiles()) != null) {
                    int result;
                    boolean isEmpty;
                    boolean bl = isEmpty = modsFolderContents.length == 0;
                    if (this.installAsMod && modsFolder.exists() && modsFolder.isDirectory() && !isEmpty && (result = JOptionPane.showConfirmDialog(this, "An existing mods folder was found in the selected game directory. Do you want to update/install iris?", "Mods Folder Detected", 0, 3)) != 0) {
                        cancelled = true;
                    }
                    if (!cancelled) {
                        boolean shownOptifineDialog = false;
                        boolean failedToRemoveOptifine = false;
                        File[] fileArray = modsFolderContents;
                        int n = fileArray.length;
                        for (int i = 0; i < n; ++i) {
                            File mod = fileArray[i];
                            if (!mod.getName().toLowerCase().contains("optifine") && !mod.getName().toLowerCase().contains("optifabric")) continue;
                            if (!shownOptifineDialog) {
                                int result2 = JOptionPane.showOptionDialog(this, "Optifine was found in your mods folder, but Optifine is incompatible with Iris. Do you want to remove it, or cancel the installation?", "Optifine Detected", -1, 2, null, new String[]{"Yes", "Cancel"}, "Yes");
                                shownOptifineDialog = true;
                                if (result2 != 0) {
                                    cancelled = true;
                                    break;
                                }
                            }
                            if (mod.delete()) continue;
                            failedToRemoveOptifine = true;
                        }
                        if (failedToRemoveOptifine) {
                            System.out.println("Failed to delete optifine from mods folder");
                            JOptionPane.showMessageDialog(this, "Failed to remove optifine from your mods folder, please make sure your game is closed and try again!", "Failed to remove optifine", 0);
                            cancelled = true;
                        }
                    }
                    if (!cancelled) {
                        boolean failedToRemoveIrisOrSodium = false;
                        for (File mod : modsFolderContents) {
                            if (!mod.getName().toLowerCase().contains("iris") && !mod.getName().toLowerCase().contains("sodium-fabric") || mod.delete()) continue;
                            failedToRemoveIrisOrSodium = true;
                        }
                        if (failedToRemoveIrisOrSodium) {
                            System.out.println("Failed to remove Iris or Sodium from mods folder to update them!");
                            JOptionPane.showMessageDialog(this, "Failed to remove iris and sodium from your mods folder to update them, please make sure your game is closed and try again!", "Failed to prepare mods for update", 0);
                            cancelled = true;
                        }
                    }
                }
                if (cancelled) {
                    this.installButton.setEnabled(true);
                    return;
                }
                if (!modsFolder.exists() || !modsFolder.isDirectory()) {
                    modsFolder.mkdir();
                }
                if (installISuccess = this.installFromZip(saveLocation)) {
                    try {
                        this.downloadShader(installDir, modsFolder);
                    }
                    catch (IOException e) {
                        this.handleDownloadError(e, "shader information");
                    }
                } else {
                    this.installButton.setText("Failed!");
                    this.progressBar.setForeground(new Color(204, 0, 0));
                    System.out.println("Failed to install to mods folder!");
                    JOptionPane.showMessageDialog(this, "Failed to install to mods folder, please make sure your game is closed and try again!", "Installation Failed!", 0);
                }
            }
        });
        downloaderI.execute();
    }

    private void downloadShader(File installDir, File modsFolder) throws IOException {
        JSONObject shaderInfo;
        File shaderDir = new File(installDir, "shaderpacks");
        if (!shaderDir.exists()) {
            shaderDir.mkdirs();
        }
        String projectId = this.styleIsUnbound ? COMPLEMENTARY_UNBOUND_PROJECT_ID : COMPLEMENTARY_REIMAGINED_PROJECT_ID;
        String shaderType = this.styleIsUnbound ? "Complementary Unbound" : "Complementary Reimagined";
        compStatsFile = this.styleIsUnbound ? "aaaConfirmUnboundDownload.txt" : "aaaConfirmReimaginedDownload.txt";
        try {
            shaderInfo = this.getLatestModrinthInfo(projectId, null);
        }
        catch (Exception e) {
            if (this.isNetworkError(e) && this.showNetworkErrorDialog("fetching shader information")) {
                this.downloadShader(installDir, modsFolder);
                return;
            }
            throw new IOException("Could not get shader information: " + e.getMessage(), e);
        }
        if (shaderInfo == null) {
            throw new IOException("Could not find " + shaderType + " information on Modrinth");
        }
        String finalShaderName = shaderInfo.getString("filename");
        String downloadUrl = shaderInfo.getString("url");
        String version = shaderInfo.getString("version");
        File shaderFile = new File(shaderDir, finalShaderName);
        System.out.println("Found " + shaderType + " version: " + version);
        System.out.println("Expected shader file: " + shaderFile.getAbsolutePath());
        if (shaderFile.exists()) {
            System.out.println("Complementary Shaders already exists: " + finalShaderName);
            if (this.euphoriaSelection.isSelected()) {
                this.handleEuphoriaPatches(modsFolder, finalShaderName, version, shaderDir, installDir);
            } else {
                this.completeInstallation(finalShaderName, installDir);
            }
            return;
        }
        String compStatsUrl = "https://github.com/ComplementaryDevelopment/ComplementaryReimagined/releases/download/latest/" + compStatsFile;
        this.downloadStatisticsConfirmation(shaderDir, compStatsUrl, compStatsFile);
        System.out.println("Complementary Shader not found, downloading...");
        this.downloadFile(downloadUrl, shaderFile, shaderType, 50, 90, () -> {
            if (this.euphoriaSelection.isSelected()) {
                this.handleEuphoriaPatches(modsFolder, finalShaderName, version, shaderDir, installDir);
            } else {
                this.completeInstallation(finalShaderName, installDir);
            }
        });
    }

    private void handleEuphoriaPatches(File modsFolder, String baseShaderName, String baseShaderVersion, File shaderDir, File installDir) {
        try {
            JSONObject epInfo;
            try {
                epInfo = this.getLatestModrinthInfo(EUPHORIA_PATCHES_PROJECT_ID, "fabric");
            }
            catch (Exception e) {
                if (this.isNetworkError(e) && this.showNetworkErrorDialog("fetching EuphoriaPatcher information")) {
                    this.handleEuphoriaPatches(modsFolder, baseShaderName, baseShaderVersion, shaderDir, installDir);
                    return;
                }
                throw e;
            }
            if (epInfo == null) {
                System.out.println("Could not find EuphoriaPatcher on Modrinth, continuing without it");
                this.completeInstallation(baseShaderName, installDir);
                return;
            }
            String epFilename = epInfo.getString("filename");
            String epVersion = epInfo.getString("version");
            File epFile = new File(modsFolder, epFilename);
            String finalShaderName = baseShaderName.replace(".zip", " + ") + epFilename.replace("EuphoriaPatcher-", "EuphoriaPatches_").replace("-fabric.jar", "").replace("-" + baseShaderVersion, "");
            System.out.println("Found EuphoriaPatcher version: " + epVersion);
            System.out.println("Expected EP file: " + epFile.getAbsolutePath());
            if (epFile.exists()) {
                System.out.println("EuphoriaPatcher already exists: " + epFilename);
                this.completeInstallation(finalShaderName, installDir);
                return;
            }
            String epStatsUrl = "https://github.com/EuphoriaPatches/Complementary-Installer-Files/releases/download/release/aaaConfirmEPDownload.txt";
            this.downloadStatisticsConfirmation(shaderDir, epStatsUrl, euphoriaStatsFile);
            System.out.println("EuphoriaPatcher not found, downloading...");
            String epDownloadUrl = epInfo.getString("url");
            this.downloadFile(epDownloadUrl, epFile, "EuphoriaPatcher", 90, 99, () -> this.completeInstallation(finalShaderName, installDir));
        }
        catch (Exception e) {
            System.out.println("Error getting EuphoriaPatcher info: " + e.getMessage());
            this.completeInstallation(baseShaderName, installDir);
        }
    }

    private void downloadFile(String downloadUrl, File targetFile, String downloadType, int progressStart, int progressEnd, Runnable onComplete) {
        System.out.println("Downloading " + downloadType + " to: " + targetFile.getAbsolutePath() + " from URL: " + downloadUrl);
        try {
            Downloader downloader = new Downloader(downloadUrl, targetFile);
            int progressRange = progressEnd - progressStart;
            downloader.addPropertyChangeListener(event -> {
                if ("progress".equals(event.getPropertyName())) {
                    int progress = (Integer)event.getNewValue();
                    int scaledProgress = progressStart + progress * progressRange / 100;
                    this.progressBar.setValue(scaledProgress);
                } else if (event.getNewValue() == SwingWorker.StateValue.DONE) {
                    try {
                        downloader.get();
                        System.out.println("Successfully downloaded " + downloadType + ": " + targetFile.getName());
                        onComplete.run();
                    }
                    catch (Exception e) {
                        System.out.println("Failed to download " + downloadType + ": " + e.getMessage());
                        File shaderDir = new File(this.getInstallDir().toFile(), "shaderpacks");
                        if (this.isNetworkError(e) && this.showNetworkErrorDialog("downloading " + downloadType)) {
                            this.downloadFile(downloadUrl, targetFile, downloadType, progressStart, progressEnd, onComplete);
                        }
                        this.handleDownloadError(e, downloadType);
                    }
                }
            });
            downloader.execute();
        }
        catch (Exception e) {
            System.out.println("Error preparing download: " + e.getMessage());
            if (this.isNetworkError(e) && this.showNetworkErrorDialog("preparing to download " + downloadType)) {
                this.downloadFile(downloadUrl, targetFile, downloadType, progressStart, progressEnd, onComplete);
            }
            this.handleDownloadError(e, downloadType);
        }
    }

    private void completeInstallation(String finalShaderName, File installDir) {
        this.installButton.setText("Completed!");
        this.progressBar.setForeground(new Color(39, 195, 75));
        this.progressBar.setValue(100);
        this.installButton.setEnabled(false);
        this.deleteStatisticsConfirmation(this.getInstallDir().resolve("shaderpacks").toFile());
        this.updateIrisConfiguration(installDir, finalShaderName);
        System.out.println("Finished Successful Install");
        String loaderSt = this.installAsMod ? "fabric-loader" : "iris-fabric-loader";
        String msg = "Successfully installed Iris, Sodium and " + finalShaderName + ".\nYou can run the game by selecting " + loaderSt + " in your Minecraft launcher.";
        JOptionPane.showMessageDialog(this, msg, "Installation Complete!", -1, new ImageIcon(Objects.requireNonNull(Utils.class.getClassLoader().getResource("green_tick.png"))));
        System.exit(0);
    }

    private void updateIrisConfiguration(File installDir, String finalShaderName) {
        File configDir = new File(installDir, "config");
        if (!configDir.exists() || !configDir.isDirectory()) {
            configDir.mkdir();
        }
        File ipDir = new File(configDir, "iris.properties");
        Properties irisProp = new Properties();
        irisProp.setProperty("shaderPack", finalShaderName);
        irisProp.setProperty("enableShaders", "true");
        try (OutputStream os = Files.newOutputStream(ipDir.toPath(), new OpenOption[0]);){
            irisProp.store(os, "Iris Properties");
            System.out.println("Successfully wrote iris.properties");
        }
        catch (IOException e) {
            System.out.println("Failed to write iris.properties: " + e.getMessage());
        }
        String folderPath = this.installAsMod ? "mods" : "iris-reserved/" + this.selectedVersion.name;
        File installInfoFile = new File(configDir, "installedByCompInstaller.txt");
        try {
            String installInfo = "File written by Complementary Shaders Installer - in the " + folderPath + " folder";
            Files.write(installInfoFile.toPath(), Collections.singletonList(installInfo), new OpenOption[0]);
            System.out.println("Successfully wrote installation info file");
        }
        catch (IOException e) {
            System.out.println("Failed to write installation info file: " + e.getMessage());
        }
    }

    private void downloadStatisticsConfirmation(File targetDir, String downloadUrl, String filename) {
        try {
            File confirmationFile = new File(targetDir, filename);
            URL url = new URL(downloadUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            try (InputStream in = connection.getInputStream();
                 FileOutputStream out = new FileOutputStream(confirmationFile);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            System.out.println("Downloaded statistics confirmation file: " + filename);
        }
        catch (Exception e) {
            System.out.println("Note: Failed to download statistics file " + filename + ": " + e.getMessage());
        }
    }

    private void deleteStatisticsConfirmation(File shaderDir) {
        try {
            File compConfirmationFile;
            File epConfirmationFile = new File(shaderDir, euphoriaStatsFile);
            if (epConfirmationFile.exists()) {
                epConfirmationFile.delete();
                System.out.println("Deleted EP statistics confirmation file");
            }
            if ((compConfirmationFile = new File(shaderDir, compStatsFile)).exists()) {
                compConfirmationFile.delete();
                System.out.println("Deleted Complementary statistics confirmation file");
            }
        }
        catch (Exception e) {
            System.out.println("Note: Failed to delete statistics files: " + e.getMessage());
        }
    }

    private boolean isNetworkError(Exception e) {
        if (e instanceof UnknownHostException || e instanceof SocketTimeoutException || e instanceof NoRouteToHostException || e instanceof ConnectException) {
            return true;
        }
        if (e.getCause() instanceof UnknownHostException || e.getCause() instanceof SocketTimeoutException || e.getCause() instanceof NoRouteToHostException || e.getCause() instanceof ConnectException) {
            return true;
        }
        return NewInstaller.isInternetNotAvailable();
    }

    private void handleDownloadError(Exception e, String downloadType) {
        System.out.println("Failed to download " + downloadType + "!");
        e.printStackTrace();
        String msg = e.getCause() instanceof UnknownHostException || e.getCause() instanceof SocketTimeoutException ? "Internet connection lost while downloading " + downloadType + ". Please check your connection and try again." : String.format("An error occurred while attempting to download " + downloadType + " files, please check your internet connection and try again! \nError: %s", e.getCause().toString());
        this.installButton.setEnabled(true);
        this.installButton.setText("Download Failed!");
        this.progressBar.setForeground(new Color(204, 0, 0));
        this.progressBar.setValue(100);
        JOptionPane.showMessageDialog(this, msg, "Download Failed!", 0, null);
    }

    private JSONObject getLatestModrinthInfo(String projectId, String loaderFilter) throws IOException, JSONException {
        try {
            String line;
            String apiUrl = "https://api.modrinth.com/v2/project/" + projectId + "/version";
            URL url = new URL(apiUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("User-Agent", "Complementary-Installer");
            if (connection.getResponseCode() != 200) {
                System.out.println("Failed to fetch from Modrinth API: " + connection.getResponseCode());
                JOptionPane.showMessageDialog(this, "Failed to contact Modrinth API (HTTP " + connection.getResponseCode() + ").\nThe shader information could not be retrieved.", "API Connection Error", 0);
                return null;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder responseBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                responseBuilder.append(line);
            }
            reader.close();
            JSONArray versionsArray = new JSONArray(responseBuilder.toString());
            for (int i = 0; i < versionsArray.length(); ++i) {
                JSONArray files;
                JSONObject version = versionsArray.getJSONObject(i);
                if (loaderFilter != null && !loaderFilter.isEmpty()) {
                    JSONArray loaders = version.optJSONArray("loaders");
                    boolean matchesLoader = false;
                    if (loaders != null) {
                        for (int j = 0; j < loaders.length(); ++j) {
                            if (!loaderFilter.equals(loaders.getString(j))) continue;
                            matchesLoader = true;
                            break;
                        }
                    }
                    if (!matchesLoader) continue;
                }
                if ((files = version.getJSONArray("files")).isEmpty()) continue;
                JSONObject file = files.getJSONObject(0);
                String filename = file.getString("filename");
                JSONObject result = new JSONObject();
                result.put("url", file.getString("url"));
                result.put("filename", filename);
                result.put("version", version.getString("version_number"));
                result.put("projectId", projectId);
                return result;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println("Error fetching from Modrinth: " + e.getMessage());
            if (this.isNetworkError(e) && this.showNetworkErrorDialog("fetching information from Modrinth")) {
                return this.getLatestModrinthInfo(projectId, loaderFilter);
            }
            throw e;
        }
    }

    public static void openURL(URI uri) {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        Desktop d = Desktop.getDesktop();
        if (!d.isSupported(Desktop.Action.BROWSE)) {
            return;
        }
        try {
            d.browse(uri);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void registerStatsCleanupHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                File shaderDir = new File(this.getInstallDir().toFile(), "shaderpacks");
                this.deleteStatisticsConfirmation(shaderDir);
                System.out.println("Cleanup performed during shutdown");
            }
            catch (Exception e) {
                System.out.println("Error during shutdown cleanup: " + e.getMessage());
            }
        }));
        System.out.println("Registered statistics cleanup hook");
    }

    public static void main(String[] args) {
        dark = DarkModeDetector.isDarkMode();
        System.setProperty("apple.awt.application.appearance", "system");
        if (dark) {
            FlatDarkLaf.setup();
        } else {
            FlatLightLaf.setup();
        }
        System.out.println("Launching installer...");
        EventQueue.invokeLater(() -> new NewInstaller().setVisible(true));
    }
}

