/*
 * Decompiled with CFR 0.152.
 */
package net.hypercubemc.iris_installer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Pattern;

public class DarkModeDetector {
    private static final String REGQUERY_UTIL = "reg query ";
    private static final String REGDWORD_TOKEN = "REG_DWORD";
    private static final String DARK_THEME_CMD = "reg query \"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize\" /v AppsUseLightTheme";

    public static boolean isDarkMode() {
        switch (DarkModeDetector.getOperatingSystem()) {
            case WINDOWS: {
                return DarkModeDetector.isWindowsDarkMode();
            }
            case MACOS: {
                return DarkModeDetector.isMacOsDarkMode();
            }
            case LINUX: {
                return DarkModeDetector.isGnome() && DarkModeDetector.isGnomeDarkMode();
            }
        }
        return false;
    }

    public static boolean isMacOsDarkMode() {
        boolean isDarkMode = false;
        String line = DarkModeDetector.query("defaults read -g AppleInterfaceStyle");
        if (line.equals("Dark")) {
            isDarkMode = true;
        }
        return isDarkMode;
    }

    public static boolean isWindowsDarkMode() {
        try {
            String result = DarkModeDetector.query(DARK_THEME_CMD);
            int p = result.indexOf(REGDWORD_TOKEN);
            if (p == -1) {
                return false;
            }
            String temp = result.substring(p + REGDWORD_TOKEN.length()).trim();
            return Integer.parseInt(temp.substring("0x".length()), 16) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isGnomeDarkMode() {
        Pattern darkThemeNamePattern = Pattern.compile(".*dark.*", 2);
        return darkThemeNamePattern.matcher(DarkModeDetector.query("gsettings get org.gnome.desktop.interface gtk-theme")).matches();
    }

    public static OperatingSystem getOperatingSystem() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return OperatingSystem.WINDOWS;
        }
        if (os.contains("mac")) {
            return OperatingSystem.MACOS;
        }
        if (os.contains("nix") || os.contains("nux")) {
            return OperatingSystem.LINUX;
        }
        if (os.contains("sunos")) {
            return OperatingSystem.SOLARIS;
        }
        return OperatingSystem.NONE;
    }

    public static boolean isGnome() {
        return DarkModeDetector.getOperatingSystem() == OperatingSystem.LINUX && (DarkModeDetector.queryResultContains("echo $XDG_CURRENT_DESKTOP", "gnome") || DarkModeDetector.queryResultContains("echo $XDG_DATA_DIRS | grep -Eo 'gnome'", "gnome") || DarkModeDetector.queryResultContains("ps -e | grep -E -i \"gnome\"", "gnome"));
    }

    private static boolean queryResultContains(String cmd, String subResult) {
        return DarkModeDetector.query(cmd).toLowerCase().contains(subResult);
    }

    private static String query(String cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            StringBuilder stringBuilder = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String actualReadLine;
                while ((actualReadLine = reader.readLine()) != null) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append(actualReadLine);
                }
            }
            return stringBuilder.toString();
        }
        catch (IOException e) {
            System.out.println("Exception caught while querying the OS:");
            e.printStackTrace();
            return "";
        }
    }

    public static enum OperatingSystem {
        WINDOWS,
        MACOS,
        LINUX,
        SOLARIS,
        NONE;

    }
}

