/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.List;
import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.util.Location;
import org.popcraft.chunky.util.Formatting;
import org.popcraft.chunky.util.Input;

public class CenterCommand
implements ChunkyCommand {
    private final Chunky chunky;

    public CenterCommand(Chunky chunky) {
        this.chunky = chunky;
    }

    @Override
    public void execute(Sender sender, CommandArguments arguments) {
        double centerZ;
        double centerX;
        Optional newX = arguments.next().flatMap(Input::tryDoubleSuffixed);
        Optional newZ = arguments.next().flatMap(Input::tryDoubleSuffixed);
        if (newX.isEmpty() && newZ.isEmpty()) {
            Location coordinate = sender.getLocation();
            centerX = coordinate.getX();
            centerZ = coordinate.getZ();
        } else if (newX.isPresent() && newZ.isPresent()) {
            centerX = (Double)newX.get();
            centerZ = (Double)newZ.get();
        } else {
            sender.sendMessage("help_center", new Object[0]);
            return;
        }
        if (Input.isPastWorldLimit(centerX) || Input.isPastWorldLimit(centerZ)) {
            sender.sendMessage("help_center", new Object[0]);
            return;
        }
        this.chunky.getSelection().center(centerX, centerZ);
        sender.sendMessagePrefixed("format_center", Formatting.number(centerX), Formatting.number(centerZ));
    }

    @Override
    public List<String> suggestions(CommandArguments arguments) {
        return List.of();
    }
}

