/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import java.util.zip.ZipFile;
import mjson.Json;
import net.fabricmc.installer.util.Utils;

public final class LoaderVersion {
    public final String name;
    public final Path path;

    public LoaderVersion(String name) {
        this.name = name;
        this.path = null;
    }

    public LoaderVersion(Path path) throws IOException {
        try (ZipFile zf = new ZipFile(path.toFile());){
            String modJsonContent;
            ZipEntry entry = zf.getEntry("fabric.mod.json");
            if (entry == null) {
                throw new FileNotFoundException("fabric.mod.json");
            }
            try (InputStream is = zf.getInputStream(entry);){
                modJsonContent = Utils.readString(is);
            }
            this.name = Json.read(modJsonContent).at("version").asString();
        }
        catch (ZipError e) {
            throw new IOException(e);
        }
        this.path = path;
    }
}

