<?php if(auth()->guard()->check()): ?>
<?php if(settings('require_address', false) AND !auth()->user()->address->address): ?>
<div id="promo-popup" tabindex="-1" class="bg-gray-900 bg-opacity-50 dark:bg-opacity-80 fixed inset-0 z-30 overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 w-full md:inset-0 h-modal md:h-full" style="
    display: flex;
    align-items: center;
    justify-content: space-evenly;
">
  <div class="relative p-4 w-full max-w-2xl h-full md:h-auto">
      <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 md:p-6">


          <div class="mb-5 text-sm font-light text-gray-500 dark:text-gray-400">
              <h3 class="mb-3 text-2xl font-bold text-gray-900 dark:text-white">
                  <?php echo __('client.provide_missing_information'); ?>

              </h3>
              <p class="mb-2"><?php echo __('client.provide_missing_information_desc'); ?></p>
              <form method="POST" action="<?php echo e(route('update-address')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="grid grid-cols-6 gap-6">
                        <div class="col-span-6 sm:col-span-3">
                            <label for="organization" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('client.organization'); ?> <?php echo __('client.optional'); ?>

                            </label>
                            <input type="text" name="company_name" value="<?php echo e(auth()->user()->address->company_name); ?>" id="organization" class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" placeholder="<?php echo __('client.company_name'); ?>">
                        </div>
                        <div class="col-span-6 sm:col-span-3">
                            <label for="countries" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('client.select_an_option'); ?>

                            </label>
                            <select id="countries" name="country" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                <?php $__currentLoopData = config('utils.countries'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>" <?php if(auth()->user()->address->country == $key): ?> selected <?php endif; ?>><?php echo e($country); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-span-6 sm:col-span-3">
                            <label for="address" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white"><?php echo e(__('client.address')); ?></label>
                            <input type="text" placeholder="<?php echo __('client.address'); ?>" name="address" value="<?php echo e(auth()->user()->address->address); ?>" id="address" class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500">
                        </div>

                        <div class="col-span-6 sm:col-span-3">
                            <label for="city" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('client.city'); ?>

                            </label>
                            <input type="text" placeholder="<?php echo __('client.city'); ?>" name="city" value="<?php echo e(auth()->user()->address->city); ?>" id="city" class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500">
                        </div>
                        <div class="col-span-6 sm:col-span-3">
                            <label for="zip_code" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('client.zip_code'); ?>

                            </label>
                            <input type="text" placeholder="<?php echo __('client.zip_code'); ?>" name="zip_code" value="<?php echo e(auth()->user()->address->zip_code); ?>" id="zip_code" class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500">
                        </div>
                        <div class="col-span-6 sm:col-span-3">
                            <label for="region" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('client.state_region_provice'); ?>

                            </label>
                            <input type="text" placeholder="<?php echo __('client.region'); ?>" name="region" value="<?php echo e(auth()->user()->address->region); ?>" id="region" class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500">
                        </div>
                        <div class="col-span-6 sm:col-full">
                            <button class="text-white bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800" type="submit">
                                <?php echo __('client.save_all'); ?>

                            </button>
                        </div>
                    </div>
                </form>
          </div>

      </div>
  </div>
</div>
<?php endif; ?>
<?php endif; ?>
<?php /**PATH /var/www/wemx/resources/themes/client/tailwind/layouts/widgets/require_address.blade.php ENDPATH**/ ?>