<?php $__env->startSection('css_libraries'); ?>
<link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>" />
<link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
<script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
<script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <div class="row">

      <div class="col-md-6 col-12">
        <div class="card">
          <div class="card-header justify-content-center">
            <div class="oauth-icon"><i class="fab fa-discord icon-32px"></i></div>
          </div>
          <form action="<?php echo e(route('admin.settings.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
          <div class="card-body">
            <div class="row">
              <div class="form-group col-12">
                <label><?php echo __('admin.discord_client_id', ['default' => 'Discord Client ID']); ?></label>
                <input type="text" name="encrypted::oauth::discord[client_id]"
                       value="<?php echo e(Settings::getJson('encrypted::oauth::discord', 'client_id')); ?>"
                       placeholder="<?php echo __('admin.discord_client_id', ['default' => 'Discord Client ID']); ?>" class="form-control">
              </div>

              <div class="form-group col-12">
                <label><?php echo __('admin.discord_client_secret', ['default' => 'Discord Client Secret']); ?></label>
                <input type="password" name="encrypted::oauth::discord[client_secret]"
                       value="<?php echo e(Settings::getJson('encrypted::oauth::discord', 'client_secret')); ?>"
                       placeholder="<?php echo __('admin.discord_client_secret', ['default' => 'Discord Client Secret']); ?>" class="form-control">
              </div>

              <div class="form-group col-12">
                <label><?php echo __('admin.discord_redirect', ['default' => 'Discord Redirect']); ?></label>
                <input type="text" value="<?php echo e(config('app.url') . '/oauth/discord/redirect'); ?>" class="form-control" disabled>
              </div>

              <div class="form-group col-6">
                <div class="control-label"><?php echo __('admin.enable_driver', ['default' => 'Enable Driver']); ?></div>
                <label class="custom-switch mt-2">
                  <input type="checkbox" name="encrypted::oauth::discord[is_enabled]" value="1" class="custom-switch-input"
                         <?php if(Settings::getJson('encrypted::oauth::discord', 'is_enabled', false)): ?> checked <?php endif; ?>>
                  <span class="custom-switch-indicator"></span>
                  <span class="custom-switch-description">
                      <?php echo __('admin.allow_connect_using', ['name' => 'Discord','default' => 'Allow users to connect :name']); ?>

                  </span>
                </label>
              </div>

              <div class="form-group col-6">
                <div class="control-label"><?php echo __('admin.allow_login', ['default' => 'Allow Login']); ?></div>
                <label class="custom-switch mt-2">
                  <input type="checkbox" name="encrypted::oauth::discord[allow_login]" value="1" class="custom-switch-input"
                         <?php if(Settings::getJson('encrypted::oauth::discord', 'allow_login', false)): ?> checked <?php endif; ?>>
                  <span class="custom-switch-indicator"></span>
                  <span class="custom-switch-description">
                      <?php echo __('admin.allow_login_using', ['name' => 'Discord', 'default' => 'Allow users to login using :name']); ?>

                  </span>
                </label>
              </div>

              <div class="col-12" style="display: flex;justify-content: flex-end;">
                <button type="submit" class="btn btn-primary"><?php echo __('admin.update_driver', ['default' => 'Update Driver']); ?></button>
              </div>
            </div>
          </div>
        </form>
        </div>
      </div>

      <div class="col-md-6 col-12">
        <div class="card">
          <div class="card-header justify-content-center">
            <div class="oauth-icon"><i class="fab fa-github icon-32px"></i></div>
          </div>
          <form action="<?php echo e(route('admin.settings.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
          <div class="card-body">
            <div class="row">
              <div class="form-group col-12">
                <label><?php echo __('admin.github_client_id', ['default' => 'Github Client ID']); ?></label>
                <input type="text" name="encrypted::oauth::github[client_id]"
                       value="<?php echo e(Settings::getJson('encrypted::oauth::github', 'client_id')); ?>"
                       placeholder="<?php echo __('admin.github_client_id', ['default' => 'Github Client ID']); ?>" class="form-control">
              </div>

              <div class="form-group col-12">
                <label><?php echo __('admin.github_client_secret', ['default' => 'Github Client Secret']); ?></label>
                <input type="password" name="encrypted::oauth::github[client_secret]"
                       value="<?php echo e(Settings::getJson('encrypted::oauth::github', 'client_secret')); ?>"
                       placeholder="<?php echo __('admin.github_client_secret', ['default' => 'Github Client Secret']); ?>" class="form-control">
              </div>

              <div class="form-group col-12">
                <label><?php echo __('admin.github_redirect', ['default' => 'Github Redirect']); ?></label>
                <input type="text" value="<?php echo e(config('app.url') . '/oauth/github/redirect'); ?>" class="form-control" disabled>
              </div>

              <div class="form-group col-6">
                <div class="control-label"><?php echo __('admin.enable_driver', ['default' => 'Enable Driver']); ?></div>
                <label class="custom-switch mt-2">
                  <input type="checkbox" name="encrypted::oauth::github[is_enabled]" value="1" class="custom-switch-input"
                         <?php if(Settings::getJson('encrypted::oauth::github', 'is_enabled', false)): ?> checked <?php endif; ?>>
                  <span class="custom-switch-indicator"></span>
                  <span class="custom-switch-description">
                      <?php echo __('admin.allow_connect_using', ['name' => 'Github','default' => 'Allow users to connect :name']); ?>

                  </span>
                </label>
              </div>

              <div class="form-group col-6">
                <div class="control-label"><?php echo __('admin.allow_login', ['default' => 'Allow Login']); ?></div>
                <label class="custom-switch mt-2">
                  <input type="checkbox" name="encrypted::oauth::github[allow_login]" value="1" class="custom-switch-input"
                         <?php if(Settings::getJson('encrypted::oauth::github', 'allow_login', false)): ?> checked <?php endif; ?>>
                  <span class="custom-switch-indicator"></span>
                  <span class="custom-switch-description">
                      <?php echo __('admin.allow_login_using', ['name' => 'Github', 'default' => 'Allow users to login using :name']); ?>

                  </span>
                </label>
              </div>

              <div class="col-12" style="display: flex;justify-content: flex-end;">
                <button type="submit" class="btn btn-primary"><?php echo __('admin.update_driver', ['default' => 'Update Driver']); ?></button>
              </div>
            </div>
          </div>
        </form>
        </div>
      </div>

      <div class="col-md-6 col-12">
        <div class="card">
          <div class="card-header justify-content-center">
            <div class="oauth-icon"><i class="fab fa-google icon-32px"></i></div>
          </div>
          <form action="<?php echo e(route('admin.settings.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
          <div class="card-body">
            <div class="row">
              <div class="form-group col-12">
                <label><?php echo __('admin.google_client_id', ['default' => 'Google Client ID']); ?></label>
                <input type="text" name="encrypted::oauth::google[client_id]"
                       value="<?php echo e(Settings::getJson('encrypted::oauth::google', 'client_id')); ?>"
                       placeholder="<?php echo __('admin.google_client_id', ['default' => 'Google Client ID']); ?>" class="form-control">
              </div>

              <div class="form-group col-12">
                <label><?php echo __('admin.google_client_secret', ['default' => 'Google Client Secret']); ?></label>
                <input type="password" name="encrypted::oauth::google[client_secret]"
                       value="<?php echo e(Settings::getJson('encrypted::oauth::google', 'client_secret')); ?>"
                       placeholder="<?php echo __('admin.google_client_secret', ['default' => 'Google Client Secret']); ?>" class="form-control">
              </div>

              <div class="form-group col-12">
                <label><?php echo __('admin.google_redirect', ['default' => 'Google Redirect']); ?></label>
                <input type="text" value="<?php echo e(config('app.url') . '/oauth/google/redirect'); ?>" class="form-control" disabled>
              </div>

              <div class="form-group col-6">
                <div class="control-label"><?php echo __('admin.enable_driver', ['default' => 'Enable Driver']); ?></div>
                <label class="custom-switch mt-2">
                  <input type="checkbox" name="encrypted::oauth::google[is_enabled]" value="1" class="custom-switch-input"
                         <?php if(Settings::getJson('encrypted::oauth::google', 'is_enabled', false)): ?> checked <?php endif; ?>>
                  <span class="custom-switch-indicator"></span>
                  <span class="custom-switch-description">
                      <?php echo __('admin.allow_connect_using', ['name' => 'Google','default' => 'Allow users to connect :name']); ?>

                  </span>
                </label>
              </div>

              <div class="form-group col-6">
                <div class="control-label"><?php echo __('admin.allow_login', ['default' => 'Allow Login']); ?></div>
                <label class="custom-switch mt-2">
                  <input type="checkbox" name="encrypted::oauth::google[allow_login]" value="1" class="custom-switch-input"
                         <?php if(Settings::getJson('encrypted::oauth::google', 'allow_login', false)): ?> checked <?php endif; ?>>
                  <span class="custom-switch-indicator"></span>
                  <span class="custom-switch-description">
                      <?php echo __('admin.allow_login_using', ['name' => 'Google', 'default' => 'Allow users to login using :name']); ?>

                  </span>
                </label>
              </div>

              <div class="col-12" style="display: flex;justify-content: flex-end;">
                <button type="submit" class="btn btn-primary"><?php echo __('admin.update_driver', ['default' => 'Update Driver']); ?></button>
              </div>
            </div>
          </div>
        </form>
        </div>
      </div>

    </div>

<style>
  .oauth-icon {
    width: 64px;
    height: 64px;
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(195deg,#42424a 0%,#191919 100%);
    border-radius: 10px;
    font-size: 32px;
  }

  .icon-32px {
    font-size: 32px;
  }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.oauth'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/settings/oauth.blade.php ENDPATH**/ ?>