<?php $__env->startSection('content'); ?>
<div class="">
    <form action="<?php echo e(route('packages.update', ['package' => $package->id])); ?>" method="POST"
          enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="row">
            <div class="form-group col-md-12 col-12">
                <label for="name"><?php echo e(__('admin.package_name')); ?></label>
                <input type="text" name="name" id="name"
                       placeholder="<?php echo e(__('admin.package_name')); ?>"
                       class="form-control" value="<?php echo e($package->name); ?>" required=""/>
            </div>

            <div class="form-group col-md-6 col-6">
                <label for="category"><?php echo e(__('admin.category')); ?></label>
                <select class="form-control select2 select2-hidden-accessible" name="category" id="category"
                        tabindex="-1" aria-hidden="true">
                    <?php $__currentLoopData = Categories::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($category->id); ?>"
                                <?php if($package->category_id == $category->id): ?> selected <?php endif; ?>><?php echo e($category->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="form-group col-md-6 col-6">
                <label for="status"><?php echo e(__('admin.package_status')); ?></label>
                <select class="form-control select2 select2-hidden-accessible" name="status" id="status"
                        tabindex="-1" aria-hidden="true">
                    <option value="active" <?php if($package->status == 'active'): ?> selected <?php endif; ?>>
                        <?php echo e(__('admin.active')); ?>

                    </option>
                    <option value="unlisted"
                            <?php if($package->status == 'unlisted'): ?> selected <?php endif; ?>>
                        <?php echo e(__('admin.unlisted_only_users_with_direct_link_can_view')); ?>

                    </option>
                    <option value="restricted"
                            <?php if($package->status == 'restricted'): ?> selected <?php endif; ?>>
                        <?php echo e(__('admin.admin_only_only_administrators_can_view')); ?>

                    </option>
                    <option value="inactive"
                            <?php if($package->status == 'inactive'): ?> selected <?php endif; ?>>
                        <?php echo e(__('admin.retired_inactive_package_will_not_be_shown_to_new')); ?>

                    </option>
                </select>
            </div>

            <div class="form-group col-md-12 col-12">
                <label><?php echo e(__('admin.service')); ?></label>
                <input type="text"
                       value="<?php echo e(ucfirst($package->service)); ?>" class="form-control"
                       disabled=""/>
            </div>

            <div class="form-group col-md-12 col-12 mt-3">
                <div class="custom-file">
                    <input type="file" class="custom-file-input" name="icon" id="customFile">
                    <label class="custom-file-label"
                           for="customFile"><?php echo e(__('admin.choose_file')); ?></label>
                </div>
            </div>

            <div class="form-group col-md-12 col-12">
                <label for="description"><?php echo e(__('admin.package_description')); ?></label>
                <textarea class="summernote form-control" name="description" id="description"
                          style="display: none;">
                <?php if(isset($package->description)): ?>
                        <?php echo $package->description; ?>

                    <?php endif; ?>
                </textarea>
            </div>
        </div>

        <div class="row">
            <div class="form-group col-md-6 col-6">
                <label for="global_stock"><?php echo e(__('admin.global_stock')); ?></label>
                <input type="number" name="global_stock" id="global_stock" min="-1"
                       value="<?php echo e($package->global_quantity); ?>" class="form-control"
                       required=""/>
                <small
                    class="form-text text-muted"><?php echo __('admin.client_stock_indicates_the_stock_limit_per_client'); ?></small>
            </div>

            <div class="form-group col-md-6 col-6">
                <label for="stock"><?php echo e(__('admin.per_client_stock')); ?></label>
                <input type="number" name="client_stock" id="stock" min="-1"
                       value="<?php echo e($package->client_quantity); ?>" class="form-control"
                       required=""/>
                <small
                    class="form-text text-muted"><?php echo __('admin.client_stock_indicates_the_stock_limit_per_client'); ?></small>
            </div>

            <div class="form-group col-md-6 col-6">
                <div class="form-group">
                    <div class="control-label"><?php echo e(__('admin.require_domain')); ?></div>
                    <label class="custom-switch mt-2">
                        <input type="checkbox" name="require_domain" class="custom-switch-input"
                               value="1" <?php if($package->require_domain): ?> checked <?php endif; ?>>
                        <span class="custom-switch-indicator"></span>
                        <span
                            class="custom-switch-description"><?php echo e(__('admin.does_this_package_require_the_user_to_have_domain')); ?></span>
                    </label>
                </div>
            </div>

            <div class="form-group col-md-6 col-6">
                <div class="form-group">
                    <div class="control-label"><?php echo e(__('admin.allow_notes')); ?></div>
                    <label class="custom-switch mt-2">
                        <input type="checkbox" name="allow_notes" class="custom-switch-input"
                               value="1" <?php if($package->allow_notes): ?> checked <?php endif; ?>>
                        <span class="custom-switch-indicator"></span>
                        <span class="custom-switch-description">
                            <?php echo e(__('admin.allow_users_to_include_special_notes_additional')); ?>

                        </span>
                    </label>
                </div>
            </div>
        </div>
        <div class="text-right">
            <button class="btn btn-success" type="submit"><?php echo e(__('admin.update')); ?></button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make(AdminTheme::path('packages/edit/master'), ['title' => 'Package Edit', 'tab' => 'index'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/packages/edit/index.blade.php ENDPATH**/ ?>