<?php $__env->startSection('css_libraries'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <?php echo __('admin.nodes'); ?>

                    <a href="<?php echo e(route('pterodactyl.clear_cache')); ?>" class="btn btn-info"
                       onclick="return confirm('<?php echo __('admin.clear_cache_desc'); ?>')">
                        <?php echo __('admin.clear_cache'); ?>

                    </a>
                </div>

                <div class="card-body">

                    <hr>
                    <table class="table">
                        <thead>
                        <tr>
                            <th><?php echo __('admin.uuid'); ?></th>
                            <th><?php echo __('admin.name'); ?></th>
                            <th><?php echo __('admin.auto_ports'); ?></th>
                            <th><?php echo __('admin.ports_range'); ?></th>
                            <th><?php echo __('admin.ip'); ?></th>
                            <th><?php echo __('admin.location_id'); ?></th>
                            <th class="text-right"><?php echo __('admin.actions'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $nodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $node): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $nodeModel = node()::firstOrCreate(
                                    ['node_id' => $node['id']],
                                    ['node_id' => $node['id'], 'location_id' => $node['location_id'], 'fqdn' => $node['fqdn'], 'name' => $node['name']]
                                );
                            ?>
                            <tr>
                                <td><?php echo e($node['uuid']); ?></td>
                                <td><?php echo e($node['name']); ?></td>
                                <td><?php if($nodeModel->auto_ports == 1): ?> <?php echo __('admin.active'); ?><?php else: ?> <?php echo __('admin.inactive'); ?><?php endif; ?></td>
                                <td><?php echo e($nodeModel->getPortRange()); ?></td>
                                <td><?php echo e($nodeModel->getIp()); ?></td>
                                <td><?php echo e($nodeModel->location_id); ?></td>

                                <td class="text-right">
                                    <button type="button" class="btn btn-primary" data-toggle="modal"
                                            data-target="#nodeModal<?php echo e($node['id']); ?>">
                                        <?php echo __('admin.manage'); ?>

                                    </button>
                                </td>
                            </tr>

                            <div class="modal fade" id="nodeModal<?php echo e($node['id']); ?>" tabindex="-1"
                                 role="dialog" aria-labelledby="nodeModalLabel<?php echo e($node['id']); ?>"
                                 aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="nodeModalLabel<?php echo e($node['id']); ?>">
                                                <?php echo __('admin.pterodactyl_edit_node'); ?> #<?php echo e($node['id']); ?></h5>
                                            <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <form action="<?php echo e(route('pterodactyl.nodes.store')); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="node_id" value="<?php echo e($node['id']); ?>">
                                            <input type="hidden" name="location_id" value="<?php echo e($node['location_id']); ?>">
                                            <div class="modal-body">

                                                <div class="form-group col-md-12 col-12">
                                                    <label for="ports_range"><?php echo __('admin.ports_rang_label'); ?></label>
                                                    <input type="text" class="form-control" name="ports_range"
                                                           value="<?php echo e($nodeModel->getPortRange()); ?>" required/>
                                                    <small class="form-text text-muted">
                                                        <?php echo __('admin.ports_rang_desc'); ?>

                                                    </small>
                                                </div>


                                                <div class="form-group col-md-12 col-12">
                                                    <label for="ip"><?php echo __('admin.allocation_addresses_label'); ?></label>
                                                    <input type="text" class="form-control" name="ip"
                                                           value="<?php echo e($nodeModel->getIp()); ?>" required/>
                                                    <small class="form-text text-muted">
                                                        <?php echo __('admin.allocation_addresses_desc'); ?>

                                                    </small>
                                                </div>

                                            </div>

                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal"><?php echo __('admin.close'); ?>

                                                </button>
                                                <button type="submit"
                                                        class="btn btn-primary"><?php echo __('admin.update'); ?>

                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.nodes'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/app/Services/Pterodactyl/Resources/views/admin/default/nodes.blade.php ENDPATH**/ ?>