<?php $__env->startSection('container'); ?>
    <section class="section">
        <div class="section-body">
            <div class="col-12">
                <?php if ($__env->exists(AdminTheme::path('users.user_nav'))) echo $__env->make(AdminTheme::path('users.user_nav'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>

        <div class="col-12">
            <div>
                <div class="card">
                    <div class="card-header">
                        <h4><?php echo __('admin.orders'); ?></h4>
                        <div class="card-header-action">
                            <a href="<?php echo e(route('orders.create')); ?>" class="btn btn-icon icon-left btn-primary"><i
                                    class="fas fa-solid fa-plus"></i> <?php echo __('admin.create'); ?></a>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped table-md">
                                <tbody>
                                <tr>
                                    <th><?php echo __('admin.id'); ?></th>
                                    <th><?php echo __('admin.description'); ?></th>
                                    <th><?php echo __('admin.user'); ?></th>
                                    <th><?php echo __('admin.price'); ?></th>
                                    <th><?php echo __('admin.service'); ?></th>
                                    <th><?php echo __('admin.status'); ?></th>
                                    <th><?php echo __('admin.create_at'); ?></th>
                                    <th class="text-right"><?php echo __('admin.actions'); ?></th>
                                </tr>

                                <?php $__currentLoopData = $user->orders()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(Str::substr($order->id, 0, 8)); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('orders.edit', ['order' => $order->id])); ?>"
                                               style="display: flex; color: #6c757d">
                                                <img alt="image"
                                                     src="<?php echo e(asset('storage/products/' . $order->package['icon'])); ?>"
                                                     class="mr-1 mt-1" style="border-radius: 5px" width="32px"
                                                     height="32px" data-toggle="tooltip" title=""
                                                     data-original-title="<?php echo e($order->package['name']); ?>">

                                                <div class="flex">
                                                    <?php echo e($order->name); ?> <br>
                                                    <small><?php echo e($order->package['name']); ?></small>
                                                </div>
                                            </a>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('users.edit', ['user' => $order->user->id])); ?>"
                                               style="display: flex; color: #6c757d">
                                                <img alt="image" src="<?php echo e($order->user->avatar()); ?>"
                                                     class="rounded-circle mr-1 mt-1" width="32px" height="32px"
                                                     data-toggle="tooltip" title=""
                                                     data-original-title="<?php echo e($order->user->first_name); ?> <?php echo e($order->user->last_name); ?>">
                                                <div class="flex">
                                                    <?php echo e($order->user->username); ?> <br>
                                                    <small><?php echo e($order->user->email); ?></small>
                                                </div>
                                            </a>
                                        </td>
                                        <td><?php echo e(currency('symbol')); ?><?php echo e($order->price['renewal_price']); ?>

                                            / <?php echo e($order->periodToHuman()); ?></td>
                                        <td><?php echo e($order->service); ?></td>
                                        <td>
                                            <div class="flex align-items-center">
                                                <i class="fas fa-solid fa-circle <?php if($order->status == 'active'): ?> text-success
                                                <?php elseif($order->status == 'suspended'): ?> text-warning
                                                <?php elseif($order->status == 'cancelled'
                                                OR $order->status == 'terminated'): ?> text-danger <?php endif; ?>"
                                                   style="font-size: 11px;"></i> <?php echo __('admin.' . $order->status); ?>

                                            </div>
                                        </td>
                                        <td>
                                            <?php echo __('admin.created'); ?>: <?php echo e($order->created_at->translatedFormat(settings('date_format', 'd M Y'))); ?>

                                            <br>
                                            <?php echo __('admin.due_date'); ?>: <?php echo e($order->due_date->translatedFormat(settings('date_format', 'd M Y'))); ?>

                                            <br>
                                        </td>
                                        <td class="text-right">
                                            <a href="<?php echo e(route('orders.edit', ['order' => $order->id])); ?>"
                                               class="btn btn-primary"><?php echo __('admin.manage'); ?>  </a></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.orders'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/users/orders.blade.php ENDPATH**/ ?>