<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <title><?php echo $__env->yieldContent('title'); ?> - <?php echo App\Models\Settings::get('app_name', 'WemX', ); ?></title>   
    <link rel="icon" href="<?php echo App\Models\Settings::get('favicon', 'https://imgur.com/oJDxg2r.png', ); ?>">

    
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Meta Description Tag: Affects click-through rates from search results -->
    <meta name="description" content="<?php echo e($meta_description ?? settings('seo::description', 'Manage your orders with an easy-to-use Dashboard')); ?>">
    <meta name="theme-color" content="<?php echo App\Models\Settings::get('seo::color', '#4f46e5', ); ?>">
    <meta name="keywords" content="<?php echo e($meta_keywords ?? settings('seo::keywords', '')); ?>">

    <!-- Meta Robots Tag: Controls search engine crawling and indexing -->
    <meta name="robots" content="<?php echo App\Models\Settings::get('seo::robots', 'index, follow', ); ?>">

    <!-- Open Graph Tags: Enhances visibility and engagement on social media platforms -->
    <meta property="og:title" content="<?php echo App\Models\Settings::get('seo::title', 'WemX', ); ?>">
    <meta property="og:description" content="<?php echo e($meta_description ?? settings('seo::description', 'Manage your orders with an easy-to-use Dashboard')); ?>">
    <meta property="og:image" content="<?php echo App\Models\Settings::get('seo::image', '/static/wemx.png', ); ?>">

    <link rel="icon" href="<?php echo App\Models\Settings::get('favicon', 'https://imgur.com/oJDxg2r.png', ); ?>">
    <?php echo $__env->make(Theme::path('layouts.tailwind'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php if(Settings::getJson('encrypted::captcha::cloudflare', 'is_enabled', false)): ?>
        <script src="https://challenges.cloudflare.com/turnstile/v0/api.js" async defer></script>
    <?php endif; ?>
</head>

<body class="dark:bg-gray-900">
    <div class="app">
        <?php echo $__env->yieldContent('container'); ?>
    </div>
</body>

</html>
<?php /**PATH /var/www/wemx/resources/themes/client/tailwind/auth/wrapper.blade.php ENDPATH**/ ?>