<?php $__env->startSection('css_libraries'); ?>
    <link rel="stylesheet"
          href="<?php echo e(asset(AdminTheme::assets('modules/bootstrap-daterangepicker/daterangepicker.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/bootstrap-daterangepicker/daterangepicker.js'))); ?>"></script>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <div class="row">
        <div class="col-12 col-md-12 col-lg-4">

            <form action="<?php echo e(route('payments.update', ['payment' => $payment->id])); ?>" method="POST"
                  enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <div class="card">
                    <div class="card-header">
                        <h4><?php echo __('admin.payment_details', ['default' => 'Payment Details']); ?></h4>
                    </div>
                    <div class="card-body">
                        <p>
                            <strong><?php echo __('admin.id'); ?>: </strong> <?php echo e($payment->id); ?> <br>
                            <strong><?php echo __('admin.status'); ?>: </strong><?php echo __('admin.' . $payment->status); ?><br>
                            <strong><?php echo __('admin.description'); ?>: </strong> <?php echo e($payment->description); ?> <br>
                            <strong><?php echo __('admin.amount'); ?>

                                : </strong> <?php echo e(currency('symbol')); ?><?php echo e(number_format($payment->amount, 2)); ?> <br>
                            <?php if(isset($payment->due_date)): ?>
                                <strong><?php echo __('admin.due_date'); ?>

                                    : </strong> <?php echo e($payment->due_date->translatedFormat(settings('date_format', 'd M Y'))); ?>

                                (<?php echo e($payment->due_date->diffForHumans()); ?>) <br>
                            <?php endif; ?>
                            <strong><?php echo __('admin.create_at'); ?>

                                : </strong> <?php echo e($payment->created_at->translatedFormat(settings('date_format', 'd M Y'))); ?>

                            (<?php echo e($payment->created_at->diffForHumans()); ?>)
                        </p>
                    </div>
                    <div class="card-footer">
                        <a href="<?php echo e(route('users.edit', ['user' => $payment->user->id])); ?>"
                           class="btn btn-icon icon-left btn-dark"><i
                                class="fas fa-solid fa-user"></i>
                            <?php echo __('admin.user'); ?>

                        </a>
                        <?php if(isset($payment->order_id)): ?>
                            <a href="<?php echo e(route('orders.edit', $payment->order_id)); ?>" class="btn btn-icon icon-left btn-dark"><i
                                    class="fas fa-solid fa-server"></i>
                                <?php echo __('admin.order'); ?>

                            </a>
                        <?php endif; ?>
                        <a href="<?php echo e(route('invoice', ['payment' => $payment->id])); ?>" target="_blank"
                           class="btn btn-icon icon-left btn-dark"><i
                                class="fas fa-solid fa-file"></i>
                            <?php echo __('admin.invoice'); ?>

                        </a>
                        <?php if($payment->status == 'unpaid'): ?>
                            <button type="button" data-toggle="modal" data-target="#CompletePaymentModal" class="btn btn-icon icon-left btn-dark"><i
                                    class="fas fa-solid fa-circle-check"></i>
                                <?php echo __('admin.complete_payment', ['default' => 'Complete Payment']); ?>

                            </button>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if($payment->status == 'paid' OR $payment->status == 'refunded'): ?>
                    <div class="card">
                        <div class="card-header">
                            <h4><?php echo __('admin.gateway_details', ['default' => 'Gateway Details']); ?></h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-8 mb-3">
                                    <label
                                        for="currency"><?php echo __('admin.gateway_name', ['default' => 'Gateway Name']); ?></label>
                                    <input type="text" class="form-control" value="<?php echo e($payment->gateway['name']); ?>"
                                           disabled="">
                                </div>

                                <div class="col-4 mb-3">
                                    <label for="currency"><?php echo __('admin.type', ['default' => 'Type']); ?></label>
                                    <input type="text" class="form-control" value="<?php echo e($payment->gateway['type']); ?>"
                                           disabled="">
                                </div>

                                <div class="col-12 mb-3">
                                    <label for="transaction_id"><?php echo __('admin.transaction_id', ['default' => 'Transaction ID']); ?></label>
                                    <input type="text" class="form-control" name="transaction_id"
                                           value="<?php echo e($payment->transaction_id); ?>" placeholder="<?php echo __('admin.transaction_id', ['default' => 'Transaction ID']); ?>">
                                </div>
                            </div>
                            <!-- Button trigger modal -->
                            <button type="button" class="btn btn-icon icon-left btn-warning" data-toggle="modal"
                                    data-target="#refundModal">
                                <i class="fa-solid fa-arrows-rotate"></i> <?php echo __('admin.refund'); ?>

                            </button>
                        </div>
                    </div>
            <?php endif; ?>
        </div>
        <div class="col-12 col-md-12 col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h4><?php echo __('admin.update_payment', ['default' => 'Update Payment']); ?>

                        <div class="ml-2
                            <?php if($payment->status == 'paid'): ?> badge badge-success
                            <?php elseif($payment->status == 'unpaid'): ?> badge badge-danger
                            <?php elseif($payment->status == 'refunded'): ?> badge badge-warning
                            <?php endif; ?>">
                            <?php echo __('admin.' . $payment->status); ?>

                        </div>
                    </h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="form-group col-md-12 col-12">
                            <label><?php echo __('admin.payment_description', ['default' => 'Payment Description']); ?></label>
                            <input type="text" class="form-control" name="description"
                                   value="<?php echo e($payment->description); ?>" required="">
                        </div>

                        <div class="form-group col-md-4 col-12">
                            <label for="amount"> <?php echo __('admin.amount'); ?></label>

                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">
                                        <?php echo e(currency('symbol')); ?>

                                    </div>
                                </div>
                                <input type="number" class="form-control" name="amount"
                                       value="<?php echo e(number_format($payment->amount, 2)); ?>"
                                       required="" <?php if($payment->status == 'paid'): ?> <?php endif; ?>>
                            </div>
                        </div>

                        <div class="form-group col-md-4 col-12">
                            <label for="currency"> <?php echo __('admin.currency'); ?></label>
                            <input type="text" class="form-control" value="<?php echo e($payment->currency); ?>" disabled="">
                        </div>

                        <div class="form-group col-md-4 col-12">
                            <label for="coupon"><?php echo __('admin.coupon'); ?> <?php echo __('admin.optional'); ?></label>
                            <input type="text" class="form-control" name="coupon" value="<?php echo e($payment->coupon); ?>"
                                   placeholder="TO DO" <?php if($payment->status == 'paid'): ?> disabled="" <?php endif; ?>>
                        </div>

                        <div class="form-group col-md-12 col-12">
                            <label for="user"><?php echo __('admin.user'); ?></label>
                            <select class="form-control select2 select2-hidden-accessible" name="user_id" tabindex="-1"
                                    aria-hidden="true">
                                <?php $__currentLoopData = User::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"
                                            <?php if($payment->user->id == $user->id): ?> selected="" <?php endif; ?>><?php echo e($user->username); ?>

                                        (<?php echo e($user->email); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <?php if(isset($payment->due_date)): ?>
                            <div class="form-group col-md-12 col-12">
                                <label><?php echo __('admin.due_date'); ?></label>
                                <input type="text" class="form-control datetimepicker" name="due_date"
                                       value="<?php echo e($payment->due_date); ?>">
                            </div>
                        <?php endif; ?>

                        <div class="form-group col-md-12 col-12">
                            <label><?php echo __('admin.notes'); ?> <?php echo __('admin.optional'); ?></label>
                            <textarea type="text" class="form-control" rows="4"
                                      name="notes"><?php echo e($payment->notes); ?></textarea>
                        </div>

                        <div class="col-md-12 col-12">
                            <a href="<?php echo e(route('invoice', ['payment' => $payment->id])); ?>" target="_blank"
                               class="btn btn-icon icon-left btn-dark"><i class="fas fa-solid fa-envelope"></i>
                                <?php echo __('admin.email_invoice', ['default' => 'Email Invoice']); ?>

                            </a>
                        </div>
                    </div>

                </div>
                <div class="card-footer text-right">
                    <button class="btn btn-dark" type="submit"><?php echo __('admin.update'); ?></button>
                </div>
            </div>
            </form>
        </div>
    </div>

    <!-- Complete Payment Modal -->
    <div class="modal fade" id="CompletePaymentModal" tabindex="-1" role="dialog" aria-labelledby="CompletePaymentModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
            <h5 class="modal-title" id="CompletePaymentModalLabel">Complete Payment</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            </div>
            <form action="<?php echo e(route('payments.complete', $payment->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <p>You can manually complete payments that are unpaid. On completion, the application will attempt to mark the payment as complete and run the program the payment was created for.</p>
                    
                    <div class="form-group">
                        <label for="user"><?php echo __('client.payment_method'); ?></label>
                        <select class="form-control select2 select2-hidden-accessible" name="gateway" tabindex="-1"
                                aria-hidden="true">
                            <?php $__currentLoopData = App\Models\Gateways\Gateway::getActive('subscription'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($gateway->id); ?>" <?php if(isset($payment->gateway['id']) AND $payment->gateway['id'] == $gateway->id): ?> selected <?php endif; ?>><?php echo e($gateway->name); ?> (<?php echo __('client.subscription'); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = App\Models\Gateways\Gateway::getActive(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($gateway->id); ?>" <?php if(isset($payment->gateway['id']) AND $payment->gateway['id'] == $gateway->id): ?> selected <?php endif; ?>><?php echo e($gateway->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Transaction ID (optional)</label>
                        <input type="text" class="form-control" name="transaction_id" value="">
                    </div>
                </div>
                    <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Complete Payment</button>
                </div>
            </form>
        </div>
        </div>
    </div>

    <?php if($payment->status == 'paid' OR $payment->status == 'refunded'): ?>
        <!-- Refund Modal -->
        <div class="modal fade" id="refundModal" tabindex="-1" role="dialog" aria-labelledby="refundModalLabel"
             aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="refundModalLabel"><?php echo __('admin.refund_payment', ['default' => 'Refund Payment']); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="<?php echo e(route('payments.refund', ['payment' => $payment->id])); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <?php if(!isset($payment->gateway['refund_support']) OR !$payment->gateway['refund_support']): ?>
                                <div class="alert alert-warning">
                                    <?php echo __('admin.refund_payment_not_support', ['default' => 'This gateway does not support refunds']); ?>

                                </div>

                            <?php elseif($payment->status == 'refunded'): ?>
                                <div class="alert alert-info">
                                    <?php echo __('admin.refund_payment_exist', ['default' => 'This payment was already refunded']); ?>

                                </div>
                            <?php elseif($payment->status == 'paid'): ?>
                                <div class="form-group">
                                    <label><?php echo __('admin.refund_amount', ['default' => 'Refund Amount']); ?></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <?php echo e(currency('symbol')); ?>

                                            </div>
                                        </div>
                                        <input type="number" name="amount" class="form-control currency"
                                               value="<?php echo e(number_format($payment->amount, 2)); ?>" min="0.01"
                                               max="<?php echo e($payment->amount); ?>" step="0.01">
                                    </div>
                                </div>

                                <?php if(isset($payment->order_id)): ?>
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" name="cancel_order" class="custom-control-input"
                                               id="customCheck1" value="1">
                                        <label class="custom-control-label" for="customCheck1">
                                            <?php echo __('admin.cancel_order', ['default' => 'Cancel Order']); ?>

                                        </label>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo __('admin.close'); ?></button>
                            <?php if(isset($payment->gateway['refund_support']) AND $payment->gateway['refund_support'] AND $payment->status == 'paid'): ?>
                                <button type="submit" class="btn btn-primary"><?php echo __('admin.submit_refund', ['default' => 'Submit Refund']); ?></button>
                        <?php endif; ?>
                    </form>
                </div>
            </div>
        </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.payments'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/payments/edit.blade.php ENDPATH**/ ?>