<?php $__env->startSection('title', __('client.profile')); ?>
<?php $__env->startSection('container'); ?>
    <div class="grid grid-cols-1 px-4 pt-6 xl:grid-cols-3 xl:gap-4 dark:bg-gray-900">

        <!-- Right Content -->
        <div class="col-span-full xl:col-auto">
            <div class="p-4 mb-4 bg-white rounded-lg shadow sm:p-6 xl:p-8 dark:bg-gray-800">
                <div class="items-center sm:flex xl:block 2xl:flex sm:space-x-4 xl:space-x-0 2xl:space-x-4"
                     style="display: flex;justify-content: space-evenly;">
                    <?php if(auth()->user()->avatar !== null): ?>
                        <img class="mb-4 w-28 h-28 rounded-lg sm:mb-0 xl:mb-4 2xl:mb-0"
                             src="<?php echo e(auth()->user()->avatar()); ?>"
                             alt="user photo">
                    <?php else: ?>
                        <div
                            class="relative inline-flex items-center justify-center mb-4 w-28 h-28 rounded-lg sm:mb-0 xl:mb-4 2xl:mb-0 overflow-hidden bg-gray-100 rounded-full dark:bg-gray-600">
                            <span
                                class="font-medium text-gray-600 dark:text-gray-300"><?php echo e(substr(auth()->user()->first_name, 0, 1) . substr(auth()->user()->last_name, 0, 1)); ?></span>
                        </div>
                    <?php endif; ?>
                    <div>
                        <h3 class="mb-1 text-2xl font-bold text-gray-900 dark:text-white"><?php echo e(auth()->user()->first_name); ?>

                            <?php echo e(auth()->user()->last_name); ?></h3>
                        <div class="mb-4 text-base font-normal text-gray-500 dark:text-gray-400">
                            <?php echo __('client.client'); ?>

                        </div>
                    </div>
                </div>

                <form action="<?php echo e(route('upload-profile-picture')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <label for="dropzone-file"
                           class="flex flex-col justify-center items-center w-full h-20 mt-4 mb-4 bg-gray-50 rounded-lg border-2 border-gray-300 border-dashed cursor-pointer dark:hover:bg-bray-800 dark:bg-gray-700 hover:bg-gray-100 dark:border-gray-600 dark:hover:border-gray-500 dark:hover:bg-gray-600">
                        <div class="flex flex-col justify-center items-center pt-5 pb-6">
                            <p class="mb-2 text-sm text-gray-500 dark:text-gray-400">
                                <?php echo __('client.drag_and_drop'); ?>

                            </p>
                            <p class="text-xs text-gray-500 dark:text-gray-400">SVG, PNG, JPG or GIF (MAX. 800x400px)</p>
                        </div>
                        <input id="dropzone-file" type="file" name="avatar" accept="image/*" required class="hidden">
                    </label>
                    <button type="submit"
                            class="inline-flex items-center py-2 px-3 text-sm font-medium text-center text-white rounded-lg bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                        <svg class="mr-2 -ml-1 w-4 h-4" fill="currentColor" viewBox="0 0 20 20"
                             xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M5.5 13a3.5 3.5 0 01-.369-6.98 4 4 0 117.753-1.977A4.5 4.5 0 1113.5 13H11V9.413l1.293 1.293a1 1 0 001.414-1.414l-3-3a1 1 0 00-1.414 0l-3 3a1 1 0 001.414 1.414L9 9.414V13H5.5z">
                            </path>
                            <path d="M9 13h2v5a1 1 0 11-2 0v-5z"></path>
                        </svg>
                        <?php echo __('client.upload'); ?>

                    </button>
                </form>
            </div>
            <div class="p-4 mb-4 bg-white rounded-lg shadow sm:p-6 xl:p-8 dark:bg-gray-800">
                <h3 class="text-xl font-bold dark:text-white"><?php echo __('client.two_factor_authentication'); ?></h3>
                <p class="text-sm font-normal text-gray-500 dark:text-gray-400 mt-2">
                    <?php echo __('client.two_factor_authentication_desc'); ?>

                </p>
                <ul class="divide-y divide-gray-200 dark:divide-gray-700">
                    <li class="py-4">
                        <div class="flex justify-end space-x-4">
                            <div class="inline-flex items-center">
                                <?php if(!Auth::user()->TwoFa()->exists()): ?>
                                <a href="<?php echo e(route('2fa.setup')); ?>" class="text-white bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-primary-600 dark:hover:bg-primary-700 focus:outline-none dark:focus:ring-primary-800"><?php echo __('client.enable'); ?></a>
                                <?php else: ?>
                                <button type="button" data-modal-target="disableTwoFA" data-modal-toggle="disableTwoFA" class="text-white bg-red-700 hover:bg-red-800 focus:ring-4 focus:ring-red-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-red-600 dark:hover:bg-red-700 focus:outline-none dark:focus:ring-red-800"><?php echo __('client.disable'); ?></button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>

            <div class="p-4 mb-4 bg-white rounded-lg shadow sm:p-6 xl:p-8 dark:bg-gray-800">
                <div class="flow-root">
                    <h3 class="text-xl font-bold dark:text-white"><?php echo __('client.social_accounts'); ?></h3>
                    <ul class="divide-y divide-gray-200 dark:divide-gray-700">
                        <?php if(Settings::getJson('encrypted::oauth::google', 'is_enabled', false)): ?>
                            <li class="pt-4 pb-6">
                                <div class="flex items-center space-x-4">
                                    <div class="flex-shrink-0">
                                        <i class='bx bxl-google dark:text-white ' style="font-size: 1.75rem;"></i>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                    <span class="block text-base font-semibold text-gray-900 truncate dark:text-white">
                                        <?php echo __('client.google_account'); ?>

                                    </span>
                                        <span
                                            class="block text-sm font-normal text-gray-500 truncate dark:text-gray-400 flex items-center">
                                        <?php if(Auth::user()->oauthService('google')->exists()): ?>
                                                <?php echo e(Auth::user()->oauthService('google')->first()->email); ?> <i
                                                    class='bx bxs-badge-check ml-1'></i>
                                            <?php else: ?>
                                                <?php echo __('client.not_connected'); ?>

                                            <?php endif; ?>
                                    </span>
                                    </div>
                                    <div class="inline-flex items-center">
                                        <?php if(Auth::user()->oauthService('google')->exists()): ?>
                                            <a href="<?php echo e(route('oauth.remove', 'google')); ?>"
                                               class="text-red-700 hover:text-white border border-red-700 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm px-3 py-2 text-center mr-3 mb-2 dark:border-red-500 dark:text-red-500 dark:hover:text-white dark:hover:bg-red-600 dark:focus:ring-red-900"><?php echo __('client.remove'); ?></a>
                                        <?php else: ?>
                                            <a href="<?php echo e(route('oauth.connect', 'google')); ?>"
                                               class="py-2 px-3 mr-3 text-sm font-medium text-center text-white rounded-lg bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800"><?php echo __('client.connect'); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </li>
                        <?php endif; ?>
                        <?php if(Settings::getJson('encrypted::oauth::github', 'is_enabled', false)): ?>
                            <li class="pt-4 pb-6">
                                <div class="flex items-center space-x-4">
                                    <div class="flex-shrink-0">
                                        <i class='bx bxl-github dark:text-white ' style="font-size: 1.75rem;"></i>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                    <span class="block text-base font-semibold text-gray-900 truncate dark:text-white">
                                        <?php echo __('client.github_account'); ?>

                                    </span>
                                        <span
                                            class="block text-sm font-normal text-gray-500 truncate dark:text-gray-400">
                                        <?php if(Auth::user()->oauthService('github')->exists()): ?>
                                                <a class="text-blue-500"
                                                   href="<?php echo e(Auth::user()->oauthService('github')->first()->external_profile); ?>"
                                                   target="_blank"><?php echo e(Auth::user()->oauthService('github')->first()->external_profile); ?></a>
                                            <?php else: ?>
                                                <?php echo __('client.not_connected'); ?>

                                            <?php endif; ?>
                                    </span>
                                    </div>
                                    <div class="inline-flex items-center">
                                        <?php if(Auth::user()->oauthService('github')->exists()): ?>
                                            <a href="<?php echo e(route('oauth.remove', 'github')); ?>"
                                               class="text-red-700 hover:text-white border border-red-700 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm px-3 py-2 text-center mr-3 mb-2 dark:border-red-500 dark:text-red-500 dark:hover:text-white dark:hover:bg-red-600 dark:focus:ring-red-900"><?php echo __('client.remove'); ?></a>
                                        <?php else: ?>
                                            <a href="<?php echo e(route('oauth.connect', 'github')); ?>"
                                               class="py-2 px-3 mr-3 text-sm font-medium text-center text-white rounded-lg bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800"><?php echo __('client.connect'); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </li>
                        <?php endif; ?>
                        <?php if(Settings::getJson('encrypted::oauth::discord', 'is_enabled', false)): ?>
                            <li class="pt-4 pb-6">
                                <div class="flex items-center space-x-4">
                                    <div class="flex-shrink-0">
                                        <i class='bx bxl-discord-alt dark:text-white ' style="font-size: 1.75rem;"></i>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                    <span class="block text-base font-semibold text-gray-900 truncate dark:text-white">
                                        <?php echo __('client.discord_account'); ?>

                                    </span>
                                        <span
                                            class="block text-sm font-normal text-gray-500 truncate dark:text-gray-400 flex items-center">
                                        <?php if(Auth::user()->oauthService('discord')->exists()): ?>
                                                <?php echo e(Auth::user()->oauthService('discord')->first()->data->username); ?> <i
                                                    class='bx bxs-badge-check ml-1'></i>
                                            <?php else: ?>
                                                <?php echo __('client.not_connected'); ?>

                                            <?php endif; ?>
                                    </span>
                                    </div>
                                    <div class="inline-flex items-center">
                                        <?php if(Auth::user()->oauthService('discord')->exists()): ?>
                                            <a href="<?php echo e(route('oauth.remove', 'discord')); ?>"
                                               class="text-red-700 hover:text-white border border-red-700 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm px-3 py-2 text-center mr-3 mb-2 dark:border-red-500 dark:text-red-500 dark:hover:text-white dark:hover:bg-red-600 dark:focus:ring-red-900"><?php echo __('client.remove'); ?></a>
                                        <?php else: ?>
                                            <a href="<?php echo e(route('oauth.connect', 'discord')); ?>"
                                               class="py-2 px-3 mr-3 text-sm font-medium text-center text-white rounded-lg bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800"><?php echo __('client.connect'); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </li>
                        <?php endif; ?>
                    </ul>
                    <div>

                    </div>
                </div>
            </div>
            <div class="p-4 mb-4 bg-white rounded-lg shadow sm:p-6 xl:p-8 dark:bg-gray-800">
                <h3 class="text-xl font-bold dark:text-white"><?php echo __('client.sessions'); ?></h3>
                <ul class="divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__currentLoopData = auth()->user()->devices()->latest()->paginate(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="py-4">
                            <div class="flex items-center space-x-4">
                                <div class="flex-shrink-0">
                                    <?php if($device->device_name == 'Phone'): ?>
                                        <svg class="w-6 h-6 dark:text-white" fill="none" stroke="currentColor"
                                             viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                  d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z">
                                            </path>
                                        </svg>
                                    <?php else: ?>
                                        <svg class="w-6 h-6 dark:text-white" fill="none" stroke="currentColor"
                                             viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                  d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                                            </path>
                                        </svg>
                                    <?php endif; ?>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <p class="text-base font-semibold text-gray-900 truncate dark:text-white">
                                        <?php echo e($device->device_type); ?>

                                    </p>
                                    <p class="text-sm font-normal text-gray-500 truncate dark:text-gray-400">
                                        <?php echo e($device->device_name); ?> (<?php echo e($device->ip_address); ?>) <br>
                                        <?php echo __('client.last_seen'); ?>: <?php echo e($device->last_login_at->diffForHumans()); ?>

                                    </p>
                                </div>
                                <div class="inline-flex items-center">
                                    <?php if(!$device->is_revoked): ?>
                                        <a href="<?php echo e(route('revoke', ['device' => $device->id])); ?>"
                                           class="py-2 px-3 mr-3 mb-3 text-sm font-medium text-center text-gray-900 bg-white rounded-lg border border-gray-300 hover:bg-gray-100 focus:ring-4 focus:ring-primary-300 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700">
                                            <?php echo __('client.revoke'); ?></a>
                                    <?php else: ?>
                                        <a href="<?php echo e(route('revoke', ['device' => $device->id])); ?>"
                                           class="text-red-700 hover:text-white border border-red-700 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm px-5 text-center py-2 px-3 mr-3 mb-3 dark:border-red-500 dark:text-red-500 dark:hover:text-white dark:hover:bg-red-600 dark:focus:ring-red-900"><?php echo __('client.revoked'); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div class="pagination pt-6">
                        <?php echo e(auth()->user()->devices()->latest()->paginate(5)->links(Theme::pagination())); ?>

                    </div>
                </ul>
                <div>
                    
                </div>
            </div>
            <?php if(settings('download_user_data', true)): ?>
            <div class="p-4 mb-4 bg-white rounded-lg shadow sm:p-6 xl:p-8 dark:bg-gray-800">
                <h3 class="text-xl font-bold dark:text-white"><?php echo __('client.download_my_data'); ?></h3>
                <p class="text-sm font-normal text-gray-500 dark:text-gray-400 mt-2">
                    <?php echo __('client.download_data_description'); ?>

                </p>
                <ul class="divide-y divide-gray-200 dark:divide-gray-700">
                    <li class="py-4">
                        <div class="flex justify-end space-x-4">
                            <div class="inline-flex items-center">
                                <button type="button" data-modal-target="downloadUserData" data-modal-toggle="downloadUserData" class="text-white bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 mr-2 mb-2 dark:bg-primary-600 dark:hover:bg-primary-700 focus:outline-none dark:focus:ring-primary-800"><?php echo __('client.download'); ?></button>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
            <?php endif; ?>
        </div>
        <div class="col-span-2">
            <div class="p-4 mb-4 bg-white rounded-lg shadow sm:p-6 xl:p-8 dark:bg-gray-800">
                <h3 class="mb-4 text-xl font-bold dark:text-white"><?php echo __('client.general_information'); ?></h3>
                <form method="post" action="<?php echo e(route('update-username')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="grid grid-cols-6 gap-6">
                        <div class="col-span-6 sm:col-span-3">
                            <label for="first-name"
                                   class="block mb-2 text-sm font-medium text-gray-900 dark:text-white"><?php echo __('auth.username'); ?></label>
                            <input type="text" value="<?php echo e(auth()->user()->username); ?>" name="username" required=""
                                   id="first-name"
                                   class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                   placeholder="">
                        </div>
                        <div class="col-span-6 sm:col-span-3">
                            <label for="last-name"
                                   class="block mb-2 text-sm font-medium text-gray-900 dark:text-white"><?php echo __('auth.email'); ?></label>
                            <input type="text" placeholder="<?php echo e(auth()->user()->email); ?>" disabled=""
                                   id="last-name"
                                   class="shadow-sm bg-gray-50 cursor-not-allowed border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" required>
                        </div>
                        <div class="col-span-6 sm:col-span-3">
                            <label for="first-name"
                                   class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('auth.first_name'); ?>

                            </label>
                            <input type="text" placeholder="<?php echo e(auth()->user()->first_name); ?>" disabled=""
                                   id="first-name"
                                   class="shadow-sm bg-gray-50 cursor-not-allowed border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500">
                        </div>
                        <div class="col-span-6 sm:col-span-3">
                            <label for="last-name"
                                   class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('auth.last_name'); ?>

                            </label>
                            <input type="text" placeholder="<?php echo e(auth()->user()->last_name); ?>" disabled=""
                                   id="last-name"
                                   class="shadow-sm bg-gray-50 cursor-not-allowed border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500">
                        </div>
                        <div class="col-span-6 sm:col-span-3">
                            <label for="organization"
                                   class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('client.organization'); ?> <?php echo __('client.optional'); ?>

                            </label>
                            <input type="text" name="company_name"
                                   value="<?php echo e(auth()->user()->address->company_name); ?>" id="organization"
                                   class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500">
                        </div>
                        <div class="col-span-6 sm:col-span-3">
                            <label for="countries" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo e(__('client.select_an_option')); ?>

                            </label>
                            <select id="countries" name="country"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                <?php $__currentLoopData = config('utils.countries'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>"
                                            <?php if(auth()->user()->address->country == $key): ?> selected <?php endif; ?>><?php echo e($country); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-span-6 sm:col-span-3">
                            <label for="address"
                                   class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('auth.address'); ?>

                            </label>
                            <input type="text" name="address"
                                   value="<?php echo e(auth()->user()->address->address); ?>" id="address"
                                   class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500">
                        </div>
                        
                        <div class="col-span-6 sm:col-span-3">
                            <label for="city"
                                   class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('admin.city'); ?>

                            </label>
                            <input type="text" placeholder="<?php echo e(__('client.city')); ?>" name="city"
                                   value="<?php echo e(auth()->user()->address->city); ?>" id="city"
                                   class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500">
                        </div>
                        <div class="col-span-6 sm:col-span-3">
                            <label for="zip_code" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('auth.zip_code'); ?>

                            </label>
                            <input type="text" placeholder="<?php echo e(__('client.zip_code')); ?>" name="zip_code"
                                   value="<?php echo e(auth()->user()->address->zip_code); ?>" id="zip_code"
                                   class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500">
                        </div>
                        <div class="col-span-6 sm:col-span-3">
                            <label for="region"
                                   class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('client.state_region_provice'); ?>

                            </label>
                            <input type="text" placeholder="<?php echo e(__('client.region')); ?>" name="region"
                                   value="<?php echo e(auth()->user()->address->region); ?>" id="region"
                                   class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500">
                        </div>
                        <div class="col-span-6 sm:col-span-3">
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input type="checkbox" value="1" name="is_subscribed" class="sr-only peer"
                                       <?php if(auth()->user()->is_subscribed): ?> checked <?php endif; ?>/>
                                <div
                                    class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600"
                                ></div>
                                <span class="ml-3 text-sm font-medium text-gray-900 dark:text-gray-300"><?php echo __('client.subscribe_to_emails'); ?></span>
                            </label>
                        </div>
                        <div class="col-span-6 sm:col-full">
                            <button
                                class="text-white bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800" type="submit">
                                <?php echo __('client.save_all'); ?>

                            </button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="p-4 mb-4 bg-white rounded-lg shadow sm:p-6 xl:p-8 dark:bg-gray-800">
                <h3 class="mb-4 text-xl font-bold dark:text-white"><?php echo __('auth.update_email'); ?></h3>
                <form method="post" action="<?php echo e(route('update-email')); ?>" autocomplete="off">
                    <?php echo csrf_field(); ?>
                    <div class="">
                        <div class="col-span-6 sm:col-span-3">
                            <label for="current-password"
                                   class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('auth.current_password'); ?>

                            </label>
                            <input type="password" name="current_password" id="current-password"
                                   class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                   placeholder="••••••••" required>
                        </div>
                        <div class="col-span-6 sm:col-span-3 mt-6 mb-6">
                            <label for="new_email"
                                   class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('auth.new_email'); ?>

                            </label>
                            <input type="email" name="new_email" id="new_email"
                                   class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                   required>
                        </div>
                        <div class="col-span-6 sm:col-full">
                            <button
                                class="text-white bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800"
                                type="submit"><?php echo __('client.save_all'); ?>

                            </button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="p-4 mb-4 bg-white rounded-lg shadow sm:p-6 xl:p-8 dark:bg-gray-800">
                <h3 class="mb-4 text-xl font-bold dark:text-white"><?php echo __('auth.update_password'); ?></h3>
                <form method="post" action="<?php echo e(route('update-password')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="grid grid-cols-6 gap-6">
                        <div class="col-span-6 sm:col-span-3">
                            <label for="current-password"
                                   class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('auth.current_password'); ?>

                            </label>
                            <input type="password" name="current_password" id="current-password"
                                   class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                   placeholder="••••••••" required>
                        </div>
                        <div class="col-span-6 sm:col-span-3">
                            <label for="new-password"
                                   class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('auth.new_password'); ?>

                            </label>
                            <input type="password" name="new_password" id="new-password"
                                   class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                   placeholder="••••••••" required>
                        </div>
                        <div class="col-span-6 sm:col-span-3">
                            <label for="confirm-password"
                                   class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __('auth.confirm_password'); ?>

                            </label>
                            <input type="password" name="new_password_confirmation" id="confirm-password"
                                   class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                   placeholder="••••••••" required>
                        </div>
                        <div class="col-span-full">
                            <div class="text-sm font-medium dark:text-white"><?php echo __('auth.password_recommended_requirements'); ?>:</div>
                            <div class="mb-1 text-sm font-normal text-gray-500 dark:text-gray-400">
                                <?php echo __('auth.password_recommended_requirements_desc'); ?>:
                            </div>
                            <ul class="pl-4 space-y-1 text-gray-500 dark:text-gray-400">
                                <li class="text-xs font-normal"><?php echo __('auth.password_recommended_requirements_chracters'); ?></li>
                                <li class="text-xs font-normal"><?php echo __('auth.at_least_lowercase_character'); ?></li>
                                <li class="text-xs font-normal"><?php echo __('auth.inclusion_least_special_character'); ?>

                                    ?
                                </li>
                            </ul>
                        </div>
                        <div class="col-span-6 sm:col-full">
                            <button
                                class="text-white bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800"
                                type="submit"><?php echo __('client.save_all'); ?>

                            </button>
                        </div>
                    </div>
                </form>
            </div>
            <?php if(settings('delete_user_account', true)): ?>
            <div class="p-4 mb-4 bg-white rounded-lg shadow sm:p-6 xl:p-8 dark:bg-gray-800">
                <h3 class="text-xl font-bold dark:text-white"><?php echo __('client.delete_my_account'); ?></h3>
                <p class="text-sm font-normal text-gray-500 dark:text-gray-400 mt-2">
                    <?php echo __('client.delete_account_description'); ?>

                </p>
                <ul class="divide-y divide-gray-200 dark:divide-gray-700">
                    <li class="py-4">
                        <div class="flex justify-end space-x-4">
                            <div class="inline-flex items-center">
                                <?php if($request = auth()->user()->deletion_requests()->first()): ?>
                                    <a href="<?php echo e(route('user.cancel-removal')); ?>" class="text-red-700 hover:text-white border border-red-700 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center mr-2 mb-2 dark:border-red-500 dark:text-red-500 dark:hover:text-white dark:hover:bg-red-600 dark:focus:ring-red-900"><?php echo __('client.cancel'); ?></a>
                                <?php else: ?>
                                    <button type="button" data-modal-target="deleteAccountModal" data-modal-toggle="deleteAccountModal" class="text-red-700 hover:text-white border border-red-700 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center mr-2 mb-2 dark:border-red-500 dark:text-red-500 dark:hover:text-white dark:hover:bg-red-600 dark:focus:ring-red-900"><?php echo __('client.delete_account'); ?></button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
            <?php endif; ?>
        </div>

    </div>

<?php if(Auth::user()->TwoFa()->exists()): ?>
<!-- Disable 2FA modal -->
<div id="disableTwoFA" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-[calc(100%-1rem)] max-h-full">
    <div class="relative w-full max-w-2xl max-h-full">
        <!-- Modal content -->
        <form action="<?php echo e(route('2fa.disable')); ?>" method="POST">
            <?php echo csrf_field(); ?>
        <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
            <!-- Modal header -->
            <div class="flex items-start justify-between p-4 border-b rounded-t dark:border-gray-600">
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                    <?php echo __('client.two_factor_authentication'); ?>

                </h3>
                <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ml-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="disableTwoFA">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                    </svg>
                    <span class="sr-only"><?php echo e(__('client.disable')); ?></span>
                </button>
            </div>
            <!-- Modal body -->
            <div class="p-6 space-y-6">
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    <?php echo __('client.two_factor_authentication_desc'); ?>

                </p>
                <div>
                    <label for="opt"
                        class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300"><?php echo __('auth.2fa_code'); ?></label>
                    <input type="text" name="OPT" id="opt"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white"
                        placeholder="XXXXXX" required="">
                </div>
                <div class="flex justify-between items-start">
                    <div class="flex items-center justify-end">
                        <a href="<?php echo e(route('2fa.recover')); ?>"
                           class="text-sm font-medium text-primary-600 hover:underline dark:text-primary-500">

                             <?php echo __('auth.lost_access_to_device'); ?>

                        </a>
                    </div>
                </div>
            </div>
            <!-- Modal footer -->
            <div class="flex items-center justify-end p-6 space-x-2 border-t border-gray-200 rounded-b dark:border-gray-600">
                <button type="submit" class="text-white bg-red-700 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-red-600 dark:hover:bg-red-700 dark:focus:ring-red-800"><?php echo __('client.disable'); ?></button>
            </div>
        </div>
        </form>
    </div>
</div>
<!-- Disable 2FA modal -->
<?php endif; ?>

<!-- Download User Data modal -->
<div id="downloadUserData" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-[calc(100%-1rem)] max-h-full">
    <div class="relative w-full max-w-2xl max-h-full">
        <!-- Modal content -->
        <form action="<?php echo e(route('user.download-data')); ?>" method="POST">
            <?php echo csrf_field(); ?>
        <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
            <!-- Modal header -->
            <div class="flex items-start justify-between p-4 border-b rounded-t dark:border-gray-600">
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                        <?php echo __('client.download_my_data'); ?>

                </h3>
                <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ml-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="downloadUserData">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                    </svg>
                    <span class="sr-only"><?php echo e(__('client.close_menu')); ?></span>
                </button>
            </div>
            <!-- Modal body -->
            <div class="p-6 space-y-6">
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    <?php echo __('client.download_data_description'); ?>

                </p>
                <div class="">
                    <label for="confirm-password"
                           class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                        <?php echo __('auth.confirm_password'); ?>

                    </label>
                    <input type="password" name="current_password" id="confirm-password"
                           class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                           placeholder="••••••••" required>
                </div>
                <?php if(auth()->user()->TwoFa()->exists()): ?>
                <div>
                    <label for="opt"
                        class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300"><?php echo __('auth.2fa_code'); ?></label>
                    <input type="text" name="OPT" id="opt"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white"
                        placeholder="XXXXXX" required="">
                </div>
                <div class="flex justify-between items-start">
                    <div class="flex items-center justify-end">
                        <a href="<?php echo e(route('2fa.recover')); ?>"
                           class="text-sm font-medium text-primary-600 hover:underline dark:text-primary-500">

                             <?php echo __('auth.lost_access_to_device'); ?>

                        </a>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            <!-- Modal footer -->
            <div class="flex items-center justify-end p-6 space-x-2 border-t border-gray-200 rounded-b dark:border-gray-600">
                <button data-modal-hide="downloadUserData" type="submit" class="text-white bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800"><?php echo __('client.download'); ?></button>
            </div>
        </div>
        </form>
    </div>
</div>
<!-- Download User Data modal -->

<!-- User Deletion modal -->
<div id="deleteAccountModal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-[calc(100%-1rem)] max-h-full">
    <div class="relative w-full max-w-2xl max-h-full">
        <!-- Modal content -->
        <form action="<?php echo e(route('user.request-removal')); ?>" method="POST">
            <?php echo csrf_field(); ?>
        <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
            <!-- Modal header -->
            <div class="flex items-start justify-between p-4 border-b rounded-t dark:border-gray-600">
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                    <?php echo __('client.delete_my_account'); ?>

                </h3>
                <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ml-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="deleteAccountModal">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                    </svg>
                    <span class="sr-only"><?php echo e(__('client.close_menu')); ?></span>
                </button>
            </div>
            <!-- Modal body -->
            <div class="p-6 space-y-6">
                <p class="text-base leading-relaxed text-gray-500 dark:text-gray-400">
                    <?php echo __('client.delete_account_description'); ?>

                </p>
                <div class="">
                    <label for="confirm-password"
                           class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                        <?php echo __('auth.confirm_password'); ?>

                    </label>
                    <input type="password" name="current_password" id="confirm-password"
                           class="shadow-sm bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                           placeholder="••••••••" required>
                </div>
                <?php if(auth()->user()->TwoFa()->exists()): ?>
                <div>
                    <label for="opt"
                        class="block mb-2 text-sm font-medium text-gray-900 dark:text-gray-300"><?php echo __('auth.2fa_code'); ?></label>
                    <input type="text" name="OPT" id="opt"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white"
                        placeholder="XXXXXX" required="">
                </div>
                <div class="flex justify-between items-start">
                    <div class="flex items-center justify-end">
                        <a href="<?php echo e(route('2fa.recover')); ?>"
                           class="text-sm font-medium text-primary-600 hover:underline dark:text-primary-500">

                             <?php echo __('auth.lost_access_to_device'); ?>

                        </a>
                    </div>
                </div>
                <?php endif; ?>
                <div class="flex">
                    <div class="flex items-center h-5">
                        <input id="helper-checkbox" aria-describedby="helper-checkbox-text" name="disclosure" type="checkbox" value="1" required class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                    </div>
                    <div class="ml-2 text-sm">
                        <label for="helper-checkbox" class="font-medium text-gray-900 dark:text-gray-300"></label>
                        <p id="helper-checkbox-text" class="text-xs font-normal text-gray-500 dark:text-gray-300"><?php echo __('client.delete_account_disclosure'); ?></p>
                    </div>
                </div>
            </div>
            <!-- Modal footer -->
            <div class="flex items-center justify-end p-6 space-x-2 border-t border-gray-200 rounded-b dark:border-gray-600">
                <button data-modal-hide="deleteAccountModal" type="button" class="text-white bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800"><?php echo __('client.cancel'); ?></button>
                <button type="submit" class="text-red-700 hover:text-white border border-red-700 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:border-red-500 dark:text-red-500 dark:hover:text-white dark:hover:bg-red-600 dark:focus:ring-red-900"><?php echo __('client.delete_account'); ?></button>
            </div>
        </div>
        </form>
    </div>
</div>
<!-- User Deletion modal -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make(Theme::wrapper(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/client/tailwind/user/settings.blade.php ENDPATH**/ ?>