<?php $__env->startSection('css_libraries'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">

                <div class="card-header d-flex justify-content-between align-items-center">
                    <?php echo __('admin.variables'); ?>

                    <a href="<?php echo e(route('pterodactyl.clear_cache')); ?>" class="btn btn-info"
                       onclick="return confirm('<?php echo __('admin.clear_cache_desc'); ?>')">
                        <?php echo __('admin.clear_cache'); ?>

                    </a>
                </div>


                <div class="card-body">
                    <a class="btn btn-link" href="<?php echo e(route('pterodactyl.clear_cache')); ?>"
                       onclick="return confirm('<?php echo __('admin.clear_cache_desc'); ?>')"><?php echo __('admin.pterodactyl_cache_btn_desc'); ?> <?php echo __('admin.clear_cache'); ?></a><br>

                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#placeholdersInfo" aria-expanded="false" aria-controls="placeholdersInfo">
                        <span><?php echo __('admin.available_placeholders'); ?>  <strong>AUTO_PORT, USERNAME, PASSWORD, RANDOM_TEXT, RANDOM_NUMBER, NODE_IP</strong></span>
                    </button>
                    <div class="collapse m-3" id="placeholdersInfo">
                        <p>Placeholders work for any variable</p>
                        <p><strong>AUTO_PORT</strong> - Generates a port and adds additional allocation for the server</p>
                        <p><strong>USERNAME</strong> - Assigns the username to the variable</p>
                        <p><strong>PASSWORD</strong> - Generates a password using the username and special characters</p>
                        <p><strong>RANDOM_TEXT</strong> - Generates a random text of 10 characters</p>
                        <p><strong>RANDOM_NUMBER</strong> - Generates a 10-digit random number</p>
                        <p><strong>NODE_IP</strong> - Sets the IP address of the node being used</p>
                    </div>
                    <hr>
                    <form action="<?php echo e(route('pterodactyl.egg_manage_store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="egg_id" value="<?php echo e($egg->egg_id); ?>">
                    <table id="variablesTable" class="table">
                        <thead>
                        <tr>
                            <th><?php echo __('admin.variable'); ?></th>
                            <th><?php echo __('admin.key'); ?></th>
                            <th><?php echo __('admin.value'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $egg->variables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $var): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <input type="hidden" name="var_id" value="<?php echo e($var['id']); ?>">
                                <td><?php echo e($var['name']); ?></td>
                                <td><?php echo e($var['env_variable']); ?></td>
                                <td><input class="form-control" name="<?php echo e($var['env_variable']); ?>" value="<?php echo e($var['default_value']); ?>"></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                        <div class="text-right mr-4"><button type="submit" class="btn btn-primary"><?php echo e(__('admin.submit')); ?></button></div>

                    </form>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.eggs'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/app/Services/Pterodactyl/Resources/views/admin/default/eggs_manage.blade.php ENDPATH**/ ?>