<?php $__env->startSection('title', __('client.pricing_for_service', ['service' => $category->name])); ?>

<?php $__env->startSection('container'); ?>

    <section class="bg-white dark:bg-gray-900">
        <div class="py-8 px-4 mx-auto max-w-screen-xl lg:px-6">
            <div class="mx-auto max-w-screen-md text-center mb-8 lg:mb-12">
                <h2 class="mb-4 text-4xl tracking-tight font-extrabold text-gray-900 dark:text-white"><?php echo __('client.pricing_for_service', ['service' => $category->name]); ?></h2>
            </div>
            <div class="space-y-8 lg:grid lg:grid-cols-3 sm:gap-6 xl:gap-10 lg:space-y-0">

                <?php $__currentLoopData = $category->packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <?php if($package->status == 'unlisted' OR $package->status == 'inactive' OR $package->status == 'restricted'): ?>
                        <?php if($package->status == 'restricted'): ?>
                            <?php if(Auth::guest() OR !Auth::user()->is_admin()): ?>
                                <?php continue; ?>
                            <?php endif; ?>
                        <?php else: ?>
                            <?php continue; ?>
                        <?php endif; ?>
                    <?php endif; ?>

                    <div
                        class="flex flex-col p-6 mx-auto max-w-lg text-center text-gray-900 bg-white rounded-lg border border-gray-100 shadow dark:border-gray-600 xl:p-8 dark:bg-gray-800 dark:text-white">
                        <h3 class="mb-4 text-2xl font-semibold"><?php echo e($package->name); ?></h3>
                        <div class="overflow-hidden flex items-center justify-center mb-5 rounded-lg">
                            <img class="w-full h-auto" src="<?php echo e(asset('storage/products/' . $package->icon)); ?>"
                                 alt="icon"/>
                        </div>

                        <p class="font-light text-gray-500 sm:text-lg dark:text-gray-400">
                            <?php echo __('client.price_block_desc', [
                                                'period' =>
                                            (mb_strtolower($package->prices->first()->period()) == 'monat' ? 'Erster ' :
                                            (mb_strtolower($package->prices->first()->period()) == 'quartal' ? 'Erstes ' : ''))
                                            . ucfirst(mb_strtolower($package->prices->first()->period())),
                                            'total_price' => $package->prices->first()->totalPrice(),
                                            'renewal_price' => $package->prices->first()->renewal_price,
                                            'per_period' => mb_strtolower($package->prices->first()->periodToHuman()),
                                            'symbol' => currency('symbol')]); ?>

                        </p>
                        <div class="flex justify-center items-baseline my-8">
                            <span
                                class="mr-2 text-5xl font-extrabold"><?php echo e(currency('symbol')); ?><?php echo e($package->prices->first()->renewal_price); ?></span>
                            <span
                                class="text-gray-500 dark:text-gray-400">/<?php echo e($package->prices->first()->periodToHuman()); ?></span>
                        </div>
                        <!-- List -->
                        <ul role="list" class="mb-8 space-y-4 text-left">


                            <?php $__currentLoopData = $package->features()->orderBy('order', 'desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="flex items-center space-x-3">
                                    <!-- Icon -->
                                    <span class="text-<?php echo e($feature->color); ?>-500 dark:text-<?php echo e($feature->color); ?>-500 bx-sm">
                                        <?php echo $feature->icon; ?>

                                    </span>
                                    <span><?php echo __($feature->description); ?></span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </ul>
                        <a href="<?php echo e(route('store.package', ['package' => $package->id])); ?>"
                           class="text-white bg-primary-600 hover:bg-primary-700 focus:ring-4 focus:ring-primary-200 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:text-white  dark:focus:ring-primary-900">
                            <?php echo __('client.get_started'); ?>

                        </a>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make(Theme::wrapper(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/client/tailwind/store/store.blade.php ENDPATH**/ ?>