<?php $__env->startSection('css_libraries'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4><?php echo __('admin.emails'); ?></h4>
                    <div class="card-header-action">
                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#emailModal" class="btn btn-icon icon-left btn-primary"><i class="fas fa-solid fa-plus"></i>
                            <?php echo __('admin.create'); ?>

                        </button>
                    </div>
                </div>
                <form action="#" method="POST">
                    <div class="card-header">
                        <h4><?php echo __('admin.email_history', ['default' => 'Email History']); ?></h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <tbody>
                                <tr>
                                    <th><?php echo __('admin.client', ['default' => 'Client']); ?></th>
                                    <th><?php echo __('admin.subject', ['default' => 'Subject']); ?></th>
                                    <th><?php echo __('admin.status', ['default' => 'Status']); ?></th>
                                    <th><?php echo __('admin.created', ['default' => 'Created at']); ?></th>
                                    <th class="text-right"><?php echo __('admin.actions', ['default' => 'Action']); ?></th>
                                </tr>
                                <?php $__currentLoopData = EmailHistory::latest()->paginate(15); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $email): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <?php if($email->user): ?>
                                            <a style="display: flex; color: #6c757d"
                                               href="<?php echo e(route('users.edit', ['user' => $email->user->id ])); ?>">
                                                <img alt="image" src="<?php echo e($email->user->avatar()); ?>"
                                                     class="rounded-circle mr-2"
                                                     width="35" height="35" data-toggle="tooltip" title=""
                                                     data-original-title="<?php echo e($email->user->first_name); ?> <?php echo e($email->user->last_name); ?>">
                                                <div class="flex">
                                                    <?php echo e($email->user->username); ?> <br>
                                                    <small><?php echo e($email->user->email); ?></small>
                                                </div>
                                            </a>
                                            <?php else: ?> 
                                            <?php echo e($email->receiver); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo e($email->subject); ?>

                                        </td>
                                        <td>
                                            <div
                                                class="badge <?php if($email->is_sent): ?> badge-success <?php else: ?> badge-warning <?php endif; ?>">
                                                <?php if($email->is_sent): ?>
                                                    <?php echo __('admin.send', ['default' => 'send']); ?>

                                                <?php else: ?>
                                                    <?php echo __('admin.pending', ['default' => 'pending']); ?>

                                                <?php endif; ?>
                                            </div>
                                        </td>
                                        <td><?php echo e($email->created_at->diffForHumans()); ?></td>
                                        <td  class="text-right">
                                            <a href="<?php echo e(route('emails.resend', ['email' => $email->id])); ?>"
                                               class="btn btn-icon icon-left btn-success"><i class="fas fa-check"></i>
                                                <?php echo __('admin.resend', ['default' => 'Resend']); ?>

                                            </a>
                                            <button type="button" data-toggle="modal"
                                                    data-target="#previewEmail-<?php echo e($email->id); ?>"
                                                    class="btn btn-icon icon-left btn-dark">
                                                <i class="fas fa-solid fa-magnifying-glass"></i>
                                                <?php echo __('admin.preview', ['default' => 'Preview']); ?>

                                            </button>

                                            <!-- Modal <?php echo e($email->id); ?>-->
                                            <div class="modal fade" id="previewEmail-<?php echo e($email->id); ?>" tabindex="-1"
                                                 role="dialog" aria-labelledby="previewEmail-<?php echo e($email->id); ?>Label"
                                                 aria-hidden="true">
                                                <div class="modal-dialog modal-lg" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title"
                                                                id="previewEmail-<?php echo e($email->id); ?>Label">
                                                                <?php echo __('admin.preview_email', ['default' => 'Previewing Email']); ?>

                                                            </h5>
                                                            <button type="button" class="close" data-dismiss="modal"
                                                                    aria-label="<?php echo e(__('client.close')); ?>">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <?php echo $__env->make(EmailTemplate::view(), [
                                                                'name' => $email->user->username ?? '👋',
                                                                'subject' => $email->subject,
                                                                'intro' => $email->content,
                                                                'button' =>  $email->button,
                                                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary"
                                                                    data-dismiss="modal">
                                                                <?php echo __('admin.close', ['default' => 'Close']); ?>

                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer text-right">
                        <?php echo e(EmailHistory::latest()->paginate(15)->links(AdminTheme::pagination())); ?>

                    </div>
                </form>
            </div>
        </div>
    </div>
    <style>
        span.select2.select2-container.select2-container--default {
            width: 100% !important;
        }
        body {
            background-color: var(--primary-bg) !important;
        }
    </style>

<!-- Modal -->
<div class="modal fade" id="emailModal" tabindex="-1" role="dialog" aria-labelledby="emailModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="emailModalLabel"><?php echo e(__('admin.email')); ?></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('admin.close')); ?>">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?php echo e(route('emails.send')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-body">

                <div class="mb-4">
                    <label for="email"><?php echo e(__('admin.email')); ?></label>
                    <input type="email" name="email" id="email" placeholder="<?php echo e(__('admin.email')); ?>"
                           class="form-control" required=""/>
                </div>

                <div class="mb-4">
                    <label for="subject"><?php echo e(__('admin.subject')); ?></label>
                    <input type="text" name="subject" id="subject" placeholder="<?php echo e(__('admin.subject')); ?>"
                           class="form-control" required=""/>
                </div>

                <div class="mb-4">
                    <label for="body"><?php echo e(__('admin.email_body')); ?></label>
                    <textarea class="form-control" name="body" id="body"></textarea>
                    <small class="form-text text-muted"></small>
                </div>

            </div>
            <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('admin.close')); ?></button>
            <button type="submit" class="btn btn-primary"><?php echo e(__('admin.send')); ?></button>
            </div>
        </form>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.email', ['default' => 'Emails']), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/emails/history.blade.php ENDPATH**/ ?>