<?php $__env->startSection('css_libraries'); ?>
    <link rel="stylesheet" href="<?php echo e(Theme::get('Default')->assets); ?>assets/modules/summernote/summernote-bs4.css">
    <link rel="stylesheet" href="<?php echo e(Theme::get('Default')->assets); ?>assets/modules/codemirror/lib/codemirror.css">
    <link rel="stylesheet" href="<?php echo e(Theme::get('Default')->assets); ?>assets/modules/codemirror/theme/duotone-dark.css">
    <link rel="stylesheet" href="<?php echo e(Theme::get('Default')->assets); ?>assets/modules/jquery-selectric/selectric.css">
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(Theme::get('Default')->assets); ?>assets/modules/codemirror/lib/codemirror.js"></script>
    <script src="<?php echo e(Theme::get('Default')->assets); ?>assets/modules/codemirror/mode/javascript/javascript.js"></script>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <section class="section">
        <div class="section-body">
            <div class="col-12">

            </div>
        </div>
        <div class="row mt-sm-4">
            <div class="col-12 col-md-12 col-lg-12">

            <form method="post" action="<?php echo e(route('orders.store')); ?>" class="needs-validation" novalidate="">
                <?php echo csrf_field(); ?>
                <div class="card">
                        <div class="card-header">
                            <h4><?php echo __('admin.create', ['default' => 'Create']); ?></h4>
                        </div>
                        <div class="card-body">
                            <div class="row">

                                <div class="form-group col-md-12 col-12">
                                    <label
                                        for="package_id"><?php echo __('admin.package', ['default' => 'Package']); ?></label>
                                    <select class="form-control select2 select2-hidden-accessible"
                                        onchange="setPackage(this.value)" 
                                        name="package_id" id="package_id"
                                            tabindex="-1" aria-hidden="true">
                                        <?php $__currentLoopData = Package::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $packageList): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($packageList->status == 'inactive'): ?>
                                                <?php continue; ?>;
                                            <?php endif; ?>
                                            <option value="<?php echo e($packageList->id); ?>" <?php if(isset($package) AND $package->id == $packageList->id): ?> selected <?php endif; ?>><?php echo e($packageList->name); ?>

                                                (<?php echo e($packageList->service); ?>)
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <?php if(isset($package)): ?>
                                <div class="form-group col-md-12 col-12">
                                    <label for="price"><?php echo __('admin.price', ['default' => 'Price']); ?></label>
                                    <select class="form-control select2 select2-hidden-accessible" name="price"
                                            id="price" tabindex="-1" aria-hidden="true">
                                            <?php $__currentLoopData = $package->prices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(!$price->is_active): ?>
                                                    <?php continue; ?>;
                                                <?php endif; ?>
                                                <option value="<?php echo e($price->id); ?>"><?php echo e(currency('symbol') . number_format($price->renewal_price, 2)); ?> @ <?php echo e($price->periodToHuman()); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <?php endif; ?>

                                <div class="form-group col-md-12 col-12">
                                    <label for="user"><?php echo __('admin.user', ['default' => 'User']); ?></label>
                                    <select class="form-control select2 select2-hidden-accessible" name="user_id"
                                            tabindex="-1" aria-hidden="true">
                                        <?php $__currentLoopData = User::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($user->id); ?>"><?php echo e($user->username); ?> (<?php echo e($user->email); ?>)
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group col-md-12 col-12">
                                    <label for="price"><?php echo __('admin.status', ['default' => 'Status']); ?></label>
                                    <select class="form-control select2 select2-hidden-accessible" name="status"
                                            tabindex="-1" aria-hidden="true">
                                        <option value="active"
                                                selected><?php echo __('admin.active', ['default' => 'Active']); ?></option>
                                        <option
                                            value="suspended"><?php echo __('admin.suspended', ['default' => 'Suspended']); ?></option>
                                        <option
                                            value="terminated"><?php echo __('admin.terminated', ['default' => 'Terminated']); ?></option>
                                    </select>
                                </div>

                                <?php if(isset($package) AND $package->require_domain): ?>
                                <div class="form-group col-md-12 col-12">
                                    <label for="status">
                                        <?php echo __('admin.domain', ['default' => 'Domain']); ?>

                                    </label>
                                    <input type="text" class="form-control" name="domain" value="" required
                                           placeholder="example.com"/>
                                    <small class="form-text text-muted"></small>
                                </div>
                                <?php endif; ?>

                                <div class="form-group col-md-6 col-12">
                                    <label
                                        for="status"><?php echo __('admin.last_renewed_at', ['default' => 'Last Renewed At']); ?></label>
                                    <input type="date" class="form-control" name="last_renewed_at"
                                           value="<?php echo e(Carbon::now()->translatedFormat('Y-m-d')); ?>" placeholder=""/>
                                    <small class="form-text text-muted"></small>
                                </div>

                                <div class="form-group col-md-6 col-12">
                                    <label for="status"><?php echo __('admin.due_date', ['default' => 'Due Date']); ?></label>
                                    <input type="date" class="form-control" name="due_date" value="" placeholder=""/>
                                    <small class="form-text text-muted"></small>
                                </div>

                                <div class="form-group col-md-12 col-12">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" name="create_instance" value="1"
                                               class="custom-control-input" id="customCheck1" checked>
                                        <label class="custom-control-label" for="customCheck1">
                                            <?php echo __('admin.create_instance_package_service', ['default' => 'Create an instance of package service']); ?>

                                        </label>
                                    </div>
                                    <small>
                                        <?php echo __('admin.create_instance_package_service_desc', ['default' =>
                                        'If this option is enabled, when the order is created it will also create an
                                        instance of the Package Service. For Example, if the package service
                                        is pterodactyl, when the order is created it will create a brand new pterodactyl
                                        server with it.'
                                        ]); ?>


                                    </small>
                                </div>

                                <div class="form-group col-md-12 col-12">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" name="notify_user" value="1" class="custom-control-input"
                                               id="notify_user" checked>
                                        <label class="custom-control-label" for="notify_user">
                                            <?php echo __('admin.send_user_email', ['default' => 'Send user email']); ?>

                                        </label>
                                    </div>
                                    <small>
                                        <?php echo __('admin.send_user_email_desc', ['default' =>
                                        'Check this option if you want to notify the user via email that a new order has
                                        been created for them.'
                                        ]); ?>


                                    </small>
                                </div>

                            </div>
                        </div>
                </div>

                <?php if(isset($package) AND $package->service()->hasCheckoutConfig($package)): ?>
                <div class="card">
                    <div class="card-body">
                        <?php $__currentLoopData = $package->service()->getCheckoutConfig($package)->all() ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="form-group <?php if(isset($field['col'])): ?> <?php echo e($field['col']); ?> <?php else: ?> col-6 <?php endif; ?>" style="display: flex;flex-direction: column;">
                            <label><?php echo $field['name']; ?></label>
                            <?php if($field['type'] == 'select'): ?>
                            <select class="form-control select2 select2-hidden-accessible" tabindex="-1" aria-hidden="true"
                            name="<?php echo e($field['key']); ?>"
                            id="<?php echo e($field['key']); ?>"
                            <?php if(isset($field['save_on_change']) AND $field['save_on_change']): ?> onchange="saveServiceSettings()" <?php endif; ?>
                            <?php if(isset($field['multiple']) AND $field['multiple']): ?> multiple <?php endif; ?>
                            >
                                <?php $__currentLoopData = $field['options'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>"
                                <?php if(in_array($key, (array) $package->data(Str::remove("[]", $field['key']), $field['default_value'] ?? ''))): ?> selected <?php endif; ?>
                                ><?php echo e($option); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php elseif($field['type'] == 'bool'): ?>
                            <label class="custom-switch mt-2">
                                <input type="hidden" name="<?php echo e($field['key']); ?>" value="0">
                                <input type="checkbox" name="<?php echo e($field['key']); ?>" <?php if(isset($field['save_on_change']) AND $field['save_on_change']): ?> onchange="saveServiceSettings()" <?php endif; ?> value="1" class="custom-switch-input" <?php if($package->data($field['key'], $field['default_value'] ?? '')): ?> checked <?php endif; ?>>
                                <span class="custom-switch-indicator"></span>
                              </label>
                            <?php else: ?>
                            <input class="form-control"
                            type="<?php echo e($field['type']); ?>"
                            name="<?php echo e($field['key']); ?>"
                            id="<?php echo e($field['key']); ?>"
                            <?php if(isset($field['min'])): ?> min="<?php echo e($field['min']); ?>" <?php endif; ?>
                            <?php if(isset($field['max'])): ?> max="<?php echo e($field['max']); ?>" <?php endif; ?>
                            <?php if(isset($field['save_on_change']) AND $field['save_on_change']): ?> onchange="saveServiceSettings()" <?php endif; ?>
                            value="<?php echo e($package->data($field['key'], $field['default_value'] ?? '')); ?>"
                            placeholder="<?php if(isset($field['placeholder'])): ?><?php echo e($field['placeholder']); ?> <?php else: ?><?php echo e($field['name']); ?> <?php endif; ?>"
                            <?php if(in_array('required', $field['rules'])): ?> required="" <?php endif; ?>>
                            <?php endif; ?>
                            <small class="form-text text-muted">
                                <?php echo $field['description']; ?>

                            </small>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-footer text-right">
                        <button class="btn btn-success" type="submit"><?php echo __('admin.create', ['default' => 'Create']); ?></button>
                    </div>
                </div>
            </form>

            </div>
        </div>
        </div>
    </section>

    <script>
        function setPackage(id) {
            // redirect the user to the same page with package=ID in the request
            return location.href = '/admin/orders/create?package=' + id;
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.orders', ['default' => 'Orders']), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/orders/create.blade.php ENDPATH**/ ?>