<?php $__env->startSection('container'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header"><?php echo __('admin.gateways'); ?></div>

                <div class="card-body">
                    <a href="<?php echo e(route('gateways.create')); ?>" class="btn btn-primary"><?php echo __('admin.create_gateway'); ?></a>
                    <hr>
                    <?php if($gateways->count() == 0): ?>
                    <?php echo $__env->make(AdminTheme::path('empty-state'), ['title' => 'No records found', 'description' => 'You haven\'t setup any gateways yet'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                    <table class="table">
                        <thead>
                            <tr>
                                <th><?php echo __('admin.name'); ?></th>
                                <th><?php echo __('admin.type'); ?></th>
                                <th><?php echo __('admin.driver'); ?></th>
                                <th><?php echo __('admin.status'); ?></th>
                                <th><?php echo __('admin.refund_support_title', ['default' => 'Refund Support']); ?></th>
                                <th class="text-right"><?php echo __('admin.actions'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e(Str::replace('_', ' ', $gateway->name)); ?></td>
                                    <td><?php echo e($gateway->type); ?></td>
                                    <td><?php echo e($gateway->driver); ?></td>
                                    <td><?php echo e($gateway->status ? __('admin.enabled') : __('admin.disabled')); ?></td>
                                    <td><?php echo e($gateway->refund_support ? __('admin.yes') : __('admin.no')); ?></td>
                                    <td class="text-right">
                                        <?php ($btn = $gateway->status ? 'warning' : 'primary'); ?>
                                        <?php ($default = $gateway->default ? 'primary' : 'warning'); ?>
                                        <?php if($gateway->config()): ?>
                                            <a href="<?php echo e(route('gateways.edit', $gateway->id)); ?>" class="btn btn-primary btn-sm"><?php echo __('admin.edit'); ?></a>
                                        <?php endif; ?>

                                        <a href="<?php echo e(route('gateways.default', $gateway->id)); ?>"
                                           class="btn btn-<?php echo e($default); ?> btn-sm"><?php echo e(__('admin.default')); ?></a>


                                        <a href="<?php echo e(route('gateways.toggle', $gateway->id)); ?>"
                                            class="btn btn-<?php echo e($btn); ?> btn-sm"><?php echo e($gateway->status ? __('admin.disable') : __('admin.enable')); ?></a>
                                        <form action="<?php echo e(route('gateways.destroy', $gateway->id)); ?>" method="POST"
                                            class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger btn-sm"
                                                onclick="return confirm('<?php echo __('admin.you_sure'); ?>')"><?php echo __('admin.delete'); ?></button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center"><?php echo __('admin.no_gateways'); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.gateways'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/gateways/index.blade.php ENDPATH**/ ?>