<?php $__env->startSection('css_libraries'); ?>
<link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>" />
<link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
<script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
<script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <form action="<?php echo e(route('admin.settings.store')); ?>" method="POST">
            <div class="card-header">
              <h4>Search Engine Optimization</h4>
            </div>
            <div class="card-body">
                <?php echo csrf_field(); ?>
              <div class="row">
                <div class="form-group col-12">
                    <label>Title</label>
                    <input type="text" name="seo::title" value="<?php echo App\Models\Settings::get('seo::title', settings('app_name'), ); ?>" class="form-control">
                </div>
                <div class="form-group col-12">
                    <label for="seo::description"><?php echo __('admin.description'); ?></label>
                    <textarea class="form-control" name="seo::description" id="seo::description" placeholder="Write a short description about your application"><?php echo App\Models\Settings::get('seo::description', ); ?></textarea>
                </div>
                <div class="form-group col-12">
                    <label for="seo::keywords"><?php echo __('admin.keywords'); ?></label>
                    <textarea class="form-control" name="seo::keywords" id="seo::keywords" placeholder="keywords1, keywords2, keywords3"><?php echo App\Models\Settings::get('seo::keywords', ); ?></textarea>
                    <small class="form-text text-muted">
                        Help search engines by providing list of keywords, separate each keyword with a comma (",")
                    </small>
                </div>
                <div class="form-group col-12">
                    <label>Robots</label>
                    <input type="text" name="seo::robots" value="<?php echo App\Models\Settings::get('seo::robots', 'index, follow', ); ?>" class="form-control">
                    <small class="form-text text-muted">
                        This is a more advanced setting, leave this as default to "index, follow" if you are not sure
                    </small>
                </div>
                <div class="form-group col-12">
                    <label>Color</label>
                    <input type="color" name="seo::color" value="<?php echo App\Models\Settings::get('seo::color', '#4f46e5', ); ?>" class="form-control">
                    <small class="form-text text-muted">
                        Default color of the application
                    </small>
                </div>
                <div class="form-group col-12">
                    <label>Logo / Image</label>
                    <input type="text" name="seo::image" value="<?php echo App\Models\Settings::get('seo::image', settings('logo', 'https://imgur.com/oJDxg2r.png'), ); ?>" class="form-control">
                    <div class="gallery gallary mt-3">
                        <div class="gallery-item" data-image="<?php echo App\Models\Settings::get('seo::image', settings('logo', 'https://imgur.com/oJDxg2r.png'), ); ?>" data-title="Image 1" href="<?php echo App\Models\Settings::get('seo::image', settings('logo', 'https://imgur.com/oJDxg2r.png'), ); ?>" title="Image 1" style="background-image: url('<?php echo App\Models\Settings::get('seo::image', settings('logo', 'https://imgur.com/oJDxg2r.png'), ); ?>')');"></div>
                      </div>
                </div>
              </div>
            </div>
            <div class="card-footer text-right">
              <button type="submit" class="btn btn-primary"><?php echo __('admin.submit'); ?></button>
            </div>
          </div>
        </form>
    </div>
</div>
<style>
    span.select2.select2-container.select2-container--default {
        width: 100% !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.settings'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/settings/seo.blade.php ENDPATH**/ ?>