<?php $__env->startSection('css_libraries'); ?>
<link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>" />
<link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
<script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
<script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <form action="<?php echo e(route('admin.settings.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="card-header">
                  <h4><?php echo __('admin.email_templates', ['default' => 'Email Templates']); ?></h4>
                </div>
                <div class="card-body">
                  <div class="row">

                    <div class="form-group col-12">
                        
                        <div class="row gutters-sm">

                        <?php $__currentLoopData = EmailTemplate::list(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <div class="col-6 col-sm-3">
                            <label class="imagecheck mb-4">
                              <h6 class="text-dark"><?php echo e($template->name); ?> <?php echo __('admin.developed_by', ['default' => 'developed by']); ?>

                                  <?php echo e($template->author); ?> (v<?php echo e($template->version); ?>)</h6>

                              <input name="email::template" type="radio" value="<?php echo e($template->name); ?>"
                                     class="imagecheck-input" <?php if(EmailTemplate::active()->name == $template->name): ?> checked="" <?php endif; ?>>
                              <figure class="imagecheck-figure">
                                <img src="<?php echo e($template->image); ?>" alt="" class="imagecheck-image">
                              </figure>
                            </label>
                          </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                      </div>
                  </div>
                </div>
                <div class="card-footer text-right">
                  <button type="submit" class="btn btn-primary"><?php echo __('admin.submit', ['default' => 'Submit']); ?></button>
                </div>
              </div>
            </form>
        </div>
</div>

<style>
    span.select2.select2-container.select2-container--default {
        width: 100% !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.email', ['default' => 'Emails']), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/emails/templates.blade.php ENDPATH**/ ?>