<?php $__env->startSection('title', $package->name); ?>

<?php $__env->startSection('container'); ?>

    <?php if(Cookie::get('affiliate')): ?>
        <div
            class="flex items-center p-4 mb-4 text-sm text-blue-800 border border-blue-300 rounded-lg bg-blue-50 dark:bg-gray-800 dark:text-blue-400 dark:border-blue-800"
            role="alert">
            <svg class="flex-shrink-0 inline w-4 h-4 mr-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                 fill="currentColor" viewBox="0 0 20 20">
                <path
                    d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
            </svg>
            <span class="sr-only"><?php echo e(__('client.info')); ?></span>
            <div>
                <?php echo __('client.affiliate_discount_info', ['percent' => Affiliate::calculateDiscountPercentage(Cookie::get('affiliate'))]); ?>

            </div>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('payment.package', ['package' => $package->id])); ?>" method="POST" id="price">
        <?php echo csrf_field(); ?>
        <div class="flex flex-wrap ">
            <div class="lg:w-2/3 pr-4 pl-4 md:w-2/3 pr-4 pl-4 sm:w-1/2 pr-4 pl-4 w-full">
                <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
                    <!-- Modal header -->
                    <div class="flex justify-between mb-4 rounded-t sm:mb-4">
                        <div class="text-lg text-gray-900 md:text-xl dark:text-white">
                            <h3 class="font-semibold">
                                <?php echo e($package->category->name); ?> <?php echo e($package->name); ?>

                            </h3>
                            <p class="text-gray-500 dark:text-gray-400 text-small text-base">
                                <?php echo $package->description; ?>

                            </p>
                        </div>
                        <div class="text-lg text-gray-900 md:text-xl dark:text-white flex justify-end items-center">
                            <img class="w-20 h-auto" src="<?php echo e(asset('storage/products/' . $package->icon)); ?>" alt="">
                        </div>
                    </div>


                    <!-- List -->
                    <ul role="list" class="mb-8 space-y-4 text-left">
                        <div class="grid grid-cols-2 gap-4">
                            <?php $__currentLoopData = $package->features()->orderBy('order', 'desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="flex items-center space-x-3">
                                    <!-- Icon -->
                                    <span class="text-<?php echo e($feature->color); ?>-500 dark:text-<?php echo e($feature->color); ?>-500 bx-sm">
                                        <?php echo $feature->icon; ?>

                                    </span>
                                    <span class="text-gray-500 dark:text-gray-400"><?php echo __($feature->description); ?></span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </ul>

                    <div class="flex justify-between items-center">
                        <div class="flex items-center space-x-3 sm:space-x-4">
                        </div>

                    </div>
                </div>

    </form>

    <ul class="grid w-full gap-6 mt-8 md:grid-cols-2 mb-5">
        <?php $__currentLoopData = $package->prices->where('is_active', true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li>
                <input type="radio" id="price-radio-<?php echo e($price->id); ?>" name="price_id"
                       value="<?php echo e($price->id); ?>" class="hidden peer" required
                       <?php if($price->id == request()->input('price', $package->prices->first()->id)): ?> checked <?php endif; ?>>
                <label for="price-radio-<?php echo e($price->id); ?>"
                       class="inline-flex items-center h-full justify-between w-full p-5 text-gray-500 bg-white border border-gray-200 rounded-lg cursor-pointer dark:hover:text-gray-300 dark:border-gray-700 dark:peer-checked:text-primary-500 peer-checked:border-primary-600 peer-checked:text-primary-600 hover:text-gray-600 hover:bg-gray-100 dark:text-gray-400 dark:bg-gray-800 dark:hover:bg-gray-700">
                    <div class="block">
                        <div
                            class="w-full text-lg font-semibold"><?php echo e(currency('symbol')); ?><?php echo e(number_format($price->renewal_price, 2)); ?>

                            /
                            <?php echo e($price->periodToHuman()); ?></div>
                        <div class="w-full"><?php echo __('client.price_block_desc', [
                            'period' =>
                            (mb_strtolower($price->period()) == 'monat' ? 'Erster ' :
                            (mb_strtolower($price->period()) == 'quartal' ? 'Erstes ' : ''))
                            . ucfirst(mb_strtolower($price->period())),
                            'total_price' => $price->totalPrice(),
                            'renewal_price' => $price->renewal_price,
                            'per_period' =>
                            
                            (mb_strtolower($price->period()) == 'monat' ? 'monatlich' : 
                            (mb_strtolower($price->period()) == 'quartal' ? 'vierteljährlich' : '')),
                            'symbol' => currency('symbol')
                            ]); ?>

                            <?php if(isset($price->data['badge'])): ?>
                                <span
                                    class="bg-primary-100 text-primary-800 text-xs font-medium px-2.5 py-0.5 rounded dark:bg-primary-900 dark:text-primary-300 inline-block"><?php echo e($price->data['badge']); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </label>
            </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>

    <?php if($package->require_domain): ?>
        <div class="relative mt-8 p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5 mb-6">
            <div class="custom-note">
                <div class="flex justify-between mb-3 rounded-t sm:mb-3">
                    <div class="text-lg text-gray-900 md:text-xl dark:text-white">
                        <h3 class="font-semibold"><?php echo __('client.enter_domain'); ?></h3>
                        <p class="text-sm text-gray-500 dark:text-gray-400">
                            <?php echo __('client.enter_domain_desc'); ?>

                        </p>
                    </div>
                </div>
                <label for="helper-text"
                       class="block mb-2 text-sm font-medium text-gray-900 dark:text-white"><?php echo __('client.domain'); ?></label>
                <input type="text" id="helper-text" name="domain" value="<?php echo e(old('domain')); ?>"
                       aria-describedby="helper-text-explanation"
                       class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                       placeholder="i.e example.com">
                <p id="helper-text-explanation" class="mt-2 text-sm text-gray-500 dark:text-gray-400">
                    <?php echo __('client.enter_domain_helper'); ?>/p>
            </div>
        </div>
    <?php endif; ?>



    <?php if($package->service()->hasCheckoutConfig($package)): ?>
        <div class="relative mt-8 p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5 mb-6">
            <div class="custom-note">
                <div class="flex justify-between mb-3 rounded-t sm:mb-3">
                    <div class="text-lg text-gray-900 md:text-xl dark:text-white">
                        <h3 class="font-semibold"><?php echo __('client.custom_options'); ?></h3>
                        <p class="text-sm text-gray-500 dark:text-gray-400">
                            <?php echo __('client.custom_options_desc'); ?>

                        </p>
                    </div>
                    <div></div>
                </div>
                <div class="flex flex-wrap">
                    <?php $__currentLoopData = $package->service()->getCheckoutConfig($package)->all() ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="<?php if(isset($field['col'])): ?> <?php echo e($field['col']); ?> <?php else: ?> w-1/2 p-2 <?php endif; ?>"
                             style="display: flex;flex-direction: column;">
                            <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                <?php echo __($field['name']); ?> <?php echo isset($field['required']) && $field['required'] ? '<span class="text-red-500">*</span>' : ''; ?>

                            </label>
                            <?php if($field['type'] == 'select'): ?>
                                <select
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                    tabindex="-1" aria-hidden="true"
                                    name="<?php echo e($field['key']); ?>"
                                    id="<?php echo e($field['key']); ?>"
                                    <?php if(isset($field['disabled']) AND $field['disabled']): ?> disabled <?php endif; ?>
                                    <?php if(isset($field['multiple']) AND $field['multiple']): ?> multiple <?php endif; ?>
                                >
                                    <?php $__currentLoopData = $field['options'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>"
                                                <?php if(in_array($key, (array) $package->data(Str::remove("[]", $field['key']), $field['default_value'] ?? ''))): ?> selected <?php endif; ?>
                                        ><?php echo e($option); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            <?php elseif($field['type'] == 'bool'): ?>
                                <label class="relative inline-flex items-center cursor-pointer mt-2">
                                    <?php if($field['required']): ?>
                                        <input type="hidden" name="<?php echo e($field['key']); ?>" value="0">
                                    <?php endif; ?>
                                    <input type="checkbox" name="<?php echo e($field['key']); ?>" value="<?php echo e($field['default_value'] ?? '0'); ?>" class="sr-only peer"
                                           <?php if($package->data($field['key'], $field['default_value'] ?? '0')): ?> checked <?php endif; ?>
                                           <?php if(isset($field['disabled']) AND $field['disabled']): ?> disabled <?php endif; ?>>
                                    <div
                                        class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600"></div>
                                    
                                </label>
                            <?php else: ?>
                                <input
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                    type="<?php echo e($field['type']); ?>"
                                    name="<?php echo e($field['key']); ?>"
                                    id="<?php echo e($field['key']); ?>"
                                    <?php if(isset($field['min'])): ?> min="<?php echo e($field['min']); ?>" <?php endif; ?>
                                    <?php if(isset($field['max'])): ?> max="<?php echo e($field['max']); ?>" <?php endif; ?>
                                    value="<?php echo e($package->data($field['key'], $field['default_value'] ?? '')); ?>"
                                    placeholder="<?php if(isset($field['placeholder'])): ?><?php echo e($field['placeholder']); ?> <?php else: ?><?php echo e($field['name']); ?> <?php endif; ?>"
                                    <?php if(in_array('required', $field['rules'])): ?> required="" <?php endif; ?>
                                    <?php if(isset($field['disabled']) AND $field['disabled']): ?> disabled <?php endif; ?>>
                            <?php endif; ?>
                            <small class="mt-2 text-sm text-gray-500 dark:text-gray-400 text-muted">
                                <?php echo __($field['description']); ?>

                            </small>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    <?php else: ?>
            <?php if ($__env->exists(Theme::serviceView($package->service, 'props.checkout-options'))) echo $__env->make(Theme::serviceView($package->service, 'props.checkout-options'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <div class="relative mt-8 p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
        <div class="flex justify-between mb-3 rounded-t sm:mb-3">
            <div class="text-lg text-gray-900 md:text-xl dark:text-white">
                <h3 class="font-semibold"><?php echo __('client.payment_method'); ?></h3>
                <p class="text-sm text-gray-500 dark:text-gray-400"><?php echo __('client.payment_method_desc'); ?></p>
            </div>
            <div></div>
        </div>

        <div class="mb-6">
            <div class="relative flex">
                <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                    <i class='bx bxs-coupon text-gray-500 dark:text-gray-400'></i>
                </div>
                <input
                    type="text"
                    id="coupon"
                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg mr-4 focus:ring-blue-500 focus:border-blue-500 block w-full pl-10 p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                    placeholder="coupon" name="coupon" value="<?php echo e(session('coupon_code')); ?>"
                />
                <button type="button" onclick="applyCoupon()"
                        class="py-2.5 px-5 mr-2 text-sm font-medium text-gray-900 focus:outline-none bg-white rounded-lg border border-gray-200 hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700"><?php echo e(__('client.apply')); ?></button>

            </div>
            <p id="coupon-description" class="mt-2 text-sm text-gray-500 dark:text-gray-400"></p>
        </div>

        <select
            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm mb-6 rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
            name="gateway" id="gateway" tabindex="-1" aria-hidden="true" required>

            <?php $__currentLoopData = App\Models\Gateways\Gateway::getActive('subscription'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option <?php if($gateway->default): ?> selected <?php endif; ?> data-gateway-type="subscription"
                        value="<?php echo e($gateway->id); ?>"><?php echo e($gateway->name); ?>

                    (<?php echo __('client.subscription'); ?>)
                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php $__currentLoopData = App\Models\Gateways\Gateway::getActive(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(auth()->guard()->check()): ?>
                    <?php if($gateway->driver == 'Balance'): ?>
                        <option <?php if($gateway->default): ?> selected <?php endif; ?> value="<?php echo e($gateway->id); ?>"
                                data-gateway-type="once"
                        <?php if(Auth::user()->balance >= $package->prices->first()->totalPrice()): ?>  <?php endif; ?>>
                            Pay with Balance (<?php echo e(currency('symbol')); ?><?php echo e(number_format(Auth::user()->balance, 2)); ?>)
                        </option>
                        <?php continue; ?>
                    <?php endif; ?>
                <?php endif; ?>
                <option <?php if($gateway->default): ?> selected <?php endif; ?> value="<?php echo e($gateway->id); ?>"><?php echo e($gateway->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </select>
    </div>

    <?php if(settings('taxes')): ?>
        <div class="relative mt-8 p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5" id="tax-card">
            <div class="flex justify-between mb-3 rounded-t sm:mb-3">
                <div class="text-lg text-gray-900 md:text-xl dark:text-white">
                    <h3 class="font-semibold"><?php echo __('client.personal_details'); ?></h3>
                    <p class="text-sm text-gray-500 dark:text-gray-400"><?php echo __('client.personal_details_desc'); ?></p>
                </div>
                <div></div>
            </div>

            <div class="mb-6">
                <div class="relative flex">
                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                        <i class='bx bxs-building-house text-gray-500 dark:text-gray-400'></i>
                    </div>
                    <input
                        type="text"
                        id="zip_code"
                        required
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10 p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                        placeholder="Zip/Post Code" name="zip_code"
                        value="<?php echo e(session('zip_code', auth()->user()->address->zip_code ?? NULL)); ?>"
                    />
                </div>
                <p id="coupon-description" class="mt-2 text-sm text-gray-500 dark:text-gray-400"></p>
            </div>

            <select
                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm mb-6 rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                name="country" id="country" tabindex="-1" aria-hidden="true" required>
                <?php $__currentLoopData = config('utils.countries'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($key); ?>"
                            <?php if(request()->header('cf-ipcountry', auth()->user()->address->country ?? NULL) == $key): ?> selected <?php endif; ?>><?php echo e($country); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    <?php endif; ?>


    <?php if($package->allow_notes): ?>
        <div class="relative mt-8 p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5 mb-6">
            <div class="custom-note">
                <div class="flex justify-between mb-3 rounded-t sm:mb-3">
                    <div class="text-lg text-gray-900 md:text-xl dark:text-white">
                        <h3 class="font-semibold"><?php echo __('client.custom_notes'); ?></h3>
                        <p class="text-sm text-gray-500 dark:text-gray-400">
                            <?php echo __('client.custom_notes_desc'); ?>

                        </p>
                    </div>
                    <div></div>
                </div>
                <textarea
                    id="message"
                    name="notes"
                    rows="4"
                    class="block p-2.5 w-full text-sm text-gray-900 bg-gray-50 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                    placeholder="<?php echo __('client.custom_notes_placeholder'); ?>"
                ></textarea>
            </div>
        </div>
        <?php endif; ?>


        </div>

        <div class="lg:w-1/3 pr-4 pl-4 md:w-1/3 pr-4 pl-4 sm:w-1/2 pr-4 pl-4 w-full">
            <div class="max-w-sm sticky top-8 left-0 p-6 bg-white border-gray-200 rounded-lg shadow dark:bg-gray-800">
                <a href="#">
                    <h5 class="mb-2 text-2xl font-bold tracking-tight text-gray-900 dark:text-gray-200 mb-4">
                        <?php echo __('client.order_summary'); ?>

                    </h5>
                </a>

                <p class="font-normal text-sm text-gray-700 dark:text-gray-400 flex justify-between mb-1"><?php echo __('client.recurring'); ?></p>

                <p class="font-normal text-sm text-gray-700 dark:text-gray-400 flex justify-between mb-4"><span
                        id="period"><?php echo e($package->prices->first()->periodToHuman()); ?></span>
                    <span><?php echo e(currency('symbol')); ?><span
                            id="recurring"><?php echo e(number_format($package->prices->first()->renewal_price, 2)); ?></span></span>
                </p>

                <hr class="h-px my-4 bg-gray-200 border-0 dark:bg-gray-700">
                <p class="font-normal text-sm text-gray-700 dark:text-gray-400 flex justify-between mb-4">
                    <span><?php echo __('client.setup_fee'); ?></span> <span><?php echo e(currency('symbol')); ?><span
                            id="setup_fee"><?php echo e(number_format($package->prices->first()->setup_fee, 2)); ?></span></span>
                </p>

                <hr class="h-px my-4 bg-gray-200 border-0 dark:bg-gray-700">
                <p class="font-normal text-sm text-gray-700 dark:text-gray-400 flex justify-between mb-4">
                    <span><?php echo e(__('client.discount')); ?></span> <span>-<?php echo e(currency('symbol')); ?><span
                            id="discounted">0.00</span></span></p>

                <div class="<?php if(!settings('taxes')): ?> hidden <?php endif; ?>" id="tax-div">
                    <hr class="h-px my-4 bg-gray-200 border-0 dark:bg-gray-700">
                    <p class="font-normal text-sm text-gray-700 dark:text-gray-400 flex justify-between mb-4">
                        <span>VAT <?php if(settings('tax_add_to_price')): ?>
                                Incl.
                            <?php else: ?>
                                Excl.
                            <?php endif; ?></span> <span><?php echo e(currency('symbol')); ?><span
                                id="taxes">0.00</span></span>
                    </p>
                </div>

                <hr class="h-px my-4 bg-gray-200 border-0 dark:bg-gray-700">

                <p class="font-normal text-sm text-gray-700 dark:text-gray-400 flex justify-between mb-2">
                    <span><?php echo __('client.due_today'); ?></span></p>

                <h5 class="mb-2 text-4xl font-bold tracking-tight text-gray-900 dark:text-white mb-6">
                    <?php echo e(currency('symbol')); ?><span id="total_price"></span>
                </h5>

                <?php if($page = Page::wherePath('terms-and-conditions')->first()): ?>
                    <div class="flex items-start mb-4">
                        <div class="flex items-center h-5">
                            <input
                                required=""
                                id="terms"
                                aria-describedby="terms"
                                type="checkbox"
                                class="w-4 h-4 bg-gray-50 rounded border-gray-300 focus:ring-3 focus:ring-blue-300 dark:focus:ring-blue-600 dark:ring-offset-gray-800 dark:bg-gray-700 dark:border-gray-600"
                            />
                        </div>
                        <div class="ml-3 text-sm">
                            <label for="terms"
                                   class="font-medium text-gray-900 dark:text-white"><?php echo __('client.i_accept_the'); ?><a
                                    class="ml-1 text-blue-700 dark:text-blue-500 hover:underline"
                                    href="<?php echo e(route('page', $page->path)); ?>"
                                    target="_blank"><?php echo __('client.terms_and_conditions'); ?></a></label>
                        </div>
                    </div>
                <?php endif; ?>

                <button type="submit" id="checkout"
                        class="text-white min-w-full bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-base px-6 py-3.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                    <?php echo __('client.complete_checkout'); ?>

                </button>

            </div>
            <p class="text-sm text-gray-500 dark:text-gray-400 mt-3"
               id="disclosure"><?php if($package->prices->first()->cancellation_fee > 0): ?>
                    <?php echo __('client.selected_price_includes_cancellation_fee'); ?>

                    $<?php echo e(number_format($package->prices->first()->cancellation_fee, 2)); ?>

                <?php endif; ?></p>
        </div>
        </div>
        </form>

        <script>
            const prices = <?php echo json_encode($package->prices->toArray()); ?>;
            const form = document.getElementById('price');

            function activePrice() {
                var selectedPrice = null;

                for (var i = 0; i < form.length; i++) {
                    if (form[i].checked) {
                        prices.forEach(price => {
                            if (form[i].value == price.id) {
                                selectedPrice = price;
                                return; // Exit the forEach loop early once a match is found
                            }
                        });
                        break;
                    }
                }

                return selectedPrice;
            }

            updateCheckoutPrice();
            <?php if(session('coupon_code')): ?>
            applyCoupon();
            <?php endif; ?>

            form.addEventListener('change', function (event) {
                event.preventDefault(); // Prevents the default form submission behavior

                updateCheckoutPrice();

            });

            function updateCheckoutPrice() {
                var price = activePrice();

                if (price.type == 'single') {
                    hideSubscriptionGateways();
                } else {
                    showSubscriptionGateways();
                }

                document.getElementById('recurring').innerHTML = price.renewal_price.toFixed(2);
                document.getElementById('period').innerHTML = periodToHuman(price);

                document.getElementById('setup_fee').innerHTML = price.setup_fee.toFixed(2);
                document.getElementById('discounted').innerHTML = getTotalDiscount((price.price + price.setup_fee));

                document.getElementById('taxes').innerHTML = calculateTax((price.price + price.setup_fee) - getTotalDiscount((price.price + price.setup_fee))).toFixed(2);

                document.getElementById('total_price').innerHTML = Math.max(0, getTotalPrice(price)).toFixed(2);

                if (price.cancellation_fee > 0) {
                    document.getElementById('disclosure').innerHTML = '*Selected price cycle includes a cancellation fee of $' + price.cancellation_fee.toFixed(2);
                } else {
                    document.getElementById('disclosure').innerHTML = '';
                }
            }

            function getTotalPrice(price) {

                totalPrice = (price.price + price.setup_fee);
                totalPrice = totalPrice - getTotalDiscount(totalPrice);

                // price excluded from tax
                <?php if(settings('tax_add_to_price')): ?>
                    totalPrice = totalPrice + calculateTax(totalPrice);
                <?php endif; ?>

                    return totalPrice.toFixed(2);
            }

            function getTotalDiscount(totalPrice) {

                let totalDiscount = 0;
                // check for affiliate discount using php
                <?php if(Cookie::get('affiliate')): ?>
                let factor = <?php echo e(Affiliate::calculateDiscountFactor(Cookie::get('affiliate'))); ?>;
                totalDiscount += totalPrice * factor;
                <?php endif; ?>

                if (typeof coupon_data !== "undefined") {
                    if (coupon_data.discount_type == 'percentage') {
                        totalDiscount += totalPrice * (coupon_data.discount_amount / 100);
                    } else {
                        totalDiscount += coupon_data.discount_amount;
                    }
                }

                return totalDiscount.toFixed(2);
            }

            function calculateTax(totalPrice) {
                <?php if(!settings('taxes')): ?>
                    return 0;
                <?php endif; ?>

                    gateway = document.getElementById('gateway').value;
                let disabledGateways = <?php echo App\Models\Settings::get('tax_disabled_gateways', '[]', ); ?>;
                if (disabledGateways.includes(gateway)) {
                    document.getElementById("tax-card").style.display = 'none';
                    document.getElementById("taxes").innerHTML = '0.00 (Calculated next step)';
                    return 0;
                } else {
                    document.getElementById("tax-card").style.display = '';
                }

                totalTax = 0;
                country = document.getElementById('country').value;
                let rates = <?php echo json_encode(config('tax.rates'), 15, 512) ?>;
                if (country in rates) {
                    rate = rates[country].standard_rate / 100;
                    <?php if(settings('tax_add_to_price')): ?>
                        totalTax = totalPrice * rate;
                    <?php else: ?>
                        totalTax = totalPrice - (totalPrice / (1 + rate));
                    <?php endif; ?>
                }

                return parseFloat(totalTax.toFixed(2));
            }

            function applyCoupon() {
                coupon = document.getElementById('coupon').value;

                if (coupon == '') {
                    alertCoupon('Please enter a coupon to apply it');
                    return;
                }

                fetch('/store/validate-coupon/<?php echo e($package->id); ?>/' + coupon, {
                    method: 'GET',
                    headers: {
                        'Content-Type': 'application/json',
                    }
                }).then(response => response.json())
                    .then(coupon => {
                        if (!coupon.success) {
                            alertCoupon(coupon.description);
                            return;
                        }

                        coupon_data = coupon;
                        alertCoupon(coupon.description);
                        updateCheckoutPrice();
                    })
                    .catch(error => {
                        alertCoupon('Something went wrong, please refresh and try again.');
                        return;
                    });

                updateCheckoutPrice();
            }

            function hideSubscriptionGateways() {
                // Get all select elements on the page
                var options = document.querySelectorAll('option');

                // Loop through the NodeList of select elements
                options.forEach(function (option) {
                    // Check if the data-x attribute's value matches the given value
                    if (option.getAttribute('data-gateway-type') == 'subscription') {
                        // Remove the select element from the document
                        // option.style.display = 'none'
                        option.setAttribute('disabled', '');
                    }
                });
            }


            function showSubscriptionGateways() {
                // Get all select elements on the page
                var options = document.querySelectorAll('option');

                // Loop through the NodeList of select elements
                options.forEach(function (option) {
                    // Check if the data-x attribute's value matches the given value
                    if (option.getAttribute('data-gateway-type') == 'subscription') {
                        // Remove the select element from the document
                        option.removeAttribute('disabled', '');
                    }
                });
            }

            function alertCoupon(desc) {
                document.getElementById('coupon-description').innerHTML = desc;
            }

            function period(price) {
                if (price.type == 'single') {
                    return '<?php echo __('admin.once'); ?>';
                }

                if (price.period == 1) {
                    return '<?php echo __('admin.day'); ?>';
                } else if (price.period == 7) {
                    return '<?php echo __('admin.week'); ?>';
                } else if (price.period == 30) {
                    return '<?php echo __('admin.month'); ?>';
                } else if (price.period == 90) {
                    return '<?php echo __('admin.quarter'); ?>';
                } else if (price.period == 365) {
                    return '<?php echo __('admin.year'); ?>';
                } else if (price.period == 730) {
                    return '<?php echo __('admin.per_years', ['years' => 2]); ?>';
                } else if (price.period == 1825) {
                    return '<?php echo __('admin.per_years', ['years' => 5]); ?>';
                } else if (price.period == 3650) {
                    return '<?php echo __('admin.per_years', ['years' => 10]); ?>';
                } else {
                    return '<?php echo __('admin.day'); ?>';
                }
            }

            function periodToHuman(price) {
                if (price.type == 'single') {
                    return '<?php echo __('admin.once'); ?>';
                }

                if (price.period == 1) {
                    return '<?php echo __('admin.daily'); ?>';
                } else if (price.period == 7) {
                    return '<?php echo __('admin.weekly'); ?>';
                } else if (price.period == 30) {
                    return '<?php echo __('admin.monthly'); ?>';
                } else if (price.period == 90) {
                    return '<?php echo __('admin.quaterly'); ?>';
                } else if (price.period == 365) {
                    return '<?php echo __('admin.yearly'); ?>';
                } else if (price.period == 730) {
                    return '<?php echo __('admin.per_years', ['years' => 2]); ?>';
                } else if (price.period == 1825) {
                    return '<?php echo __('admin.per_years', ['years' => 5]); ?>';
                } else if (price.period == 3650) {
                    return '<?php echo __('admin.per_years', ['years' => 10]); ?>';
                } else {
                    return '<?php echo __('admin.daily'); ?>';
                }
            }
        </script>
        <?php $__env->stopSection(); ?>

<?php echo $__env->make(Theme::wrapper(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/client/tailwind/store/packages/view.blade.php ENDPATH**/ ?>