<?php $__env->startSection('content'); ?>
<div>
    <button class="btn btn-primary mt-4 mb-4" data-toggle="modal"
            data-target="#createPriceModal"><?php echo e(__('admin.new_price')); ?>

    </button>

    <table class="table table-striped">
        <thead>
        <tr>
            <th scope="col"><?php echo e(__('admin.period')); ?></th>
            <th scope="col"><?php echo e(__('admin.status')); ?></th>
            <th scope="col"><?php echo e(__('admin.price')); ?></th>
            <th scope="col"><?php echo e(__('admin.renewal_price')); ?></th>
            <th scope="col"><?php echo e(__('admin.setup_fee')); ?></th>
            <th scope="col"><?php echo e(__('admin.cancellation_fee')); ?></th>
            <th scope="col"><?php echo __('admin.actions'); ?></th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $prices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($price->type == 'single' ? ucfirst($price->type) : ucfirst($price->type). ' / ' . $price->periodToHuman()); ?></td>
                <td>
                    <?php if($price->is_active): ?>
                        <div class="flex align-items-center">
                            <i class="fas fa-solid fa-circle  text-success "
                               style="font-size: 11px;"></i> <?php echo __('admin.active'); ?>

                        </div>
                    <?php else: ?>
                        <div class="flex align-items-center">
                            <i class="fas fa-solid fa-circle  text-danger "
                               style="font-size: 11px;"></i> <?php echo __('admin.inactive'); ?>

                        </div>
                    <?php endif; ?>
                </td>
                <td><?php echo e(currency('symbol')); ?><?php echo e($price->price); ?></td>
                <td><?php echo e(currency('symbol')); ?> <?php if(isset($price->renewal_price)): ?>
                        <?php echo e($price->renewal_price); ?>

                    <?php else: ?>
                        <?php echo e($price->price); ?>

                    <?php endif; ?>
                </td>
                <td><?php echo e(currency('symbol')); ?><?php echo e($price->setup_fee); ?></td>
                <td><?php echo e(currency('symbol')); ?><?php echo e($price->cancellation_fee); ?></td>
                <td>
                    <button class="btn btn-primary mt-4 mb-4" data-toggle="modal"
                            data-target="#editPriceModal-<?php echo e($price->id); ?>"><?php echo e(__('admin.edit')); ?>

                    </button>
                    <a href="<?php echo e(route('package_price.delete', ['price' => $price->id])); ?>"
                       class="btn btn-icon icon-left btn-danger"><?php echo __('admin.delete'); ?></a>
                </td>
            </tr>

            
            <div class="modal fade" tabindex="-1" role="dialog"
                 id="editPriceModal-<?php echo e($price->id); ?>">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <form
                            action="<?php echo e(route('package_price.update', ['price' => $price->id])); ?>"
                            method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="modal-header">
                                <h5 class="modal-title"><?php echo e(__('admin.editing_price_cycle')); ?></h5>
                                <button type="button" class="close" data-dismiss="modal"
                                        aria-label="<?php echo e(__('admin.close')); ?>">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body modal-lg">

                                <div class="form-group">
                                    <label for="type"><?php echo e(__('admin.type')); ?></label>
                                    <select class="form-control select2 select2-hidden-accessible hide" id="type-<?php echo e($price->id); ?>"
                                            name="type" tabindex="-1" aria-hidden="true" onchange="setPriceType('<?php echo e($price->id); ?>')">
                                        <option value="single" <?php if($price->type == 'single'): ?> selected <?php endif; ?>><?php echo e(__('admin.single')); ?></option>
                                        <option value="recurring" <?php if($price->type == 'recurring'): ?> selected <?php endif; ?>><?php echo e(__('admin.recurring')); ?></option>
                                    </select>
                                </div>

                                <div class="row <?php if($price->type == 'single'): ?> d-none <?php endif; ?>" id="recurring-options-<?php echo e($price->id); ?>">
                                    <div class="form-group col-md-12 col-12">
                                        <label for="period"><?php echo e(__('admin.period')); ?></label>
                                        <select
                                            class="form-control select2 select2-hidden-accessible hide"
                                            id="period" name="period" tabindex="-1"
                                            aria-hidden="true">
                                            <option value="1"
                                                    <?php if($price->period == 1): ?> selected <?php endif; ?>>
                                                <?php echo e(__('admin.daily')); ?>

                                            </option>
                                            <option value="7"
                                                    <?php if($price->period == 7): ?> selected <?php endif; ?>>
                                                <?php echo e(__('admin.weekly')); ?>

                                            </option>
                                            <option value="30"
                                                    <?php if($price->period == 30): ?> selected <?php endif; ?>>
                                                <?php echo e(__('admin.monthly')); ?>

                                            </option>
                                            <option value="90"
                                                    <?php if($price->period == 90): ?> selected <?php endif; ?>>
                                                <?php echo e(__('admin.quaterly')); ?>

                                            </option>
                                            <option value="365"
                                                    <?php if($price->period == 365): ?> selected <?php endif; ?>>
                                                <?php echo e(__('admin.yearly')); ?>

                                            </option>
                                            <option value="730"
                                                    <?php if($price->period == 730): ?> selected <?php endif; ?>>
                                                <?php echo __('admin.per_years', ['years' => 2]); ?>

                                            </option>
                                            <option value="1825"
                                                    <?php if($price->period == 1825): ?> selected <?php endif; ?>>
                                                <?php echo __('admin.per_years', ['years' => 5]); ?>

                                            </option>
                                            <option value="3650"
                                                    <?php if($price->period == 3650): ?> selected <?php endif; ?>>
                                                <?php echo __('admin.per_years', ['years' => 10]); ?>

                                            </option>
                                        </select>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="form-group col-md-12 col-12">
                                        <label for="price"><?php echo e(__('admin.price')); ?></label>
                                        <input onInput="updateRenewal(<?php echo e($price->id); ?>)"
                                               type="number" name="price"
                                               id="price-<?php echo e($price->id); ?>" min="0"
                                               step="0.01" value="<?php echo e($price->price); ?>"
                                               class="form-control" required=""/>
                                    </div>

                                    <div class="form-group col-md-12 col-12">
                                        <label for="setup_fee"><?php echo e(__('admin.setup_fee')); ?></label>
                                        <input type="number" name="setup_fee" id="setup_fee"
                                               min="0.00" step="0.01"
                                               value="<?php echo e($price->setup_fee); ?>"
                                               class="form-control"
                                               required=""/>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="form-group col-md-12 col-12">
                                        <label for="price"><?php echo e(__('admin.data')); ?></label>
                                        <textarea type="text" name="data"
                                                  id="data-<?php echo e($price->id); ?>"
                                                  class="form-control"><?php echo json_encode($price->data, 15, 512) ?></textarea>
                                        <small><?php echo e(__('admin.data_for_custom_gateways_should_be_left_empty')); ?></small>
                                    </div>
                                </div>

                                <div class="row <?php if($price->type == 'single'): ?> d-none <?php endif; ?>" id="price-options-<?php echo e($price->id); ?>">
                                    <div class="form-group col-md-6 col-6">
                                        <div class="control-label"><?php echo e(__('admin.renewal_price')); ?></div>
                                        <label class="custom-switch mt-2">
                                            <input onchange="checkbox(<?php echo e($price->id); ?>)"
                                                   type="checkbox"
                                                   id="enable-renewal-price-<?php echo e($price->id); ?>"
                                                   name="enable-renewal-price"
                                                   class="custom-switch-input">
                                            <span class="custom-switch-indicator"></span>
                                            <span class="custom-switch-description"><?php echo e(__('admin.use_custom_renewal_price')); ?></span>
                                        </label>
                                    </div>

                                    <div class="form-group col-md-6 col-6">
                                        <label for="renewal_price" data-toggle="tooltip"
                                               data-placement="right" title=""
                                               data-original-title="Renewal price refers to the cost of renewing a subscription, service or contract after the initial period at a possibly different rate."><?php echo e(__('admin.renewal_price')); ?> <i
                                                class="fa-solid fa-circle-info"></i></label>
                                        <input type="number" name="renewal_price"
                                               id="renewal_price-<?php echo e($price->id); ?>" min="0.00"
                                               value="<?php echo e($price->renewal_price); ?>" step="0.01"
                                               class="form-control" disabled/>
                                    </div>

                                    <div class="form-group col-md-6 col-6">
                                        <div class="control-label"><?php echo e(__('admin.cancelled_fee')); ?></div>
                                        <label class="custom-switch mt-2">
                                            <input type="checkbox"
                                                   onchange="checkbox(<?php echo e($price->id); ?>)"
                                                   id="enable-cancellation-fee-<?php echo e($price->id); ?>"
                                                   name="enable-cancellation-fee"
                                                   class="custom-switch-input">
                                            <span class="custom-switch-indicator"></span>
                                            <span class="custom-switch-description"><?php echo e(__('admin.setup_cancellation_fee')); ?></span>
                                        </label>
                                    </div>

                                    <div class="form-group col-md-6 col-6">
                                        <label for="cancellation_fee" data-toggle="tooltip"
                                               data-placement="right" title=""
                                               data-original-title="Cancellation fee is a charge for ending a contract or service agreement before its end date."><?php echo e(__('admin.cancelled_fee')); ?> <i class="fa-solid fa-circle-info"></i></label>
                                        <input type="number" name="cancellation_fee"
                                               id="cancellation_fee-<?php echo e($price->id); ?>"
                                               value="<?php echo e($price->cancellation_fee); ?>" min="0.00"
                                               step="0.01" class="form-control" disabled/>
                                    </div>

                                </div>
                                <div class="">
                                    <div class="form-group">
                                        <div class="control-label"><?php echo e(__('admin.active')); ?></div>
                                        <label class="custom-switch mt-2">
                                            <input type="checkbox" name="is_active"
                                                   class="custom-switch-input" value="1"
                                                   <?php if($price->is_active): ?> checked <?php endif; ?>>
                                            <span class="custom-switch-indicator"></span>
                                            <span class="custom-switch-description"><?php echo e(__('admin.you_can_deactivate_price_if_you_no_longer')); ?></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer bg-whitesmoke br">
                                <button type="button" class="btn btn-secondary"
                                        data-dismiss="modal"><?php echo e(__('admin.close')); ?>

                                </button>
                                <button class="btn btn-primary" type="submit"><?php echo e(__('admin.update')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <?php if(Prices::where('package_id', $package->id)->count() == 0): ?>
        <?php echo $__env->make(AdminTheme::path('empty-state'), [
            'title' => 'No prices found',
            'description' => 'This package is unlisted, please create a price.',
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
</div>

    
    <div class="modal fade" tabindex="-1" role="dialog" id="createPriceModal">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form action="<?php echo e(route('package_price.create', ['package' => $package->id])); ?>" method="POST"
                      enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('admin.create_price')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('admin.close')); ?>">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="form-group">
                            <label for="type"><?php echo e(__('admin.type')); ?></label>
                            <select class="form-control select2 select2-hidden-accessible hide" id="type-0"
                                    name="type" tabindex="-1" aria-hidden="true" onchange="setPriceType('0')">
                                <option value="single"><?php echo e(__('admin.single')); ?></option>
                                <option value="recurring" selected><?php echo e(__('admin.recurring')); ?></option>
                            </select>
                        </div>

                        <div class="row" id="recurring-options-0">
                            <div class="form-group col-md-12 col-12">
                                <label for="period"><?php echo e(__('admin.period')); ?></label>
                                <select class="form-control select2 select2-hidden-accessible hide" id="period"
                                        name="period" tabindex="-1" aria-hidden="true">
                                    <option value="1"><?php echo e(__('admin.daily')); ?></option>
                                    <option value="7"><?php echo e(__('admin.weekly')); ?></option>
                                    <option value="30" selected><?php echo e(__('admin.monthly')); ?></option>
                                    <option value="90"><?php echo e(__('admin.quaterly')); ?></option>
                                    <option value="365"><?php echo e(__('admin.yearly')); ?></option>
                                    <option value="730"><?php echo __('admin.per_years', ['years' => 2]); ?></option>
                                    <option value="1825"><?php echo __('admin.per_years', ['years' => 5]); ?></option>
                                    <option value="3650"><?php echo __('admin.per_years', ['years' => 10]); ?></option>

                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-12 col-12">
                                <label for="price-0"><?php echo e(__('admin.price')); ?></label>
                                <input onInput="updateRenewal(0)" type="number" name="price" id="price-0"
                                       min="0" step="0.01" value="1.00" class="form-control" required=""/>
                            </div>

                            <div class="form-group col-md-12 col-12">
                                <label for="setup_fee"><?php echo e(__('admin.setup_fee')); ?></label>
                                <input type="number" name="setup_fee" id="setup_fee" min="0.00" step="0.01"
                                       value="0.00" class="form-control" required=""/>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-12 col-12">
                                <label for="data"><?php echo e(__('admin.data')); ?></label>
                                <textarea type="text" name="data" id="data"
                                          class="form-control"></textarea>
                                <small><?php echo e(__('admin.data_for_custom_gateways_should_be_left_empty')); ?></small>
                            </div>
                        </div>

                        <div class="row" id="price-options-0">
                            <div class="form-group col-md-6 col-6">
                                <div class="control-label"><?php echo e(__('admin.renewal_price')); ?></div>
                                <label class="custom-switch mt-2">
                                    <input onchange="checkbox(0)" type="checkbox" id="enable-renewal-price-0"
                                           name="enable-renewal-price" class="custom-switch-input">
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description"><?php echo e(__('admin.use_custom_renewal_price')); ?></span>
                                </label>
                            </div>

                            <div class="form-group col-md-6 col-6">
                                <label for="renewal_price-0" data-toggle="tooltip" data-placement="right" title=""
                                       data-original-title="Renewal price refers to the cost of renewing a subscription, service or contract after the initial period at a possibly different rate."><?php echo __('admin.renewal_price'); ?> <i class="fa-solid fa-circle-info"></i></label>
                                <input type="number" name="renewal_price" id="renewal_price-0" min="0.00"
                                       step="0.01" class="form-control" disabled/>
                            </div>

                            <div class="form-group col-md-6 col-6">
                                <div class="control-label"><?php echo e(__('admin.cancellation_fee')); ?></div>
                                <label class="custom-switch mt-2">
                                    <input type="checkbox" onchange="checkbox(0)" id="enable-cancellation-fee-0"
                                           name="enable-cancellation-fee" class="custom-switch-input">
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description"><?php echo e(__('admin.setup_cancellation_fee')); ?></span>
                                </label>
                            </div>

                            <div class="form-group col-md-6 col-6">
                                <label for="cancellation_fee-0" data-toggle="tooltip" data-placement="right"
                                       title=""
                                       data-original-title="Cancellation fee is a charge for ending a contract or service agreement before its end date.">
                                    <?php echo __('admin.cancellation_fee'); ?> <i class="fa-solid fa-circle-info"></i></label>
                                <input type="number" name="cancellation_fee" id="cancellation_fee-0" min="0.00"
                                       step="0.01" class="form-control" disabled/>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer bg-whitesmoke br">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('admin.close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('admin.create')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<script>
    function updateRenewal(id) {
        if (document.getElementById('enable-renewal-price-' + id).checked == false) {
            document.getElementById('renewal_price-' + id).value = document.getElementById('price-' + id).value;
        }
    }

    function checkbox(id) {
        if (document.getElementById('enable-renewal-price-' + id).checked == false) {
            document.getElementById('renewal_price-' + id).setAttribute('disabled', '');
        } else {
            document.getElementById('renewal_price-' + id).removeAttribute('disabled');
        }

        if (document.getElementById('enable-cancellation-fee-' + id).checked == false) {
            document.getElementById('cancellation_fee-' + id).setAttribute('disabled', '');
        } else {
            document.getElementById('cancellation_fee-' + id).removeAttribute('disabled');
        }
    }

    function setPriceType(id) {
        var type = document.getElementById('type-' + id).value;

        if(type == 'single') {
            document.getElementById('recurring-options-' + id).classList.add('d-none');
            document.getElementById('price-options-'+ id).classList.add('d-none');
        } else {
            document.getElementById('recurring-options-'+ id).classList.remove('d-none');
            document.getElementById('price-options-'+ id).classList.remove('d-none');
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make(AdminTheme::path('packages/edit/master'), ['title' => 'Package Prices', 'tab' => 'prices'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/packages/edit/prices.blade.php ENDPATH**/ ?>