<form action="<?php echo e(route('admin.settings.store')); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <div class="card-header">
      <h4><?php echo __('admin.theme_settings'); ?></h4>
    </div>
    <div class="card-body">
      <div class="row">

        <div class="form-group col-md-12 col-12">
          <label for="user">Default Theme Color</label>
          <select class="form-control select2 select2-hidden-accessible" name="theme::default::theme-color" tabindex="-1"
                  aria-hidden="true">
              <?php $__currentLoopData = config('utils.tailwind-colors'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($color); ?>"
                          <?php if(settings('theme::default::theme-color', 'indigo') == $color): ?> selected="" <?php endif; ?>><?php echo e($color); ?>                  
                        </option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>

        <div class="form-group col-6">
          <label><?php echo __('admin.discord'); ?></label>
          <input type="text" name="socials::discord" value="<?php echo App\Models\Settings::get('socials::discord', '', ); ?>" class="form-control">
        </div>

        <div class="form-group col-6">
          <label><?php echo __('admin.github'); ?></label>
          <input type="text" name="socials::github" value="<?php echo App\Models\Settings::get('socials::github', '', ); ?>" class="form-control">
        </div>

        <div class="form-group col-6">
          <label><?php echo __('admin.twitter'); ?></label>
          <input type="text" name="socials::twitter" value="<?php echo App\Models\Settings::get('socials::twitter', '', ); ?>" class="form-control">
        </div>

        <div class="form-group col-6">
          <label><?php echo __('admin.auth_page_title'); ?></label>
          <input type="text" name="theme::default::auth::title" value="<?php echo App\Models\Settings::get('theme::default::auth::title', 'Your Game, Our World: Hosting Perfected', ); ?>" class="form-control">
        </div>

        <div class="form-group col-6">
          <label><?php echo __('admin.auth_page_description'); ?></label>
          <input type="text" name="theme::default::auth::description" value="<?php echo App\Models\Settings::get('theme::default::auth::description', 'Here you might want to explain how everything works. You can edit this in Admin -> configuration -> Theme Settings', ); ?>" class="form-control">
        </div>

        <div class="form-group col-6">
          <label><?php echo __('admin.auth_page_customers'); ?></label>
          <input type="text" name="theme::default::auth::customers" value="<?php echo App\Models\Settings::get('theme::default::auth::customers', 'Join over 3.2k members', ); ?>" class="form-control">
        </div>

        
      </div>
    </div>
    <div class="card-footer text-right">
      <button type="submit" class="btn btn-primary"><?php echo __('admin.submit'); ?></button>
    </div>
  </div>
</form>
<?php /**PATH /var/www/wemx/resources/themes/client/tailwind/admin-settings.blade.php ENDPATH**/ ?>