<?php $__env->startSection('container'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4><?php echo __('backups::messages.backups'); ?></h4>
                    <div class="card-header-action">
                        <a href="<?php echo e(route('admin.backups.create')); ?>" class="btn btn-icon icon-left btn-primary">
                            <i class="fas fa-solid fa-download"></i>
                            <?php echo __('backups::messages.create_backup'); ?>

                        </a>
                        <button type="button" class="btn btn-icon icon-left btn-primary" data-toggle="modal"
                           data-target="#configModal">
                            <i class="fas fa-solid fa-tools"></i>
                            <?php echo __('backups::messages.settings'); ?>

                        </button>
                        <button type="button" class="btn btn-icon icon-left btn-primary" data-toggle="modal"
                                data-target="#logsModal">
                            <i class="fas fa-solid fa-list"></i>
                            <?php echo __('backups::messages.logs'); ?>

                        </button>
                    </div>

                </div>


                <div class="card-body p-3">
                    <div class="table-responsive">
                        <table class="table table-striped table-md">
                            <tbody>
                            <tr>
                                <th class=""><?php echo __('backups::messages.name'); ?></th>
                                <th class=""><?php echo __('backups::messages.path'); ?></th>
                                <th class=""><?php echo __('backups::messages.size'); ?> (<?php echo e(bytesToHuman($files_backups['total_size'] + $db_backups['total_size'])); ?>)</th>
                                <th class=""><?php echo __('backups::messages.date'); ?></th>
                                <th class="text-right"><?php echo __('admin.action'); ?></th>
                            </tr>

                            <tr>
                                <th scope="row" colspan="5" class="text-center"><?php echo __('backups::messages.files'); ?> (<?php echo e(count($files_backups['files'])); ?>)</th>
                            </tr>
                            <?php $__currentLoopData = $files_backups['files']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $backup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class=""><?php echo e($backup['name']); ?></td>
                                    <td class=""><?php echo e($backup['path']); ?></td>
                                    <td class=""><?php echo e(bytesToHuman($backup['size'])); ?></td>
                                    <td class=""><?php echo e($backup['date']); ?></td>
                                    <td class="text-right">
                                        <a href="<?php echo e(route('admin.backups.download', $backup['name'])); ?>"
                                           class="btn btn-primary mr-2" title="<?php echo __('backups::messages.download'); ?>">
                                            <i class="fas fa-download"></i>
                                        </a>

                                        <form action="<?php echo e(route('admin.backups.delete', $backup['name'])); ?>" method="post" style="display: inline-block;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger"
                                                    title="<?php echo __('backups::messages.delete'); ?>"
                                                    onclick="return confirm('<?php echo __('backups::messages.confirm_delete'); ?>')">
                                                <i class="fas fa-trash-alt"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <tr>
                                <th scope="row" colspan="5" class="text-center"><?php echo __('backups::messages.database'); ?>  (<?php echo e(count($db_backups['files'])); ?>)</th>
                            </tr>


                            <?php $__currentLoopData = $db_backups['files']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $backup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class=""><?php echo e($backup['name']); ?></td>
                                    <td class=""><?php echo e($backup['path']); ?></td>
                                    <td class=""><?php echo e(bytesToHuman($backup['size'])); ?></td>
                                    <td class=""><?php echo e($backup['date']); ?></td>
                                    <td class="text-right">
                                        <a href="<?php echo e(route('admin.backups.download', $backup['name'])); ?>"
                                           class="btn btn-primary mr-2" title="<?php echo __('backups::messages.download'); ?>">
                                            <i class="fas fa-download"></i>
                                        </a>

                                        <form action="<?php echo e(route('admin.backups.delete', $backup['name'])); ?>" method="post" style="display: inline-block;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger"
                                                    title="<?php echo __('backups::messages.delete'); ?>"
                                                    onclick="return confirm('<?php echo __('backups::messages.confirm_delete'); ?>')">
                                                <i class="fas fa-trash-alt"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer text-right">

                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="configModal" tabindex="-1" role="dialog"
         aria-labelledby="configModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="configModalLabel"><?php echo __('backups::messages.settings'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('admin.close')); ?>">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.backups.settings')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group col-md-12 col-12">
                            <label for="path"><?php echo __('backups::messages.save_path'); ?></label>
                            <input id="path" type="text" class="form-control" name="path" value="<?php echo e(settings('backups::path', dirname(base_path()) . '/backups/wemx')); ?>" required/>
                        </div>
                        <div class="form-group col-md-12 col-12">
                            <label for="save-count"><?php echo __('backups::messages.save_count'); ?></label>
                            <input id="save-count" type="number" class="form-control" name="save-count" value="<?php echo e(settings('backups::save-count', 10)); ?>" required/>
                        </div>
                        <div class="form-group col-md-12 col-12">
                            <label for="every-hours"><?php echo __('backups::messages.every_hours', ['hours' => settings('backups::every-hours', 12)]); ?></label>
                            <input id="every-hours" type="number" class="form-control" name="every-hours" value="<?php echo e(settings('backups::every-hours', 12)); ?>" required/>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary"
                                    data-dismiss="modal"><?php echo __('admin.close'); ?></button>
                            <button type="submit" class="btn btn-primary"><?php echo __('backups::messages.save'); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <style>
        .modal-logs {
            height: 75vh;
            overflow-y: scroll !important;
            padding-right: 0 !important;
        }
        pre {
            white-space: pre-wrap;       /* css-3 */
            white-space: -moz-pre-wrap;  /* Mozilla, since 1999 */
            white-space: -o-pre-wrap;    /* Opera 7 */
            word-wrap: break-word;       /* Internet Explorer 5.5+ */
        }
    </style>

    
    <div class="modal fade" id="logsModal" tabindex="-1" role="dialog" aria-labelledby="logsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="logsModalLabel"><?php echo __('backups::messages.logs'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('admin.close')); ?>">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body modal-logs">
                    <pre class="text-success"><?php echo e($logs); ?></pre>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo __('admin.close'); ?></button>
                    <a href="<?php echo e(route('admin.backups.logs-clear')); ?>" class="btn btn-warning"><?php echo __('backups::messages.clear_logs'); ?></a>
                </div>

            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('backups::messages.backups')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/Modules/Backups/Resources/views/admin/default/index.blade.php ENDPATH**/ ?>