<?php $__env->startSection('css_libraries'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <div class="row">
        <div class="col-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4><?php echo __('admin.create_package', ['default' => 'Create Package']); ?></h4>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('packages.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row mt-4">
                            <div class="form-group col-md-12 col-12">
                                <label for="name"><?php echo __('admin.package_name', ['default' => 'Package Name']); ?></label>
                                <input type="text" name="name" id="name" placeholder="<?php echo __('admin.package_name', ['default' => 'Package Name']); ?>" class="form-control"
                                       value="" required=""/>
                            </div>

                            <div class="form-group col-md-12 col-12">
                                <label for="category"><?php echo __('admin.category'); ?></label>
                                <select class="form-control select2 select2-hidden-accessible" name="category"
                                        tabindex="-1" aria-hidden="true">
                                    <?php $__currentLoopData = Categories::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group col-md-12 col-12">
                                <label for="service"><?php echo __('admin.service_provider', ['default' => 'Service Provider']); ?></label>
                                <select class="form-control select2 select2-hidden-accessible" name="service"
                                        tabindex="-1" aria-hidden="true">
                                    <?php $__currentLoopData = Service::allEnabled(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($service->module()->getLowerName()); ?>"><?php echo e($service->about()->display_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group col-md-12 col-12">
                                <label for="status"><?php echo __('admin.package_status', ['default' => 'Package Status']); ?></label>
                                <select class="form-control select2 select2-hidden-accessible" name="status"
                                        tabindex="-1" aria-hidden="true">
                                    <option value="active"><?php echo __('admin.active'); ?></option>
                                    <option value="unlisted">
                                        <?php echo __('admin.package_status_unlisted', ['default' => 'Unlisted (only users with direct link can view)']); ?>

                                    </option>
                                    <option value="restricted" selected>
                                        <?php echo __('admin.package_status_admin_only', ['default' => 'Admin Only (only administrators can view)']); ?>

                                    </option>
                                    <option value="inactive">
                                        <?php echo __('admin.package_status_retired_inactive', ['default' => 'Retired / Inactive (package will not be shown to new customers)']); ?>

                                    </option>
                                </select>
                            </div>
                        </div>
                        <button href="#" class="btn btn-dark" type="submit"><?php echo __('admin.create'); ?></button>
                    </form>
                </div>
            </div>

        </div>
    </div>

    <style>
        span.select2.select2-container.select2-container--default {
            width: 100% !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.packages'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/packages/create.blade.php ENDPATH**/ ?>