<form action="<?php echo e(route('admin.settings.store')); ?>" method="POST">
    <?php echo csrf_field(); ?>

    <div class="row">
        <div class="form-group col-6">
            <label for="language"><?php echo __('client.portal_redirect'); ?></label>
            <select class="form-control select2 select2-hidden-accessible" name="portal::is_redirect" tabindex="-1" aria-hidden="true">
                <option value="0" <?php if(settings('portal::is_redirect', false)): ?> selected <?php endif; ?>><?php echo e(__('client.false')); ?></option>
                <option value="1" <?php if(settings('portal::is_redirect', false)): ?> selected <?php endif; ?>><?php echo e(__('client.true')); ?></option>
            </select>
        </div>

        <div class="form-group col-6">
            <label><?php echo __('client.portal_redirect_url'); ?></label>
            <input type="text" name="portal::redirect_url" value="<?php echo App\Models\Settings::get('portal::redirect_url', '/dashboard', ); ?>" class="form-control">
        </div>

        <div class="form-group col-6">
            <label><?php echo __('client.portal_header_image'); ?></label>
            <input type="text" name="portal::default::header_image" value="<?php echo App\Models\Settings::get('portal::default::header_image', 'https://www.freepnglogos.com/uploads/minecraft-png/download-minecraft-characters-png-png-image-pngimg-29.png', ); ?>" class="form-control">
        </div>

        <div class="form-group col-6">
            <label for="category"><?php echo __('client.default_category'); ?></label>
            <select class="form-control select2 select2-hidden-accessible" name="portal::default_category" tabindex="-1" aria-hidden="true">
                <?php $__currentLoopData = Categories::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($category->link); ?>" <?php if(settings('portal::default_category') == $category->link): ?> selected <?php endif; ?>><?php echo e($category->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </div>


        <button type="submit" class="btn btn-primary"><?php echo __('client.submit'); ?></button>
</form>
<?php /**PATH /var/www/wemx/resources/themes/portal/default/admin-settings.blade.php ENDPATH**/ ?>