<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="description" content="WemX Billing System">
    <meta name="keywords"
          content="WemX Panel, Billing Panel, <?php if(isset($keywords)): ?><?php echo e($keywords); ?><?php endif; ?>">
    <meta name="author" content="WemX">
    <title><?php echo __('admin.admin'); ?> | <?php if(isset($title)): ?>
            <?php echo e($title); ?>

        <?php endif; ?> - <?php echo e(config('app.name')); ?></title>
    <link rel="icon" type="image/png" href="<?php echo App\Models\Settings::get('favicon', 'https://imgur.com/oJDxg2r.png', ); ?>">

    <!-- General CSS Files -->
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/bootstrap/css/bootstrap.min.css'))); ?>"/>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css"
          integrity="sha384-DyZ88mC6Up2uqS4h/KRgHuoeGwBcD4Ng9SiP4dIRy0EXTlnuz47vAwmeGwVChigm" crossorigin="anonymous"/>

    <!-- CSS Libraries -->
    <?php echo $__env->yieldContent('css_libraries'); ?>
    <style>

        .sidebar-dropdown::before {
            content: "→";
            display: inline-block;
            left: -14px;
            position: relative;
        }

        .active-nav {
            color: #4f46e5 !important;
            font-weight: 600 !important;
        }

    </style>

    <!-- Template CSS -->
    <?php if(Cache::get('admin_theme_mode_'.auth()->user()->id, 'light') == 'dark'): ?>
        <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('css/dark-style.css'))); ?>"/>
    <?php else: ?>
        <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('css/style.css'))); ?>"/>
    <?php endif; ?>

    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('css/custom.css'))); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('css/components.css'))); ?>"/>

    <!-- Start GA -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-94034622-3"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }

        gtag("js", new Date());
        gtag("config", "UA-94034622-3");
    </script>
    <!-- /END GA -->
</head>

<body>
<div id="app">
    <div class="main-wrapper main-wrapper-1">
        <div class="navbar-bg primary-bg"></div>
        <nav class="navbar navbar-expand-lg main-navbar">
            <form class="form-inline mr-auto">
                <ul class="navbar-nav mr-3">
                    <li>
                        <a href="#" data-toggle="sidebar" class="nav-link nav-link-lg"><i
                                class="fas fa-bars"></i></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('dashboard')); ?>" target="_blank" class="nav-link nav-link-lg"><i
                                class="fas fa-home"></i></a>
                    </li>
                    <li>
                        <a href="#" data-toggle="search" class="nav-link nav-link-lg d-sm-none"><i
                                class="fas fa-search"></i></a>
                    </li>
                </ul>
            </form>
            <?php if(auth()->check()): ?>
                <ul class="navbar-nav navbar-right">
                    <?php $__currentLoopData = Module::allEnabled(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if ($__env->exists(AdminTheme::moduleView($module->getLowerName(), 'elements.navbar-dropdown-right'))) echo $__env->make(AdminTheme::moduleView($module->getLowerName(), 'elements.navbar-dropdown-right'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <a href="<?php echo e(route('admin.toggle-mode')); ?>" class="nav-link nav-link-lg"><i
                                class="fas fa-adjust"></i></a>
                    </li>
                    <li class="dropdown dropdown-list-toggle">
                        <a href="#" data-toggle="dropdown" class="nav-link nav-link-lg message-toggle">
                            <i class="far fa-envelope"></i></a>
                        <div class="dropdown-menu dropdown-list dropdown-menu-right">
                            <div class="dropdown-header">
                                <?php echo __('admin.email_history', ['default' => 'Email History']); ?>

                            </div>
                            <div class="dropdown-list-content dropdown-list-message">

                                <?php $__currentLoopData = EmailHistory::where('user_id', Auth::user()->id)->latest()->paginate(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $email): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="#" class="dropdown-item dropdown-item-unread">
                                        <div class="dropdown-item-avatar">
                                            <img alt="image"
                                                 src="https://upload.wikimedia.org/wikipedia/commons/5/5f/Gravatar-default-logo.jpg"
                                                 class="rounded-circle">
                                            <div class="is-online"></div>
                                        </div>
                                        <div class="dropdown-item-desc">
                                            <b><?php echo e($email->receiver); ?></b>
                                            <p><?php echo e($email->subject); ?></p>
                                            <div class="time"><?php echo e($email->created_at->diffForHumans()); ?></div>
                                        </div>
                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                            <div class="dropdown-footer text-center">
                                <a href="<?php echo e(route('email.history')); ?>">
                                    <?php echo __('admin.view_all', ['default' => 'View All']); ?>

                                    <i class="fas fa-chevron-right"></i>
                                </a>
                            </div>
                        </div>
                    </li>

                    <li class="dropdown dropdown-list-toggle">
                        <a href="#" data-toggle="dropdown" class="nav-link notification-toggle nav-link-lg
                            <?php if(Notification::where('user_id', Auth::user()->id)->where('read_at', '=', null)->exists()): ?> beep <?php endif; ?>">
                            <i class="far fa-bell"></i>
                        </a>
                        <div class="dropdown-menu dropdown-list dropdown-menu-right">
                            <div class="dropdown-header">
                                <?php echo __('admin.notifications', ['default' => 'Notifications']); ?>

                                <div class="float-right">
                                    <a href="<?php echo e(route('notifications.mark-as-read')); ?>">
                                        <?php echo __('admin.mark_as_read', ['default' => 'Mark All As Read']); ?>

                                    </a>
                                </div>
                            </div>
                            <div class="dropdown-list-content dropdown-list-icons">

                                <?php $__currentLoopData = Notification::where('user_id', Auth::user()->id)->latest()->paginate(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notificaiton): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="#" class="dropdown-item dropdown-item-unread">
                                        <div class="dropdown-item-desc">
                                            <?php echo e($notificaiton->message); ?>

                                            <div
                                                class="time text-primary"><?php echo e($notificaiton->created_at->diffForHumans()); ?></div>
                                        </div>
                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                        </div>
                    </li>

                    <li class="dropdown">
                        <a href="#" data-toggle="dropdown" class="nav-link dropdown-toggle nav-link-lg nav-link-user">
                            <img alt="image" src="<?php echo e(Auth::user()->avatar()); ?>" class="rounded-circle mr-1">
                            <div class="d-sm-none d-lg-inline-block"><?php echo e(Auth::user()->first_name); ?>

                                <?php echo e(Auth::user()->last_name); ?>

                            </div>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right">
                            <?php if(Auth::user()->hasPerm('admin.view')): ?>
                                <a href="<?php echo e(route('admin.view')); ?>" class="dropdown-item has-icon">
                                    <i class="fas fa-solid fa-toolbox"></i> <?php echo __('admin.admin_panel'); ?>

                                </a>
                            <?php endif; ?>
                            <a href="<?php echo e(route('user.settings')); ?>" class="dropdown-item has-icon">
                                <i class="fas fa-cog"></i> <?php echo __('admin.settings', ['default' => 'Settings']); ?>

                            </a>
                            <?php $__currentLoopData = Module::allEnabled(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(config($module->getLowerName() . '.elements.user_dropdown')): ?>
                                    <?php $__currentLoopData = config($module->getLowerName() . '.elements.user_dropdown'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo e($menu['href']); ?>" class="dropdown-item has-icon"
                                           style="<?php echo e($menu['style']); ?>">
                                            <?php echo $menu['icon']; ?> <?php echo __($menu['name']); ?>

                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div class="dropdown-divider"></div>
                            <a href="/auth/logout" class="dropdown-item has-icon text-danger">
                                <i class="fas fa-sign-out-alt"></i> <?php echo __('admin.logout', ['default' => 'Logout']); ?>

                            </a>
                        </div>
                    </li>
                </ul>
            <?php endif; ?>
        </nav>

        <div class="main-sidebar sidebar-style-2">
            <aside id="sidebar-wrapper">
                <div class="sidebar-brand">
                    <a href="<?php echo e(route('admin.view')); ?>"><?php echo __('admin.admin_panel'); ?></a>
                </div>
                <div class="sidebar-brand sidebar-brand-sm">
                    <a href="<?php echo e(route('admin.view')); ?>"><?php echo __('admin.panel', ['default' => 'PANEL']); ?></a>
                </div>
                <ul class="sidebar-menu">
                    <li class="menu-header"><?php echo __('admin.dashboard', ['default' => 'Dashboard']); ?></li>
                    <li>
                        <a class="nav-link <?php echo e(nav_active('admin.view')); ?>" href="<?php echo e(route('admin.view')); ?>"><i
                                class="fas fa-fire"></i>
                            <span><?php echo __('admin.overview'); ?></span></a>
                    </li>

                    <li class="menu-header"><?php echo __('admin.client_management', ['default' => 'Client Management']); ?></li>
                    <li class="dropdown <?php echo e(nav_active(['users.index', 'groups.index'])); ?>">
                        <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i
                                class="fas fa-user"></i> <span><?php echo __('admin.customers'); ?></span></a>
                        <ul class="dropdown-menu">
                            <li><a class="nav-link <?php echo e(nav_active('users.index')); ?>"
                                   href="<?php echo e(route('users.index')); ?>"><?php echo __('admin.clients'); ?></a>
                            </li>
                            <li><a class="nav-link <?php echo e(nav_active('groups.index')); ?>"
                                   href="<?php echo e(route('groups.index')); ?>"><?php echo __('admin.groups'); ?></a>
                            </li>
                        </ul>
                    </li>

                    <li class="dropdown <?php echo e(nav_active(['admin.bans.index', 'admin.warnings.index'])); ?>">
                        <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i
                                class="fas fa-gavel"></i> <span><?php echo __('admin.punishments'); ?></span></a>
                        <ul class="dropdown-menu">
                            <li>
                                <a class="nav-link <?php echo e(nav_active('admin.bans.index')); ?>"
                                   href="<?php echo e(route('admin.bans.index')); ?>"><?php echo e(__('admin.bans')); ?></a>
                            </li>
                            <li>
                                <a class="nav-link <?php echo e(nav_active('admin.warnings.index')); ?>"
                                   href="<?php echo e(route('admin.warnings.index')); ?>"><?php echo e(__('admin.warnings')); ?></a>
                            </li>
                        </ul>
                    </li>

                    <li>
                        <a class="nav-link <?php echo e(nav_active('payments.index')); ?>"
                           href="<?php echo e(route('payments.index', ['status' => 'paid'])); ?>"><i
                                class="fas fa-solid fa-coins"></i>
                            <span><?php echo __('admin.payments', ['default' => 'Payments']); ?></span></a>
                    </li>

                    <li>
                        <a class="nav-link <?php echo e(nav_active('payments.subscriptions')); ?>"
                           href="<?php echo e(route('payments.subscriptions', ['status' => 'paid'])); ?>">
                            <i class="fas fa-hand-holding-usd"></i>
                            <span><?php echo __('client.subscription'); ?></span></a>
                    </li>

                    <li>
                        <a class="nav-link <?php echo e(nav_active('orders.index')); ?>"
                           href="<?php echo e(route('orders.index', ['status' => 'active'])); ?>"><i
                                class="fas fa-solid fa-server"></i>
                            <span><?php echo __('admin.orders', ['default' => 'Orders']); ?></span></a>
                    </li>

                    <li class="menu-header"><?php echo __('admin.settings', ['default' => 'Settings']); ?></li>
                    <li class="dropdown <?php echo e(nav_active('admin/settings', prefix: true)); ?>">
                        <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i
                                class="fas fa-cog"></i>
                            <span><?php echo __('admin.configuration', ['default' => 'Configuration']); ?></span></a>
                        <ul class="dropdown-menu">
                            <li>
                                <a class="nav-link <?php echo e(nav_active('admin.settings')); ?>"
                                   href="<?php echo e(route('admin.settings')); ?>"><?php echo __('admin.settings', ['default' => 'Settings']); ?></a>
                            </li>
                            <li>
                                <a class="nav-link <?php echo e(nav_active('admin.seo')); ?>"
                                   href="<?php echo e(route('admin.seo')); ?>"><?php echo __('admin.seo', ['default' => 'SEO']); ?></a>
                            </li>
                            <li>
                                <a class="nav-link <?php echo e(nav_active('admin.taxes')); ?>"
                                   href="<?php echo e(route('admin.taxes')); ?>"><?php echo e(__('admin.taxes')); ?></a>
                            </li>
                            <li>
                                <a class="nav-link <?php echo e(nav_active('admin.registrations')); ?>"
                                   href="<?php echo e(route('admin.registrations')); ?>"><?php echo __('admin.registrations', ['default' => 'Registrations']); ?></a>
                            </li>
                            <li>
                                <a class="nav-link <?php echo e(nav_active('admin.oauth')); ?>"
                                   href="<?php echo e(route('admin.oauth')); ?>"><?php echo __('admin.oauth', ['default' => 'Oauth']); ?></a>
                            </li>
                            <li>
                                <a class="nav-link <?php echo e(nav_active('admin.captcha')); ?>"
                                   href="<?php echo e(route('admin.captcha')); ?>"><?php echo __('admin.captcha', ['default' => 'Captcha']); ?></a>
                            </li>
                            <li>
                                <a class="nav-link <?php echo e(nav_active('admin.maintenance')); ?>"
                                   href="<?php echo e(route('admin.maintenance')); ?>"><?php echo __('admin.maintenance', ['default' => 'Maintenance']); ?></a>
                            </li>
                            <li>
                                <a class="nav-link <?php echo e(nav_active('admin.settings.theme')); ?>"
                                   href="<?php echo e(route('admin.settings.theme')); ?>"><?php echo __('admin.theme_settings', ['default' => 'Theme Settings']); ?></a>
                            </li>
                            <li>
                                <a class="nav-link <?php echo e(nav_active('admin.settings.portal')); ?>"
                                   href="<?php echo e(route('admin.settings.portal')); ?>"><?php echo __('admin.portals', ['default' => 'Portals']); ?></a>
                            </li>
                            <li>
                                <a class="nav-link <?php echo e(nav_active('logs.index')); ?>"
                                   href="<?php echo e(route('logs.index')); ?>"><?php echo __('admin.logs', ['default' => 'Logs']); ?></a>
                            </li>
                        </ul>
                    </li>
                    <li class="dropdown <?php echo e(nav_active('admin/emails', prefix: true)); ?>">
                        <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i
                                class="fas fa-solid fa-envelope"></i>
                            <span><?php echo __('admin.emails', ['default' => 'Emails']); ?></span></a>
                        <ul class="dropdown-menu">
                            <li>
                                <a class="nav-link <?php echo e(nav_active('emails.history')); ?>"
                                   href="<?php echo e(route('emails.history')); ?>"><?php echo __('admin.history', ['default' => 'History']); ?></a>
                            </li>
                            <li>
                                <a class="nav-link <?php echo e(nav_active('emails.configure')); ?>"
                                   href="<?php echo e(route('emails.configure')); ?>"><?php echo __('admin.configure', ['default' => 'Configure']); ?></a>
                            </li>
                            <li>
                                <a class="nav-link <?php echo e(nav_active('emails.messages')); ?>"
                                   href="<?php echo e(route('emails.messages')); ?>"><?php echo __('admin.messages', ['default' => 'Messages']); ?></a>
                            </li>
                            <li>
                                <a class="nav-link <?php echo e(nav_active('emails.templates')); ?>"
                                   href="<?php echo e(route('emails.templates')); ?>"><?php echo __('admin.templates', ['default' => 'Templates']); ?></a>
                            </li>
                        </ul>
                    </li>

                    <li>
                        <a class="nav-link <?php echo e(nav_active('pages.index')); ?>" href="<?php echo e(route('pages.index')); ?>"><i
                                class="fas fa-solid fa-file"></i>
                            <span><?php echo __('admin.pages', ['default' => 'Pages']); ?></span></a>
                    </li>

                    <li>
                        <a class="nav-link <?php echo e(nav_active('articles.index')); ?>" href="<?php echo e(route('articles.index')); ?>"><i
                                class="fas fa-solid fa-newspaper"></i>
                            <span><?php echo e(__('admin.articles')); ?></span></a>
                    </li>

                    

                    <li class="menu-header"><?php echo __('admin.store', ['default' => 'Store']); ?></li>
                    <li class="dropdown <?php echo e(nav_active(['categories.index', 'packages.index', 'coupons.index'])); ?>">
                        <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i
                                class="fas fa-solid fa-box"></i>
                            <span><?php echo __('admin.products_and_services', ['default' => 'Products & Services']); ?></span></a>
                        <ul class="dropdown-menu">
                            <li><a class="nav-link <?php echo e(nav_active('categories.index')); ?>"
                                   href="<?php echo e(route('categories.index')); ?>"><?php echo __('admin.categories'); ?></a></li>
                            <li><a class="nav-link <?php echo e(nav_active('packages.index')); ?>"
                                   href="<?php echo e(route('packages.index')); ?>"><?php echo __('admin.packages', ['default' => 'Packages']); ?></a>
                            <li><a class="nav-link <?php echo e(nav_active('coupons.index')); ?>"
                                   href="<?php echo e(route('coupons.index')); ?>"><?php echo __('admin.coupons', ['default' => 'Coupons']); ?></a>
                            </li>

                        </ul>
                    </li>


                    <li>
                        <a class="nav-link <?php echo e(nav_active('gateways.index')); ?>" href="<?php echo e(route('gateways.index')); ?>"><i
                                class="fas fa-solid fa-credit-card"></i>
                            <span><?php echo __('admin.gateways'); ?></span></a>
                    </li>

                    <li class="menu-header">
                        <?php echo __('admin.design_and_compatibility', ['default' => 'Design & Compatibility']); ?></li>







                    <li class="dropdown <?php echo e(nav_active('themes', dropdown: true)); ?>">
                        <a href="#" class="nav-link has-dropdown" data-toggle="dropdown"><i
                                class="fas fa-sharp fa-solid fa-palette"></i>
                            <span><?php echo __('admin.themes'); ?></span></a>
                        <ul class="dropdown-menu">
                            <li><a class="nav-link <?php echo e(nav_active('admin.themes')); ?>"
                                   href="<?php echo e(route('admin.themes')); ?>"><?php echo __('admin.client_themes'); ?></a></li>
                            <li><a class="nav-link <?php echo e(nav_active('admin.admin_themes')); ?>"
                                   href="<?php echo e(route('admin.admin_themes')); ?>"><?php echo __('admin.admin_themes'); ?></a>
                            </li>
                        </ul>
                    </li>

                    <li>
                        <a class="nav-link <?php echo e(nav_active('modules.view')); ?>" href="<?php echo e(route('modules.view')); ?>"><i
                                class="fas fa-solid fa-plug"></i>
                            <span><?php echo __('admin.modules'); ?></span></a>
                    </li>

                    <li>
                        <a class="nav-link <?php echo e(nav_active('services.view')); ?>" href="<?php echo e(route('services.view')); ?>"><i
                                class="fas fa-solid fa-robot"></i>
                            <span><?php echo __('admin.services', ['default' => 'Services']); ?></span></a>
                    </li>

                    <li class="menu-header"><?php echo __('admin.modules'); ?></li>

                    <?php $__currentLoopData = Module::allEnabled(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(config($module->getLowerName() . '.elements.admin_menu')): ?>
                            <?php $__currentLoopData = config($module->getLowerName() . '.elements.admin_menu'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <?php if(isset($menu['type']) AND $menu['type'] == 'dropdown'): ?>
                                    <li class="dropdown  <?php echo e(nav_active($module->getLowerName(), dropdown: true)); ?>">
                                        <a href="#" class="nav-link has-dropdown"
                                           data-toggle="dropdown"><?php echo $menu['icon']; ?>

                                            <span><?php echo e(__($menu['name'])); ?></span></a>
                                        <ul class="dropdown-menu">

                                            <?php $__currentLoopData = $menu['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li>
                                                    <a class="nav-link <?php echo e(nav_active($item['href'], href: true)); ?>"
                                                       href="<?php echo e($item['href']); ?>">
                                                        <?php echo e(__($item['name'])); ?>

                                                    </a>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </li>
                                    <?php continue; ?>
                                <?php endif; ?>


                                <li>
                                    <a class="nav-link <?php echo e(nav_active($module->getLowerName(), true)); ?>"
                                       style="<?php echo e($menu['style']); ?>"
                                       href="<?php echo e($menu['href']); ?>"><?php echo $menu['icon']; ?>

                                        <span><?php echo __($menu['name']); ?></span>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <div id="nav-footer" style="min-height: 20px;"></div>
                <hr>
            </aside>
        </div>

        <!-- Main Content -->
        <div class="main-content" style="min-height: 842px;">
            
            <?php if(count($errors) > 0): ?>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="alert alert-danger">
                        <a href="#" style="background: #0000003d;" class="badge badge-danger">
                            <i class="fas fa-solid fa-bell" style="margin-left: 0px"></i></a> <?php echo $error; ?>

                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>

            <?php if(Session::has('success')): ?>
                <div class="alert alert-success">
                    <a href="#" style="background: #0000003d;" class="badge badge-success">
                        <i class="fas fa-solid fa-bell" style="margin-left: 0px"></i></a> <?php echo session('success'); ?>

                </div>
            <?php endif; ?>

            <?php if(Session::has('error')): ?>
                <div class="alert alert-danger">
                    <a href="#" style="background: #0000003d;" class="badge badge-danger">
                        <i class="fas fa-solid fa-bell" style="margin-left: 0px"></i></a> <?php echo session('error'); ?>

                </div>
            <?php endif; ?>

            <?php if(Session::has('warning')): ?>
                <div class="alert alert-warning">
                    <a href="#" style="background: #0000003d;" class="badge badge-warning">
                        <i class="fas fa-solid fa-bell" style="margin-left: 0px"></i></a> <?php echo session('warning'); ?>

                </div>
            <?php endif; ?>

            <?php if(Settings::get('maintenance') == 'true' && Auth::user()->is_admin()): ?>
                <div class="alert alert-warning">
                    <div class="alert-title"><?php echo __('admin.maintenance', ['default' => 'Maintenance']); ?></div>
                    <?php echo __('admin.maintenance_mode_desc', ['default' => 'Maintenance mode is active, you are currently bypassing maintenance mode']); ?>

                    <a href="/admin/settings/store?maintenance=false" class="btn btn-icon icon-left btn-primary ml-2"><i
                            class="fas fa-exclamation-triangle"></i> <?php echo __('admin.maintenance_disable_button', ['default' => 'Disable Maintenance Mode']); ?>

                    </a>
                </div>
            <?php endif; ?>

            <?php if(!Cache::has('cron_active')): ?>
                <div class="alert alert-danger" role="alert">
                    <?php echo __('admin.cronjobs_are_not_running_add_php_artisan_scheduler', ['base_path' => base_path()]); ?>

                </div>
            <?php endif; ?>

            <?php if(config('app.debug') AND config('app.version') != 'dev'): ?>
                <div class="alert alert-warning" role="alert">
                    <?php echo __('admin.disable_debug_mode_immediately_if_your_application', ['base_path' => base_path('.env')]); ?>

                </div>
            <?php endif; ?>
            

            <?php echo $__env->yieldContent('container'); ?>
        </div>

        <footer class="main-footer">
            <div class="footer-left">
                <?php echo e(__('admin.copyright')); ?> &copy; <?php echo e(date('Y')); ?>

                <div class="bullet"></div>
                <?php echo e(__('admin.desing_by')); ?> <a href="">WemX</a>
            </div>
            <div class="footer-right"></div>
        </footer>
    </div>
</div>


<!-- General JS Scripts -->
<script src="<?php echo e(asset(AdminTheme::assets('modules/jquery.min.js'))); ?>"></script>
<script src="<?php echo e(asset(AdminTheme::assets('modules/popper.js'))); ?>"></script>
<script src="<?php echo e(asset(AdminTheme::assets('modules/tooltip.js'))); ?>"></script>
<script src="<?php echo e(asset(AdminTheme::assets('modules/bootstrap/js/bootstrap.min.js'))); ?>"></script>
<script src="<?php echo e(asset(AdminTheme::assets('modules/nicescroll/jquery.nicescroll.min.js'))); ?>"></script>
<script src="<?php echo e(asset(AdminTheme::assets('modules/moment.min.js'))); ?>"></script>
<script src="<?php echo e(asset(AdminTheme::assets('js/stisla.js'))); ?>"></script>

<!-- JS Libraies -->
<?php echo $__env->yieldContent('js_libraries'); ?>

<!-- Page Specific JS File -->


<!-- Template JS File -->
<script src="<?php echo e(asset(AdminTheme::assets('js/scripts.js'))); ?>"></script>
<script src="<?php echo e(asset(AdminTheme::assets('js/custom.js'))); ?>"></script>
<script>

    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl)
    })

    function deleteItem(event) {
        if (window.confirm('<?php echo __('admin.are_you_sure'); ?>')) {
            // Delete item code here
        } else {
            event.preventDefault();
        }
    }

    function confirmAction(event, message) {
        if (window.confirm(message)) {
            // Delete item code here
        } else {
            event.preventDefault();
        }
    }
</script>
</body>

</html>
<?php /**PATH /var/www/wemx/resources/themes/admin/default/layouts/wrapper.blade.php ENDPATH**/ ?>