<?php if(isset($marketplace) and count($marketplace)): ?>
<div class="card">
    <div class="card-header">
        <h4><?php echo __('admin.marketplace'); ?> Beta</h4>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                <tr>
                    <th><?php echo __('admin.name'); ?></th>
                    <th><?php echo __('admin.description'); ?></th>
                    <th><?php echo __('admin.author'); ?></th>
                    <th><?php echo __('admin.version'); ?></th>
                    <th><?php echo __('admin.wemx_version'); ?></th>
                    <th><?php echo __('admin.price'); ?></th>
                    <th class="text-right"><?php echo __('admin.actions'); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php ($install_key = 'install'); ?>
                <?php $__currentLoopData = $marketplace['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resource): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($installedResource = Module::find($resource['real_name'])): ?>
                        <?php ($resource['installed'] = true); ?>
                        <?php ($install_key = 'reinstall'); ?>
                        <?php ($installedResourceConfig = config($installedResource->getLowerName())); ?>
                    <?php else: ?>
                        <?php ($resource['installed'] = false); ?>
                        <?php ($install_key = 'install'); ?>
                    <?php endif; ?>

                    <tr>
                        <td>
                            <img src="<?php echo e($resource['icon'] ?? 'https://imgur.com/koz9j8a.png'); ?>" alt="Icon"
                                 style="width:32px; height:32px;">
                            <?php echo e($resource['name']); ?>

                        </td>

                        <td><?php if(!empty($resource['short_desc'])): ?>
                                <?php echo e($resource['short_desc']); ?>

                            <?php else: ?>
                                <?php echo e($resource['name']); ?>

                            <?php endif; ?></td>
                        <td>
                            <img src="<?php echo e($resource['owner']['avatar'] ?? 'https://imgur.com/koz9j8a.png'); ?>"
                                 alt="Icon" style="width:32px; height:32px;">
                            <?php echo e($resource['owner']['username']); ?>

                        </td>
                        <td><?php echo e($resource['version']); ?></td>
                        <td>
                            <?php $__currentLoopData = $resource['wemx_version']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wemx_version): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($wemx_version); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td><?php if($resource['is_free']): ?>
                                <?php echo __('admin.free'); ?>

                            <?php else: ?>
                                <?php echo e($resource['price']); ?>

                            <?php endif; ?></td>
                        <td class="text-right">
                            <?php if($resource['purchased']): ?>
                                <a href="<?php echo e(route('admin.resource.install', ['resource_id' => $resource['id'], 'version_id' => $resource['version_id']])); ?>"
                                   class="btn btn-primary">
                                    <?php echo __('admin.'.$install_key); ?>

                                </a>
                            <?php endif; ?>
                            <a href="<?php echo e($resource['view_url']); ?>"
                               class="btn btn-success">
                                <?php echo __('admin.view'); ?>

                            </a>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php endif; ?>
<?php /**PATH /var/www/wemx/resources/themes/admin/default/marketplace/resources-card.blade.php ENDPATH**/ ?>