<?php $__env->startSection('css_libraries'); ?>
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
        <div class="row">
            <div class="col-12 col-md-12 col-lg-4">

        <form action="<?php echo e(route('categories.update', ['category' => $category->id])); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

                <div class="card">
                    <div class="card-header">
                        <h4><?php echo __('admin.upload_create_category_icon', ['default' => 'Upload Category Icon']); ?></h4>
                    </div>
                    <div class="card-body">
                        <div class="avatar-item justify-content-center" style="display: flex;">
                            <img alt="image" style="width: 128px;" src="<?php echo e(asset('storage/products/' . $category->icon)); ?>" class="img-fluid" data-toggle="tooltip" title="" data-original-title="<?php echo e($category->icon); ?>">
                          </div>
                        <input type="file" name="icon" class="drop-zone-md" accept="image/*"/>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-12 col-lg-8">
                <div class="card">
                        <div class="card-header">
                            <h4><?php echo __('admin.create_category'); ?></h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-md-12 col-12">
                                    <label for="status">Category Status</label>
                                    <select class="form-control select2 select2-hidden-accessible" name="status"
                                        tabindex="-1" aria-hidden="true">
                                        <option value="active" <?php if($category->status == 'active'): ?> selected <?php endif; ?>>
                                            Active
                                        </option>
                                        <option value="unlisted" <?php if($category->status == 'unlisted'): ?> selected <?php endif; ?>>
                                            Unlisted (only users with direct link can view)
                                        </option>
                                        <option value="restricted" <?php if($category->status == 'restricted'): ?> selected <?php endif; ?>>
                                            Admin Only (only administrators can view)
                                        </option>
                                        <option value="inactive" <?php if($category->status == 'inactive'): ?> selected <?php endif; ?>>
                                            Retired / Inactive (package will not be shown to new customers)
                                        </option>
                                    </select>
                                </div>
                                <div class="form-group col-md-12 col-12">
                                    <label for="name"><?php echo __('admin.name'); ?></label>
                                    <input type="text" name="name" id="name"
                                        class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($category->name); ?>"
                                        required>
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group col-md-12 col-12">
                                    <label for="link"><?php echo __('admin.link'); ?></label>
                                    <div class="input-group-prepend">
                                        <div>
                                            <div class="input-group-text">
                                                <?php echo e(route('store.index')); ?>/
                                            </div>
                                        </div>
                                        <input type="text" name="link" id="link" placeholder="web-hosting" class="form-control <?php $__errorArgs = ['link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($category->link); ?>" required />
                                    <?php $__errorArgs = ['link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="form-group col-md-12 col-12">
                                    <label for="description"><?php echo __('admin.description'); ?></label>
                                    <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="description" id="description"><?php echo e($category->description); ?></textarea>
                                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer text-right">
                            <button class="btn btn-dark" type="submit"><?php echo __('admin.create'); ?></button>
                        </div>
                </div>
            </form>
            </div>
        </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => 'Categories', 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/categories/edit.blade.php ENDPATH**/ ?>