<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'order' => $order,
    'data' => $order->data,
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'order' => $order,
    'data' => $order->data,
]); ?>
<?php foreach (array_filter(([
    'order' => $order,
    'data' => $order->data,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<button type="button"
data-modal-target="renewService-<?php echo e($order->id); ?>"
data-modal-toggle="renewService-<?php echo e($order->id); ?>"
class="focus:outline-none text-white bg-green-700 hover:bg-green-800 focus:ring-4 focus:ring-green-300 font-medium rounded-lg px-3 py-2 text-sm font-medium dark:bg-green-600 dark:hover:bg-green-700 dark:focus:ring-green-800">
<i class='bx bx-recycle font-xl mr-1'></i>
<?php echo __('client.renew'); ?>

</button>

<!-- Main modal -->
<div id="renewService-<?php echo e($order->id); ?>" data-modal-backdrop="static"
    tabindex="-1" aria-hidden="true"
    class="fixed top-0 left-0 right-0 z-50 hidden w-full p-4 overflow-x-hidden overflow-y-auto md:inset-0 h-[calc(100%-1rem)] max-h-full">
    <div class="relative w-full max-w-2xl max-h-full">
        <!-- Modal content -->
        <div class="relative bg-white rounded-lg shadow dark:bg-gray-700">
            <!-- Modal header -->
            <div
                class="flex items-start justify-between p-4 border-b rounded-t dark:border-gray-600">
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                    <?php echo __('client.ptero_renew_plan'); ?>

                </h3>
                <button type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white"
                    data-modal-hide="renewService-<?php echo e($order->id); ?>">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"
                        xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                </button>
            </div>
            <!-- Modal body -->
            <div class="p-6 space-y-6">
                <div class="mb-4 text-sm text-gray-800 dark:text-gray-300">
                    <?php echo __('client.ptero_renew_desc', ['due_date' => $order->due_date->translatedFormat('d M Y'), 'due_date_diff' => $order->due_date->diffForHumans(), 'period' => $order->period()]); ?>

                </div>
                <form action="<?php echo e(route('service', ['order' => $order->id, 'page' => 'renew'])); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <label for="default" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white"><?php echo __('client.renew_for'); ?></label>
                    <select id="default" name="frequency" class="bg-gray-50 border border-gray-300 text-gray-900 mb-6 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                      <?php $__currentLoopData = range(1, 12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if($value == 1): ?> selected <?php endif; ?>><?php echo e($value); ?> <?php echo e(ucfirst($order->period())); ?> - <?php echo e(currency('symbol')); ?><?php echo e(number_format($value * $order->price['renewal_price'], 2)); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
            </div>
            <!-- Modal footer -->
            <div
                class="flex items-center p-6 space-x-2 border-t border-gray-200 rounded-b dark:border-gray-600">
                <button data-modal-hide="renewService-<?php echo e($order->id); ?>"
                    type="button"
                    class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-500 dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-gray-600"><?php echo __('client.cancel'); ?></button>
                    <button data-modal-hide="renewService-<?php echo e($order->id); ?>"
                        type="submit"
                        class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800"><?php echo __('client.create_invoice'); ?></button>
            </div>
        </form>
        </div>
    </div>
</div>
<?php /**PATH /var/www/wemx/resources/themes/client/tailwind/components/orders/renew-modal.blade.php ENDPATH**/ ?>