<!doctype html>
<html class="no-js" lang="">

<head>
    <meta charset="utf-8">
    <title><?php echo e(__('client.invoice_template')); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body>

<div class="web-container">

    <div class="page-container">
        <?php echo e(__('client.page')); ?>

        <span class="page"></span>
        <?php echo e(__('client.of')); ?>

        <span class="pages"></span>
    </div>

    <table style="width:100%; margin-bottom: 30px;">
        <tr>
            <td style="text-align:center; vertical-align:middle;">
            <span style="
                width: 128px;
                height: 40px;
                background-color: <?php if($payment->status == 'unpaid'): ?> #bf3a3a <?php else: ?> #237142 <?php endif; ?>;
                color: <?php if($payment->status == 'unpaid'): ?> #ffffff <?php else: ?> #86efac <?php endif; ?>;
                display: block;
                border-radius: 5px;
                font-size: 26px;
                text-transform: capitalize;
                line-height: 40px;
                padding-bottom: 5px;
                font-weight: 600;
            ">
                <?php echo e(__('client.'.$payment->status)); ?>

            </span>
            </td>
            <td style="vertical-align:end;">
                <img style="width: 48px; border-radius: 5px;" src="<?php echo App\Models\Settings::get('logo', 'https://dev2.wemx.net/static/wemx.png', ); ?>">
            </td>
        </tr>
    </table>


    <table class="invoice-info-container">
        <tr>
            <td rowspan="2" class="client-name">
                <?php echo e($payment->user->first_name); ?> <?php echo e($payment->user->last_name); ?>

            </td>
            <td>
                <?php echo App\Models\Settings::get('app_name', ); ?>
            </td>
        </tr>
        <tr>
            <td>
                <?php echo App\Models\Settings::get('company_address', '291 N 4th St, San Jose, CA 95112, USA', ); ?>
            </td>
        </tr>
        <tr>
            <td>
                <?php echo e(__('client.invoice_date')); ?>: <strong><?php echo e($payment->created_at->translatedFormat(settings('date_format', 'd M Y'))); ?></strong>
            </td>
            <td>

            </td>
        </tr>
        <tr>
            <td>
                <?php echo e($payment->user->email); ?>

            </td>
            <td>
                <?php echo e(__('client.invoice_no')); ?>: <strong><?php echo e($payment->shortId()); ?></strong>
            </td>
        </tr>
    </table>


    <table class="line-items-container">
        <thead>
        <tr>
            <th class="heading-quantity"><?php echo __('client.qty'); ?></th>
            <th class="heading-description"><?php echo __('client.item'); ?></th>
            <th class="heading-price"><?php echo __('client.price'); ?></th>
            <th class="heading-subtotal"><?php echo __('client.total'); ?></th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td>1</td>
            <td>
                <?php if($payment->package_id !== NULL): ?>
                    <img style="display: inline-block; vertical-align: middle; width: 24px; border-radius: 5px; margin-right: 5px" src="<?php echo e($payment->package->icon()); ?>" alt="<?php echo e(__('client.package_icon')); ?>">
                <?php endif; ?>
                <span style="display: inline-block; vertical-align: middle;"><?php echo e($payment->description); ?></span>
            </td>
            <td class="right"><?php echo e(currency('symbol')); ?><?php echo e(number_format($payment->amount, 2)); ?></td>
            <td class="bold"><?php echo e(currency('symbol')); ?><?php echo e(number_format($payment->amount, 2)); ?></td>
        </tr>
        </tbody>
    </table>


    <table class="line-items-container has-bottom-border">
        <thead>
        <tr>
            <th><?php echo e(__('client.payment_info')); ?></th>
            <th><?php echo e(__('client.total_due')); ?></th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td class="payment-info">
                <div>
                    <?php if(isset($payment->gateway['name'])): ?> <?php echo e(__('client.payment_gateway')); ?>: <strong><?php echo e($payment->gateway['name']); ?></strong> <?php endif; ?>
                </div>
                <div>
                    <?php if($payment->transaction_id !== NULL): ?>
                        <?php echo e(__('client.transaction_id')); ?>: <strong><?php echo e($payment->transaction_id); ?></strong>
                    <?php endif; ?>
                </div>
            </td>
            <td class="large total"><?php echo e(currency('symbol')); ?><?php echo e(number_format($payment->amount, 2)); ?></td>
        </tr>
        </tbody>
    </table>

    <div class="footer">
        <div class="footer-info">
            <span><?php echo App\Models\Settings::get('contact_email', ); ?></span> |
            <span><?php echo App\Models\Settings::get('app_name', ); ?></span>
        </div>
        <div class="footer-thanks">
            <span><?php echo e(__('client.thank_you')); ?></span>
        </div>
    </div>

</div>

</body>
</html>

<style>
    /*
      Common invoice styles. These styles will work in a browser or using the HTML
      to PDF anvil endpoint.
    */

    body {
        font-size: 16px;
        font-family: sans-serif;
    }

    table {
        width: 100%;
        border-collapse: collapse;
    }

    table tr td {
        padding: 0;
    }

    table tr td:last-child {
        text-align: right;
    }

    .bold {
        font-weight: bold;
    }

    .right {
        text-align: right;
    }

    .large {
        font-size: 1.75em;
    }

    .total {
        font-weight: bold;
    }

    .logo-container {
        margin: 20px 0 30px 0;
    }

    .invoice-info-container {
        font-size: 0.875em;
    }
    .invoice-info-container td {
        padding: 4px 0;
    }

    .client-name {
        font-size: 1.5em;
        vertical-align: top;
    }

    .line-items-container {
        margin: 70px 0;
        font-size: 0.875em;
    }

    .line-items-container th {
        text-align: left;
        color: #999;
        border-bottom: 2px solid #ddd;
        padding: 10px 0 15px 0;
        font-size: 0.75em;
        text-transform: uppercase;
    }

    .line-items-container th:last-child {
        text-align: right;
    }

    .line-items-container td {
        padding: 15px 0;
    }

    .line-items-container tbody tr:first-child td {
        padding-top: 25px;
    }

    .line-items-container.has-bottom-border tbody tr:last-child td {
        padding-bottom: 25px;
        border-bottom: 2px solid #ddd;
    }

    .line-items-container.has-bottom-border {
        margin-bottom: 0;
    }

    .line-items-container th.heading-quantity {
        width: 50px;
    }
    .line-items-container th.heading-price {
        text-align: right;
        width: 100px;
    }
    .line-items-container th.heading-subtotal {
        width: 100px;
    }

    .payment-info {
        width: 38%;
        font-size: 0.75em;
        line-height: 1.5;
    }

    .footer {
        margin-top: 100px;
    }

    .footer-thanks {
        font-size: 1.125em;
    }

    .footer-thanks img {
        display: inline-block;
        position: relative;
        top: 1px;
        width: 16px;
        margin-right: 4px;
    }

    .footer-info {
        float: right;
        margin-top: 5px;
        font-size: 0.75em;
        color: #ccc;
    }

    .footer-info span {
        padding: 0 5px;
        color: black;
    }

    .footer-info span:last-child {
        padding-right: 0;
    }

    .page-container {
        display: none;
    }
</style>
<?php /**PATH /var/www/wemx/resources/themes/client/tailwind/invoice-pdf.blade.php ENDPATH**/ ?>