<?php $__env->startSection('container'); ?>
    <section class="section">
        <div class="section-body">
            <div class="col-12 col-md-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4><?php echo e(__('affiliates::general.affiliates')); ?></h4>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-striped table-md">
                                <tbody>
                                <tr>
                                    <th><?php echo __('admin.code'); ?></th>
                                    <th><?php echo __('admin.user'); ?></th>
                                    <th><?php echo __('admin.balance'); ?></th>
                                    <th><?php echo __('admin.clicks'); ?></th>
                                    <th><?php echo __('admin.create_at'); ?></th>
                                    <th class="text-right"><?php echo __('admin.actions'); ?></th>
                                </tr>

                                <?php $__currentLoopData = $affiliates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $affiliate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($affiliate->code); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('users.edit', ['user' => $affiliate->user->id])); ?>"
                                               style="display: flex; color: #6c757d">
                                                <img alt="<?php echo _('image'); ?>" src="<?php echo e($affiliate->user->avatar()); ?>"
                                                     class="rounded-circle mr-1 mt-1" width="32px" height="32px"
                                                     data-toggle="tooltip" title=""
                                                     data-original-title="<?php echo e($affiliate->user->first_name); ?> <?php echo e($affiliate->user->last_name); ?>">
                                                <div class="flex">
                                                    <?php echo e($affiliate->user->username); ?> <br>
                                                    <small><?php echo e($affiliate->user->email); ?></small>
                                                </div>
                                            </a>
                                        </td>

                                        <td><?php echo e(currency('symbol')); ?><?php echo e(number_format($affiliate->balance, 2)); ?></td>

                                        <td><?php echo e($affiliate->clicks); ?> <?php echo e(__('affiliates::general.clicks')); ?></td>

                                        <td><?php echo e($affiliate->created_at->translatedFormat(settings('date_format', 'd M Y'))); ?></td>

                                        <td class="text-right">
                                            <a href="<?php echo e(route('affiliates.edit', ['affiliate' => $affiliate->id])); ?>"
                                               class="btn btn-primary"><?php echo __('admin.manage'); ?>

                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer text-right">
                        <?php echo e($affiliates->links(AdminTheme::pagination())); ?>

                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.payments'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/Modules/Affiliates/Resources/views/admin/default/affiliates.blade.php ENDPATH**/ ?>