<?php $__env->startSection('content'); ?>
<div>
    <!-- Button trigger modal -->
    <button type="button" class="btn btn-primary mt-4 mb-4" data-toggle="modal"
            data-target="#createWebhook">
        <?php echo e(__('admin.create')); ?>

    </button>

    <div class="alert alert-info alert-dismissible fade show" role="alert">
        Package webhooks are a powerful feature allowing you to do a huge amount of things. You
        can also use custom variables inside webhooks. <a
            href="https://docs.wemx.net/en/setup/packages#package-webhooks" target="_blank">Learn
            More</a>
    </div>

    <?php if($package->webhooks->count() == 0): ?>
        <?php echo $__env->make(AdminTheme::path('empty-state'), [
            'title' => 'No webhooks found',
            'description' => 'You haven\'t created any webhooks for this package',
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <!-- Create Webhook Modal -->
    <div class="modal fade bd-example-modal-lg" id="createWebhook" tabindex="-1" role="dialog"
         aria-labelledby="createWebhookLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createWebhookLabel"><?php echo e(__('admin.webhook_event')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('admin.close')); ?>">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('packages.webhooks.create', $package->id)); ?>"
                      method="POST" enctype="multipart/form-data">
                    <div class="modal-body">
                        <?php echo csrf_field(); ?>
                        <div class="mb-4">
                            <label for="event"><?php echo e(__('admin.event')); ?></label>
                            <select class="form-control select2 select2-hidden-accessible"
                                    name="event"
                                    tabindex="-1" aria-hidden="true">
                                <option value="creation">
                                    <?php echo e(__('admin.creation')); ?>

                                </option>
                                <option value="renewal">
                                    <?php echo e(__('admin.renewal')); ?>

                                </option>
                                <option value="upgrade">
                                    <?php echo e(__('admin.upgrade')); ?>

                                </option>
                                <option value="suspension">
                                    <?php echo e(__('admin.suspension')); ?>

                                </option>
                                <option value="unsuspension">
                                    <?php echo e(__('admin.unsuspension')); ?>

                                </option>
                                <option value="cancellation">
                                    <?php echo e(__('admin.cancellation')); ?>

                                </option>
                                <option value="termination">
                                    <?php echo e(__('admin.termination')); ?>

                                </option>
                            </select>
                        </div>

                        <div class="mb-4">
                            <label for="method"><?php echo e(__('admin.method')); ?></label>
                            <select class="form-control select2 select2-hidden-accessible"
                                    name="method"
                                    tabindex="-1" aria-hidden="true">

                                <?php $__currentLoopData = ['get', 'post', 'put', 'patch', 'delete', 'head']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($method); ?>"
                                            style="text-transform: uppsercase">
                                        <?php echo e(strtoupper($method)); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                        </div>

                        <div class="mb-4">
                            <label for="url"><?php echo e(__('admin.url')); ?></label>
                            <input type="url" name="url" id="url"
                                   placeholder="https://example.com/api/v1"
                                   class="form-control" required=""/>
                        </div>

                        <div class="mb-4">
                            <label for="data"><?php echo e(__('admin.data')); ?></label>
                            <textarea class="form-control" name="data" id="data"
                                      placeholder='{"key": "value"}'
                                      style="height: 200px !important"></textarea>
                            <small class="form-text text-muted"></small>
                        </div>

                        <div class="mb-4">
                            <label for="headers"><?php echo e(__('admin.headers')); ?></label>
                            <textarea class="form-control" name="headers" id="headers"
                                      placeholder='{"Authorization": "Bearer apikey"}'></textarea>
                            <small class="form-text text-muted"></small>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            <?php echo e(__('admin.close')); ?>

                        </button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('admin.create')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-striped table-md">
                <tbody>
                <?php if($package->webhooks->count() > 0): ?>
                    <tr>
                        <th><?php echo e(__('admin.event')); ?></th>
                        <th><?php echo e(__('admin.method')); ?></th>
                        <th class="text-right"><?php echo e(__('admin.last_updated')); ?></th>
                        <th class="text-right"><?php echo e(__('admin.action')); ?></th>
                    </tr>
                <?php endif; ?>
                <?php $__currentLoopData = $package->webhooks->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $webhook): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($webhook->event); ?></td>
                        <td><?php echo e($webhook->method); ?></td>
                        <td class="text-right"><?php echo e($webhook->updated_at->diffForHumans()); ?></td>
                        <td class="text-right">
                            <a href="<?php echo e(route('packages.webhooks.delete', ['webhook' => $webhook->id])); ?>"
                               class="btn btn-icon btn-danger"><i class="fas fa-trash-alt"></i></a>
                            <button data-toggle="modal"
                                    data-target="#editWebhook<?php echo e($webhook->id); ?>"
                                    class="btn btn-primary"><?php echo e(__('admin.manage')); ?>

                            </button>
                        </td>
                    </tr>

                    <!-- Create Email Modal -->
                    <div class="modal fade bd-example-modal-lg" id="editWebhook<?php echo e($webhook->id); ?>"
                         tabindex="-1" role="dialog"
                         aria-labelledby="editWebhook<?php echo e($webhook->id); ?>Label" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title"
                                        id="editWebhook<?php echo e($webhook->id); ?>Label"><?php echo e(__('admin.webhook_event')); ?></h5>
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-label="<?php echo e(__('admin.close')); ?>">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <form
                                    action="<?php echo e(route('packages.webhooks.update', ['webhook' => $webhook->id])); ?>"
                                    method="POST" enctype="multipart/form-data">
                                    <div class="modal-body">
                                        <?php echo csrf_field(); ?>
                                        <div class="mb-4">
                                            <label for="event"><?php echo e(__('admin.event')); ?></label>
                                            <select
                                                class="form-control select2 select2-hidden-accessible"
                                                name="event"
                                                tabindex="-1" aria-hidden="true">
                                                <option value="creation"
                                                        <?php if($webhook->event == 'creation'): ?> selected <?php endif; ?>>
                                                    <?php echo e(__('admin.creation')); ?>

                                                </option>
                                                <option value="renewal"
                                                        <?php if($webhook->event == 'renewal'): ?> selected <?php endif; ?>>
                                                    <?php echo e(__('admin.renewal')); ?>

                                                </option>
                                                <option value="upgrade"
                                                        <?php if($webhook->event == 'upgrade'): ?> selected <?php endif; ?>>
                                                    <?php echo e(__('admin.upgrade')); ?>

                                                </option>
                                                <option value="suspension"
                                                        <?php if($webhook->event == 'suspension'): ?> selected <?php endif; ?>>
                                                    <?php echo e(__('admin.suspension')); ?>

                                                </option>
                                                <option value="unsuspension"
                                                        <?php if($webhook->event == 'unsuspension'): ?> selected <?php endif; ?>>
                                                    <?php echo e(__('admin.unsuspension')); ?>

                                                </option>
                                                <option value="cancellation"
                                                        <?php if($webhook->event == 'cancellation'): ?> selected <?php endif; ?>>
                                                    <?php echo e(__('admin.cancellation')); ?>

                                                </option>
                                                <option value="termination"
                                                        <?php if($webhook->event == 'termination'): ?> selected <?php endif; ?>>
                                                    <?php echo e(__('admin.termination')); ?>

                                                </option>
                                            </select>
                                        </div>

                                        <div class="mb-4">
                                            <label for="method"><?php echo e(__('admin.method')); ?></label>
                                            <select
                                                class="form-control select2 select2-hidden-accessible"
                                                name="method"
                                                tabindex="-1" aria-hidden="true">

                                                <?php $__currentLoopData = ['get', 'post', 'put', 'patch', 'delete', 'head']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($method); ?>"
                                                            style="text-transform: uppsercase"
                                                            <?php if($webhook->method == $method): ?> selected <?php endif; ?>>
                                                        <?php echo e(strtoupper($method)); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </select>
                                        </div>

                                        <div class="mb-4">
                                            <label for="url"><?php echo e(__('admin.url')); ?></label>
                                            <input type="url" name="url" id="url"
                                                   placeholder="https://example.com/api/v1"
                                                   class="form-control"
                                                   value="<?php echo e($webhook->url); ?>" required=""/>
                                        </div>

                                        <div class="mb-4">
                                            <label for="data"><?php echo e(__('admin.data')); ?></label>
                                            <textarea class="form-control" name="data" id="data"
                                                      placeholder='{"key": "value"}'
                                                      style="height: 200px !important"><?php echo e(json_encode($webhook->data, JSON_PRETTY_PRINT)); ?></textarea>
                                            <small class="form-text text-muted"></small>
                                        </div>

                                        <div class="mb-4">
                                            <label for="headers"><?php echo e(__('admin.headers')); ?></label>
                                            <textarea class="form-control" name="headers"
                                                      id="headers"
                                                      placeholder='{"Authorization": "Bearer apikey"}'><?php echo e(json_encode($webhook->headers, JSON_PRETTY_PRINT)); ?></textarea>
                                            <small class="form-text text-muted"></small>
                                        </div>

                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary"
                                                data-dismiss="modal"><?php echo e(__('admin.close')); ?>

                                        </button>
                                        <button type="submit" class="btn btn-primary"><?php echo e(__('admin.update')); ?>

                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make(AdminTheme::path('packages/edit/master'), ['title' => 'Package Webhooks', 'tab' => 'webhooks'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/packages/edit/webhooks.blade.php ENDPATH**/ ?>