<?php $__env->startSection('css_libraries'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header"><?php echo __('admin.locations'); ?></div>

                <div class="card-body">
                    <button type="button" class="btn btn-primary" data-toggle="modal"
                            data-target="#createLocationModal"><i
                            class="fas fa-solid fa-plus"></i> <?php echo __('client.create_location'); ?></button>
                    <hr>
                    <?php if($locations->count() == 0): ?>
                        <?php echo $__env->make(AdminTheme::path('empty-state'), ['title' => 'We couldn\'t find any categories', 'description' => 'You haven\'t created any categories yet.'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <table class="table">
                            <thead>
                            <tr>
                                <th><?php echo __('admin.id'); ?></th>
                                <th><?php echo __('admin.name'); ?></th>
                                <th><?php echo __('admin.country'); ?></th>
                                <th><?php echo __('admin.stock'); ?></th>
                                <th><?php echo __('admin.pterodactyl_id', ['default' => 'Pterodactyl ID']); ?></th>
                                <th class="text-right"><?php echo __('admin.actions'); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>#<?php echo e($location->id); ?></td>
                                    <td><?php echo e($location->name); ?></td>
                                    <td><?php echo e($location->country_code); ?></td>
                                    <td><?php echo e($location->inStock()); ?> (<?php echo e($location->stock); ?>)</td>
                                    <td><?php echo e($location->location_id); ?></td>
                                    <td class="text-right">
                                        <button type="button" class="btn btn-primary" data-toggle="modal"
                                                data-target="#editLocationModal<?php echo e($location->id); ?>">
                                            <?php echo __('admin.edit'); ?>

                                        </button>
                                    </td>
                                </tr>

                                <!-- Edit Modal -->
                                <div class="modal fade" id="editLocationModal<?php echo e($location->id); ?>" tabindex="-1"
                                     role="dialog" aria-labelledby="editLocationModalLabel<?php echo e($location->id); ?>"
                                     aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="editLocationModalLabel<?php echo e($location->id); ?>">
                                                    Edit Location #<?php echo e($location->id); ?></h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <form
                                                action="<?php echo e(route('pterodactyl.locations.update', ['location' => $location->id])); ?>"
                                                method="POST">
                                                <?php echo csrf_field(); ?>
                                                <div class="modal-body">
                                                    <div class="form-group col-md-12 col-12">
                                                        <label><?php echo __('admin.display_name'); ?></label>
                                                        <input type="text" class="form-control" name="name"
                                                               value="<?php echo e($location->name); ?>" required/>
                                                        <small class="form-text text-muted">
                                                            <?php echo __('admin.ptero_display_name_desc'); ?>

                                                        </small>
                                                    </div>

                                                    <div class="form-group col-md-12 col-12">
                                                        <label for="country_code"><?php echo __('admin.country'); ?></label>
                                                        <select class="form-control select2 select2-hidden-accessible"
                                                                name="country_code" tabindex="-1" aria-hidden="true">
                                                            <?php $__currentLoopData = config('utils.countries'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($key); ?>"
                                                                        <?php if($location->country_code == $key): ?> selected <?php endif; ?>><?php echo e($country); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                        <small class="form-text text-muted">
                                                            <?php echo __('admin.field_not_displayed_user'); ?>

                                                        </small>
                                                    </div>

                                                    <div class="form-group col-md-12 col-12">
                                                        <label for="location_id"><?php echo __('admin.pterodactyl_location'); ?></label>
                                                        <select class="form-control select2 select2-hidden-accessible"
                                                                name="location_id" tabindex="-1" aria-hidden="true">
                                                            <?php $__currentLoopData = $pterodactyl_locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pterodactyl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($pterodactyl['attributes']['id']); ?>"
                                                                        <?php if($location->location_id == $pterodactyl['attributes']['id']): ?> selected <?php endif; ?>><?php echo e($pterodactyl['attributes']['short']); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                        <small class="form-text text-muted">
                                                            <?php echo __('admin.pterodactyl_location_desc'); ?></small>
                                                    </div>

                                                    <div class="form-group col-md-12 col-12">
                                                        <label><?php echo __('admin.stock'); ?></label>
                                                        <input type="number" class="form-control" name="stock"
                                                               value="<?php echo e($location->stock); ?>" required/>
                                                        <small class="form-text text-muted">
                                                            <?php echo __('admin.ptero_stock_desc'); ?></small>
                                                    </div>

                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                            data-dismiss="modal"><?php echo __('admin.close'); ?>

                                                    </button>
                                                    <button type="submit" class="btn btn-primary"><?php echo __('admin.update_location'); ?>

                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            </tbody>
                        </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Create Modal -->
    <div class="modal fade" id="createLocationModal" tabindex="-1" role="dialog"
         aria-labelledby="createLocationModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createLocationModalLabel"><?php echo __('admin.create_location'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('pterodactyl.locations.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group col-md-12 col-12">
                            <label><?php echo __('admin.display_name'); ?></label>
                            <input type="text" class="form-control" name="name" placeholder="London, UK" required/>
                            <small class="form-text text-muted"><?php echo __('admin.ptero_display_name_desc'); ?></small>
                        </div>

                        <div class="form-group col-md-12 col-12">
                            <label for="country_code"><?php echo __('admin.country'); ?></label>
                            <select class="form-control select2 select2-hidden-accessible" name="country_code"
                                    tabindex="-1" aria-hidden="true">
                                <?php $__currentLoopData = config('utils.countries'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>"><?php echo e($country); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <small class="form-text text-muted"><?php echo __('admin.field_not_displayed_user'); ?></small>
                        </div>

                        <div class="form-group col-md-12 col-12">
                            <label for="user"><?php echo __('admin.pterodactyl_location'); ?></label>
                            <select class="form-control select2 select2-hidden-accessible" name="location_id"
                                    tabindex="-1" aria-hidden="true">
                                <?php $__currentLoopData = $pterodactyl_locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pterodactyl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option
                                        value="<?php echo e($pterodactyl['attributes']['id']); ?>"><?php echo e($pterodactyl['attributes']['short']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <small class="form-text text-muted"><?php echo __('admin.pterodactyl_location_desc'); ?></small>
                            </select>
                        </div>

                        <div class="form-group col-md-12 col-12">
                            <label><?php echo __('admin.stock'); ?></label>
                            <input type="number" class="form-control" name="stock" value="-1" required/>
                            <small class="form-text text-muted"><?php echo __('admin.ptero_stock_desc'); ?></small>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo __('admin.close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo __('admin.create_location'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.locations'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/app/Services/Pterodactyl/Resources/views/admin/default/locations.blade.php ENDPATH**/ ?>