<?php $__env->startSection('css_libraries'); ?>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(Theme::get('Default')->assets); ?>assets/modules/jquery.sparkline.min.js"></script>
    <script src="<?php echo e(Theme::get('Default')->assets); ?>assets/modules/chart.min.js"></script>

    <script>
        "use strict";

        var ctx = document.getElementById("myChart").getContext('2d');
        var myChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: <?php echo json_encode($paid_dates, 15, 512) ?>,
                datasets: [{
                    label: 'Unpaid Payments',
                    data: <?php echo json_encode($unpaid_amounts, 15, 512) ?>,
                    borderWidth: 2,
                    backgroundColor: 'rgba(63,82,227,.8)',
                    borderWidth: 0,
                    borderColor: 'transparent',
                    pointBorderWidth: 0,
                    pointRadius: 3.5,
                    pointBackgroundColor: 'transparent',
                    pointHoverBackgroundColor: 'rgba(63,82,227,.8)',
                },
                    {
                        label: 'Paid Payments',
                        data: <?php echo json_encode($paid_amounts, 15, 512) ?>,
                        borderWidth: 2,
                        backgroundColor: 'rgba(254,86,83,.7)',
                        borderWidth: 0,
                        borderColor: 'transparent',
                        pointBorderWidth: 0,
                        pointRadius: 3.5,
                        pointBackgroundColor: 'transparent',
                        pointHoverBackgroundColor: 'rgba(254,86,83,.8)',
                    }]
            },
            options: {
                legend: {
                    display: false
                },
                scales: {
                    yAxes: [{
                        gridLines: {
                            // display: false,
                            drawBorder: false,
                            color: '#f2f2f2',
                        },
                        ticks: {
                            beginAtZero: true,
                            stepSize: <?php echo e(collect($unpaid_amounts)->sum()); ?>,
                            callback: function (value, index, values) {
                                return '<?php echo e(currency('symbol')); ?>' + parseFloat(value).toFixed(1);
                            }
                        }
                    }],
                    xAxes: [{
                        gridLines: {
                            display: false,
                            tickMarkLength: 15,
                        }
                    }]
                },
            }
        });

        var balance_chart = document.getElementById("balance-chart").getContext('2d');

        var balance_chart_bg_color = balance_chart.createLinearGradient(0, 0, 0, 70);
        balance_chart_bg_color.addColorStop(0, 'rgba(63,82,227,.2)');
        balance_chart_bg_color.addColorStop(1, 'rgba(63,82,227,0)');

        var myChart = new Chart(balance_chart, {
            type: 'line',
            data: {
                labels: <?php echo json_encode($paid_dates, 15, 512) ?>,
                datasets: [{
                    label: 'Balance',
                    data: <?php echo json_encode($paid_amounts, 15, 512) ?>,
                    backgroundColor: balance_chart_bg_color,
                    borderWidth: 3,
                    borderColor: 'rgba(63,82,227,1)',
                    pointBorderWidth: 0,
                    pointBorderColor: 'transparent',
                    pointRadius: 3,
                    pointBackgroundColor: 'transparent',
                    pointHoverBackgroundColor: 'rgba(63,82,227,1)',
                }]
            },
            options: {
                layout: {
                    padding: {
                        bottom: -1,
                        left: -1
                    }
                },
                legend: {
                    display: false
                },
                scales: {
                    yAxes: [{
                        gridLines: {
                            display: false,
                            drawBorder: false,
                        },
                        ticks: {
                            beginAtZero: true,
                            display: false
                        }
                    }],
                    xAxes: [{
                        gridLines: {
                            drawBorder: false,
                            display: false,
                        },
                        ticks: {
                            display: false
                        }
                    }]
                },
            }
        });

        var subscription_chart = document.getElementById("subscription-chart").getContext('2d');

        var subscription_chart_bg_color = subscription_chart.createLinearGradient(0, 0, 0, 70);
        subscription_chart_bg_color.addColorStop(0, 'rgba(63,82,227,.2)');
        subscription_chart_bg_color.addColorStop(1, 'rgba(63,82,227,0)');

        var myChart = new Chart(subscription_chart, {
            type: 'line',
            data: {
                labels: <?php echo json_encode($paid_dates_sub, 15, 512) ?>,
                datasets: [{
                    label: 'Subscriptions',
                    data: <?php echo json_encode($paid_amounts_sub, 15, 512) ?>,
                    backgroundColor: subscription_chart_bg_color,
                    borderWidth: 3,
                    borderColor: 'rgba(63,82,227,1)',
                    pointBorderWidth: 0,
                    pointBorderColor: 'transparent',
                    pointRadius: 3,
                    pointBackgroundColor: 'transparent',
                    pointHoverBackgroundColor: 'rgba(63,82,227,1)',
                }]
            },
            options: {
                layout: {
                    padding: {
                        bottom: -1,
                        left: -1
                    }
                },
                legend: {
                    display: false
                },
                scales: {
                    yAxes: [{
                        gridLines: {
                            display: false,
                            drawBorder: false,
                        },
                        ticks: {
                            beginAtZero: true,
                            display: false
                        }
                    }],
                    xAxes: [{
                        gridLines: {
                            drawBorder: false,
                            display: false,
                        },
                        ticks: {
                            display: false
                        }
                    }]
                },
            }
        });

        var sales_chart = document.getElementById("sales-chart").getContext('2d');

        var sales_chart_bg_color = sales_chart.createLinearGradient(0, 0, 0, 80);
        balance_chart_bg_color.addColorStop(0, 'rgba(63,82,227,.2)');
        balance_chart_bg_color.addColorStop(1, 'rgba(63,82,227,0)');

        var myChart = new Chart(sales_chart, {
            type: 'line',
            data: {
                labels: <?php echo json_encode($registration_dates, 15, 512) ?>,
                datasets: [{
                    label: 'users',
                    data: <?php echo json_encode($registration_counts, 15, 512) ?>,
                    borderWidth: 2,
                    backgroundColor: balance_chart_bg_color,
                    borderWidth: 3,
                    borderColor: 'rgba(63,82,227,1)',
                    pointBorderWidth: 0,
                    pointBorderColor: 'transparent',
                    pointRadius: 3,
                    pointBackgroundColor: 'transparent',
                    pointHoverBackgroundColor: 'rgba(63,82,227,1)',
                }]
            },
            options: {
                layout: {
                    padding: {
                        bottom: -1,
                        left: -1
                    }
                },
                legend: {
                    display: false
                },
                scales: {
                    yAxes: [{
                        gridLines: {
                            display: false,
                            drawBorder: false,
                        },
                        ticks: {
                            beginAtZero: true,
                            display: false
                        }
                    }],
                    xAxes: [{
                        gridLines: {
                            drawBorder: false,
                            display: false,
                        },
                        ticks: {
                            display: false
                        }
                    }]
                },
            }
        });

        $("#products-carousel").owlCarousel({
            items: 3,
            margin: 10,
            autoplay: true,
            autoplayTimeout: 5000,
            loop: true,
            responsive: {
                0: {
                    items: 2
                },
                768: {
                    items: 2
                },
                1200: {
                    items: 3
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <section class="section">
        <div class="row">
            <div class="col-lg-3 col-md-3 col-sm-12">
                <div class="card card-statistic-2">
                    <div class="card-stats">
                        <div class="card-stats-title"><?php echo __('admin.orders', ['default' => 'Orders']); ?>

                        </div>
                        <div class="card-stats-items">
                            <div class="card-stats-item">
                                <div class="card-stats-item-count"><?php echo e(Order::whereStatus('cancelled')->count()); ?></div>
                                <div
                                    class="card-stats-item-label"><?php echo __('admin.orders_cancelled', ['default' => 'Cancelled']); ?></div>
                            </div>
                            <div class="card-stats-item">
                                <div class="card-stats-item-count"><?php echo e(Order::whereStatus('suspended')->count()); ?></div>
                                <div
                                    class="card-stats-item-label"><?php echo __('admin.orders_suspended', ['default' => 'Suspended']); ?></div>
                            </div>
                            <div class="card-stats-item">
                                <div class="card-stats-item-count"><?php echo e(Order::whereStatus('terminated')->count()); ?></div>
                                <div
                                    class="card-stats-item-label"><?php echo __('admin.orders_terminated', ['default' => 'Terminated']); ?></div>
                            </div>
                        </div>
                    </div>
                    <div class="card-icon shadow-primary bg-primary">
                        <i class="fas fa-archive"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?php echo __('admin.orders_total_active', ['default' => 'Total Active Orders']); ?></h4>
                        </div>
                        <div class="card-body">
                            <?php echo e(Order::whereStatus('active')->count()); ?>

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-12">
                <div class="card card-statistic-2">
                    <div class="card-chart">
                        <div class="chartjs-size-monitor"
                             style="position: absolute; inset: 0px; overflow: hidden; pointer-events: none; visibility: hidden; z-index: -1;">
                            <div class="chartjs-size-monitor-expand"
                                 style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:1000000px;height:1000000px;left:0;top:0"></div>
                            </div>
                            <div class="chartjs-size-monitor-shrink"
                                 style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:200%;height:200%;left:0; top:0"></div>
                            </div>
                        </div>
                        <canvas id="balance-chart" height="80" width="339"
                                style="display: block; width: 339px; height: 80px;"
                                class="chartjs-render-monitor"></canvas>
                    </div>
                    <div class="card-icon shadow-primary bg-primary">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?php echo __('admin.revenue'); ?></h4>
                        </div>
                        <div class="card-body">
                            <?php echo e(currency('symbol')); ?><?php echo e(number_format(collect($paid_amounts)->sum(), 2)); ?>

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-12">
                <div class="card card-statistic-2">
                    <div class="card-chart">
                        <div class="chartjs-size-monitor"
                             style="position: absolute; inset: 0px; overflow: hidden; pointer-events: none; visibility: hidden; z-index: -1;">
                            <div class="chartjs-size-monitor-expand"
                                 style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:1000000px;height:1000000px;left:0;top:0"></div>
                            </div>
                            <div class="chartjs-size-monitor-shrink"
                                 style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:200%;height:200%;left:0; top:0"></div>
                            </div>
                        </div>
                        <canvas id="subscription-chart" height="80" width="339"
                                style="display: block; width: 339px; height: 80px;"
                                class="chartjs-render-monitor"></canvas>
                    </div>
                    <div class="card-icon shadow-primary bg-primary">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?php echo __('client.subscription'); ?></h4>
                        </div>
                        <div class="card-body">
                            <?php echo e(currency('symbol')); ?><?php echo e($incomeSubscriptions); ?> / <?php echo e(request()->input('period', 30)); ?> <?php echo __('admin.days'); ?>

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-12">
                <div class="card card-statistic-2">
                    <div class="card-chart">
                        <div class="chartjs-size-monitor"
                             style="position: absolute; inset: 0px; overflow: hidden; pointer-events: none; visibility: hidden; z-index: -1;">
                            <div class="chartjs-size-monitor-expand"
                                 style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:1000000px;height:1000000px;left:0;top:0"></div>
                            </div>
                            <div class="chartjs-size-monitor-shrink"
                                 style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:200%;height:200%;left:0; top:0"></div>
                            </div>
                        </div>
                        <canvas id="sales-chart" height="80" width="339"
                                style="display: block; width: 339px; height: 80px;"
                                class="chartjs-render-monitor"></canvas>
                    </div>
                    <div class="card-icon shadow-primary bg-primary">
                        <i class="fas fa-solid fa-user"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?php echo __('admin.new_users', ['default' => 'New Users']); ?></h4>
                        </div>
                        <div class="card-body">
                            <?php echo e(collect($registration_counts)->sum()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <div
                            class="card-stats-title"><?php echo __('admin.order_statistics', ['default' => 'Order Statistics -']); ?>

                            <div class="dropdown d-inline">
                                <a class="font-weight-600 dropdown-toggle" data-toggle="dropdown" href="#"
                                   id="orders-month"><?php echo __('admin.statistics_period_days', ['default' => 'Last :days days', 'days' => request()->input('period', 30)]); ?></a>
                                <ul class="dropdown-menu dropdown-menu-sm">
                                    <li class="dropdown-title"><?php echo __('admin.statistics_select_period', ['default' => 'Select Period']); ?>

                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('admin.view', ['period' => 7])); ?>"
                                           class="dropdown-item <?php if(request()->input('period', 30) == 7): ?> active <?php endif; ?>">
                                            <?php echo __('admin.statistics_period_days', ['default' => 'Last :days days', 'days' => '7']); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('admin.view', ['period' => 30])); ?>"
                                           class="dropdown-item <?php if(request()->input('period', 30) == 30): ?> active <?php endif; ?>">
                                            <?php echo __('admin.statistics_period_days', ['default' => 'Last :days days', 'days' => '30']); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('admin.view', ['period' => 60])); ?>"
                                           class="dropdown-item <?php if(request()->input('period', 30) == 60): ?> active <?php endif; ?>">
                                            <?php echo __('admin.statistics_period_days', ['default' => 'Last :days days', 'days' => '60']); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('admin.view', ['period' => 90])); ?>"
                                           class="dropdown-item <?php if(request()->input('period', 30) == 90): ?> active <?php endif; ?>">
                                            <?php echo __('admin.statistics_period_days', ['default' => 'Last :days days', 'days' => '90']); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('admin.view', ['period' => 365])); ?>"
                                           class="dropdown-item <?php if(request()->input('period', 30) == 365): ?> active <?php endif; ?>">
                                            <?php echo __('admin.statistics_period_days', ['default' => 'Last :days days', 'days' => '365']); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="<?php echo e(route('admin.view', ['period' => 2000])); ?>"
                                           class="dropdown-item <?php if(request()->input('period', 30) == 2000): ?> active <?php endif; ?>">
                                            <?php echo __('admin.statistics_all_time', ['default' => 'All Time']); ?>

                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="chartjs-size-monitor"
                             style="position: absolute; inset: 0px; overflow: hidden; pointer-events: none; visibility: hidden; z-index: -1;">
                            <div class="chartjs-size-monitor-expand"
                                 style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:1000000px;height:1000000px;left:0;top:0"></div>
                            </div>
                            <div class="chartjs-size-monitor-shrink"
                                 style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;">
                                <div style="position:absolute;width:200%;height:200%;left:0; top:0"></div>
                            </div>
                        </div>
                        <canvas id="myChart" height="336" style="display: block; width: 638px; height: 336px;"
                                width="638" class="chartjs-render-monitor"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h4><a href="<?php echo e(route('users.index', ['sort' => 'online'])); ?>"><?php echo __('admin.online_users'); ?></a></h4>
                        <div class="card-header-action">

                        </div>
                    </div>
                    <div class="card-body">
                        <div class="summary">
                            <div class="summary-item">
                                <ul class="list-unstyled list-unstyled-border">
                                    <?php $__currentLoopData = User::getOnlineUsers()->paginate(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="media">
                                            <a href="<?php echo e(route('users.edit', ['user' => $user->id])); ?>">
                                                <img class="mr-3 rounded" width="50" src="<?php echo e($user->avatar()); ?>"
                                                     alt="<?php echo e(__('admin.avatar')); ?>">
                                            </a>
                                            <div class="media-body">
                                                
                                                <div class="media-title"><a
                                                        href="<?php echo e(route('users.edit', ['user' => $user->id])); ?>"><?php echo e($user->username); ?></a>
                                                </div>
                                                <div class="text-muted text-small"><a
                                                        href="<?php echo e(route('users.edit', ['user' => $user->id])); ?>"><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></a>
                                                    <div
                                                        class="bullet"></div> <?php echo e($user->last_seen_at->diffForHumans()); ?>

                                                </div>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header">
                        <h4><?php echo __('admin.recent_registrations', ['default' => 'Recent Registrations']); ?></h4>
                        <div class="card-header-action">

                        </div>
                    </div>
                    <div class="card-body">
                        <div class="summary">
                            <div class="summary-item">
                                <ul class="list-unstyled list-unstyled-border">
                                    <?php $__currentLoopData = User::latest()->paginate(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="media">
                                            <a href="<?php echo e(route('users.edit', ['user' => $user->id])); ?>">
                                                <img class="mr-3 rounded" width="50" src="<?php echo e($user->avatar()); ?>"
                                                     alt="<?php echo e(__('admin.avatar')); ?>">
                                            </a>
                                            <div class="media-body">
                                                <div class="media-right">
                                                    <span
                                                        class="<?php if($user->status == 'pending'): ?> text-warning
                                                        <?php elseif($user->status == 'suspended'): ?> text-danger
                                                        <?php else: ?> text-primary <?php endif; ?>">
                                                        <?php echo __('admin.' . $user->status); ?>

                                                    </span>
                                                </div>
                                                <div class="media-title"><a
                                                        href="<?php echo e(route('users.edit', ['user' => $user->id])); ?>"><?php echo e($user->username); ?></a>
                                                </div>
                                                <div class="text-muted text-small"><a
                                                        href="<?php echo e(route('users.edit', ['user' => $user->id])); ?>"><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></a>
                                                    <div
                                                        class="bullet"></div> <?php echo e($user->created_at->translatedFormat(settings('date_format', 'd M Y'))); ?>

                                                </div>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => __('admin.overview'), 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/overview/index.blade.php ENDPATH**/ ?>