<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'order' => $order,
    'data' => $order->data,
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'order' => $order,
    'data' => $order->data,
]); ?>
<?php foreach (array_filter(([
    'order' => $order,
    'data' => $order->data,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<?php $__currentLoopData = $order->package->service()->getServiceButtons($order)->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $button): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php if(empty($button)): ?>
        <?php continue; ?>;
    <?php endif; ?>
    <<?php echo e($button['tag'] ?? 'a'); ?> href="<?php echo e($button['href'] ?? '#'); ?>" target="<?php echo e($button['target'] ?? ''); ?>" <?php if(isset($button['onclick'])): ?> onclick="<?php echo e($button['onclick']); ?>" <?php endif; ?>
    class="text-white bg-<?php echo e($button['color']); ?>-700 hover:bg-<?php echo e($button['color']); ?>-800 focus:ring-4 focus:ring-<?php echo e($button['color']); ?>-300 font-medium rounded-lg text-sm px-3 py-2 dark:bg-<?php echo e($button['color']); ?>-600 dark:hover:bg-<?php echo e($button['color']); ?>-700 focus:outline-none dark:focus:ring-<?php echo e($button['color']); ?>-800">
    <span class="font-xl mr-1"><?php echo $button['icon'] ?? ''; ?></span>
    <?php echo $button['name']; ?>

    </<?php echo e($button['tag'] ?? 'a'); ?>>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php if(request('page') !== 'manage'): ?>
<a href="<?php echo e(route('service', ['order' => $order->id, 'page' => 'manage'])); ?>"
    class="py-2 px-3 flex items-center text-sm font-medium text-center text-white bg-primary-700 rounded-lg hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1"
        viewbox="0 0 20 20" fill="currentColor" aria-hidden="true">
        <path
            d="M17.414 2.586a2 2 0 00-2.828 0L7 10.172V13h2.828l7.586-7.586a2 2 0 000-2.828z" />
        <path fill-rule="evenodd"
            d="M2 6a2 2 0 012-2h4a1 1 0 010 2H4v10h10v-4a1 1 0 112 0v4a2 2 0 01-2 2H4a2 2 0 01-2-2V6z"
            clip-rule="evenodd" />
    </svg>
    <?php echo __('client.manage'); ?>

</a>
<?php endif; ?>


<?php if($order->getService()->canUpgrade()): ?>
<?php echo $__env->make(Theme::path('components.orders.upgrade-drawer'), $order, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>

<?php if($order->isRecurring()): ?>
    <?php echo $__env->make(Theme::path('components.orders.renew-modal'), $order, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make(Theme::path('components.orders.cancel-modal'), $order, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>

<?php /**PATH /var/www/wemx/resources/themes/client/tailwind/components/orders/buttons.blade.php ENDPATH**/ ?>