<?php $__env->startSection('css_libraries'); ?>
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.css'))); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/css/select2.min.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js_libraries'); ?>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/summernote/summernote-bs4.js'))); ?>"></script>
    <script src="<?php echo e(asset(AdminTheme::assets('modules/select2/dist/js/select2.full.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
    <div class="row">
        <div class="col-12 col-md-12 col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4><?php echo e(__('admin.edit_package')); ?></h4>
                </div>
                <div class="card-body">
                    <ul class="nav nav-tabs mb-4">
                        <li class="nav-item">
                            <a href="<?php echo e(route('packages.edit', $package->id)); ?>" class="nav-link nav-link-tab <?php if($tab == 'index'): ?> active <?php endif; ?>"><?php echo e(__('admin.package')); ?></a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('packages.features', $package->id)); ?>" class="nav-link nav-link-tab <?php if($tab == 'features'): ?> active <?php endif; ?>"><?php echo e(__('admin.features')); ?></a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('packages.prices', $package->id)); ?>" class="nav-link nav-link-tab <?php if($tab == 'prices'): ?> active <?php endif; ?>"><?php echo e(__('admin.prices')); ?></a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('packages.service', $package->id)); ?>" class="nav-link nav-link-tab <?php if($tab == 'service'): ?> active <?php endif; ?>"><?php echo e(__('admin.service')); ?> (<?php echo e(ucfirst($package->service)); ?>)</a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('packages.emails', $package->id)); ?>" class="nav-link nav-link-tab <?php if($tab == 'emails'): ?> active <?php endif; ?>">
                                <?php echo e(__('admin.emails')); ?></a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('packages.webhooks', $package->id)); ?>" class="nav-link nav-link-tab <?php if($tab == 'webhooks'): ?> active <?php endif; ?>">
                                <?php echo e(__('admin.webhooks')); ?></a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('packages.links', $package->id)); ?>" class="nav-link nav-link-tab <?php if($tab == 'links'): ?> active <?php endif; ?>"><?php echo e(__('admin.links')); ?></a>
                        </li>
                    </ul>

                    <div class="tab-content">
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <style>
        span.select2.select2-container.select2-container--default {
            width: 100% !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(AdminTheme::wrapper(), ['title' => $title ?? 'Package', 'keywords' => 'WemX Dashboard, WemX Panel'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/wemx/resources/themes/admin/default/packages/edit/master.blade.php ENDPATH**/ ?>